/*
 * Decompiled with CFR 0.152.
 */
package javagen.umlparser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javagen.umlparser.UmlUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Package;

public class ClassifierCatalog {
    public static final String WILDCARD = "*";
    protected Resource model;
    private Package modelRootPackage;
    private Package currentCompilationUnitPackage;
    protected List<SearchPackage> paths = new ArrayList<SearchPackage>();

    public ClassifierCatalog(Resource model) {
        this.model = model;
        this.paths.add(new ResourceSearchPackage());
    }

    public ClassifierCatalog(Resource model, List<String> packageNames) {
        this.model = model;
        for (String name : packageNames) {
            if ("/".equals(name)) {
                this.paths.add(new ResourceSearchPackage());
                continue;
            }
            List<String> qualifiedName = this.dirToQualifiedName(name);
            this.paths.add(new ResourceRelativeSearchPackage(qualifiedName));
        }
    }

    public ClassifierCatalog(Package modelRootPackage, List<String> packageNames) {
        this.modelRootPackage = modelRootPackage;
        for (String name : packageNames) {
            if ("/".equals(name)) {
                this.paths.add(new ResourceSearchPackage());
                continue;
            }
            List<String> qualifiedName = this.dirToQualifiedName(name);
            if (name.contains(WILDCARD)) {
                this.paths.add(new RelativeSearchPackageWithWildcard(qualifiedName));
                continue;
            }
            this.paths.add(new RelativeSearchPackage(qualifiedName));
        }
    }

    public void setCurrentCompilationUnitPackage(Package currentCompilationUnitPackage) {
        this.currentCompilationUnitPackage = currentCompilationUnitPackage;
    }

    private List<String> dirToQualifiedName(String qname) {
        String[] splittedName = qname.split("/");
        return Arrays.asList(splittedName);
    }

    public Classifier getClassifier(String qualifiedName) {
        List<String> qname = UmlUtils.toQualifiedName(qualifiedName);
        return this.getClassifier(qname);
    }

    public Classifier getClassifier(List<String> qualifiedName) {
        return this.lookupNamedElement(qualifiedName, null);
    }

    private Classifier lookupNamedElement(List<String> qualifiedName, EClass type) {
        Classifier res;
        if (this.currentCompilationUnitPackage != null && (res = (Classifier)UmlUtils.lookupClassifier(this.currentCompilationUnitPackage, qualifiedName, type)) != null) {
            return res;
        }
        for (SearchPackage path : this.paths) {
            Classifier res2 = path.getUmlClassifier(qualifiedName, type);
            if (res2 == null) continue;
            return res2;
        }
        return null;
    }

    private class RelativeSearchPackage
    extends SearchPackage {
        public RelativeSearchPackage(List<String> qualifiedName) {
            super(qualifiedName);
        }

        private Package getPathPackage() {
            if (this.umlPackage != null) {
                return this.umlPackage;
            }
            this.umlPackage = UmlUtils.lookupPackage(ClassifierCatalog.this.modelRootPackage, (List<String>)this.packageQualifiedName);
            return this.umlPackage;
        }

        @Override
        public Classifier getUmlClassifier(List<String> qualifiedName, EClass expectedType) {
            Package p = this.getPathPackage();
            if (p == null) {
                return null;
            }
            return (Classifier)UmlUtils.lookupClassifier(p, qualifiedName, expectedType);
        }
    }

    private class RelativeSearchPackageWithWildcard
    extends SearchPackage {
        public RelativeSearchPackageWithWildcard(List<String> searchpath) {
            super(searchpath);
        }

        private List<Package> lookupExistingPackages() {
            if (this.umlPackage == null) {
                this.umlPackage = UmlUtils.lookupPackageBeforeWildcard(ClassifierCatalog.this.modelRootPackage, this.packageQualifiedName);
            }
            if (this.umlPackage == null) {
                return Collections.emptyList();
            }
            EList existingPackages = this.umlPackage.getNestedPackages();
            return existingPackages;
        }

        @Override
        public Classifier getUmlClassifier(List<String> qualifiedName, EClass expectedType) {
            int wildcardIndex = this.packageQualifiedName.indexOf(ClassifierCatalog.WILDCARD);
            List<Package> existingPackages = this.lookupExistingPackages();
            List<String> remainingPath = qualifiedName.subList(wildcardIndex + 1, qualifiedName.size());
            for (Package nestedPackage : existingPackages) {
                Classifier res = (Classifier)UmlUtils.lookupClassifier(nestedPackage, qualifiedName, expectedType);
                if (res == null) continue;
                return res;
            }
            return null;
        }
    }

    private class ResourceRelativeSearchPackage
    extends SearchPackage {
        public ResourceRelativeSearchPackage(List<String> qualifiedName) {
            super(qualifiedName);
        }

        private Package getPathPackage() {
            if (this.umlPackage != null) {
                return this.umlPackage;
            }
            this.umlPackage = UmlUtils.lookupPackage(ClassifierCatalog.this.model, (List<String>)this.packageQualifiedName);
            return this.umlPackage;
        }

        @Override
        public Classifier getUmlClassifier(List<String> qualifiedName, EClass expectedType) {
            Package p = this.getPathPackage();
            if (p == null) {
                return null;
            }
            return (Classifier)UmlUtils.lookupClassifier(p, qualifiedName, expectedType);
        }
    }

    private class ResourceSearchPackage
    extends SearchPackage {
        public ResourceSearchPackage() {
            super(null);
        }

        @Override
        public Classifier getUmlClassifier(List<String> qualifiedName, EClass expectedType) {
            return (Classifier)UmlUtils.lookupClassifier(ClassifierCatalog.this.model, qualifiedName, expectedType);
        }
    }

    private abstract class SearchPackage {
        protected Package umlPackage;
        protected List<String> packageQualifiedName;

        public SearchPackage(List<String> qualifiedName) {
            this.packageQualifiedName = qualifiedName;
        }

        public abstract Classifier getUmlClassifier(List<String> var1, EClass var2);
    }
}

