/*
 * Decompiled with CFR 0.152.
 */
package javagen.umlparser;

import japa.parser.ast.CompilationUnit;
import japa.parser.ast.ImportDeclaration;
import japa.parser.ast.Node;
import japa.parser.ast.PackageDeclaration;
import japa.parser.ast.body.BodyDeclaration;
import japa.parser.ast.body.ClassOrInterfaceDeclaration;
import japa.parser.ast.body.FieldDeclaration;
import japa.parser.ast.body.JavadocComment;
import japa.parser.ast.body.MethodDeclaration;
import japa.parser.ast.body.ModifierSet;
import japa.parser.ast.body.Parameter;
import japa.parser.ast.body.TypeDeclaration;
import japa.parser.ast.body.VariableDeclarator;
import japa.parser.ast.expr.AnnotationExpr;
import japa.parser.ast.expr.NameExpr;
import japa.parser.ast.expr.QualifiedNameExpr;
import japa.parser.ast.type.ClassOrInterfaceType;
import japa.parser.ast.type.PrimitiveType;
import japa.parser.ast.type.ReferenceType;
import japa.parser.ast.type.Type;
import japa.parser.ast.type.VoidType;
import japa.parser.ast.type.WildcardType;
import japa.parser.ast.visitor.VoidVisitorAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javagen.umlparser.ClassifierCatalog;
import javagen.umlparser.CreationPackageCatalog;
import javagen.umlparser.GenericSwitchVisitor;
import javagen.umlparser.ImportedTypeCatalog;
import javagen.umlparser.SwitchVisitor;
import javagen.umlparser.TypeAnalyserAndTranslator;
import javagen.umlparser.UmlUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.uml2.uml.BehavioredClassifier;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Feature;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.VisibilityKind;

public class CompilationUnitAnalyser {
    public static String DEFAULT_GENERATION_PACKAGE_NAME = "generated";
    public static String DEFAULT_ROOT_PACKAGE_NAME = "model";
    private List<String> generationPackageQualifiedName;
    private Package defaultGenerationPackage;
    private CreationPackageCatalog creationPackageCatalog;
    private ClassifierCatalog classifierCatalog;
    private ImportedTypeCatalog importedTypes;
    private Package currentCompilationUnitPackage;
    private List<Namespace> enclosingNamespaces = new ArrayList<Namespace>();
    private QualifiedNameParser qualifiedNameParser = new QualifiedNameParser();
    private TypeAnalyserAndTranslator typeAnalyser;

    public CompilationUnitAnalyser(Resource model) {
        this(model, DEFAULT_ROOT_PACKAGE_NAME, DEFAULT_GENERATION_PACKAGE_NAME, null);
    }

    public CompilationUnitAnalyser(Resource model, String generatePackageName, List<String> searchPaths) {
        this(model, DEFAULT_ROOT_PACKAGE_NAME, generatePackageName, searchPaths);
    }

    public CompilationUnitAnalyser(Resource model, String modelRootPackageName, String generatePackageName, List<String> searchPaths) {
        Package modelRootPackage = UmlUtils.getPackage(model, this.dirToQualifiedName(modelRootPackageName));
        this.initCompilationUnitAnalyser(modelRootPackage, generatePackageName, searchPaths);
    }

    public CompilationUnitAnalyser(Package modelRootPackage, String generatePackageName, List<String> searchPaths) {
        this.initCompilationUnitAnalyser(modelRootPackage, generatePackageName, searchPaths);
    }

    private void initCompilationUnitAnalyser(Package modelRootPackage, String generatePackageName, List<String> searchPaths) {
        if (generatePackageName == null) {
            generatePackageName = DEFAULT_GENERATION_PACKAGE_NAME;
        }
        this.generationPackageQualifiedName = this.dirToQualifiedName(generatePackageName);
        if (!(searchPaths = searchPaths != null ? new ArrayList<String>(searchPaths) : new ArrayList<String>()).contains(generatePackageName)) {
            searchPaths.add(generatePackageName);
        }
        System.out.println(String.valueOf(this.getClass().getSimpleName()) + ".CT(" + this.generationPackageQualifiedName + ", sarchpaths=" + searchPaths + ")");
        this.createDefaultGenerationPackage(modelRootPackage);
        this.classifierCatalog = new ClassifierCatalog(modelRootPackage, searchPaths);
        this.importedTypes = new ImportedTypeCatalog();
        this.creationPackageCatalog = new CreationPackageCatalog(modelRootPackage, this.defaultGenerationPackage, null);
        this.typeAnalyser = new TypeAnalyserAndTranslator(this.importedTypes);
    }

    private List<String> dirToQualifiedName(String qname) {
        String[] splittedName = qname.split("/");
        return Arrays.asList(splittedName);
    }

    private void createDefaultGenerationPackage(Resource model) {
        Package p;
        this.defaultGenerationPackage = p = UmlUtils.getPackage(model, this.generationPackageQualifiedName);
    }

    private void createDefaultGenerationPackage(Package rootModelElement) {
        Package p;
        this.defaultGenerationPackage = p = UmlUtils.getModel(rootModelElement, this.generationPackageQualifiedName);
    }

    public void processCompilationUnit(CompilationUnit cu) {
        this.currentCompilationUnitPackage = this.getCuPackage(cu.getPakage());
        this.classifierCatalog.setCurrentCompilationUnitPackage(this.currentCompilationUnitPackage);
        this.importedTypes.clear();
        if (cu.getImports() != null) {
            this.addImports(this.importedTypes, cu.getImports());
        }
        if (cu.getTypes() != null) {
            for (TypeDeclaration typeDecl : cu.getTypes()) {
                this.enclosingNamespaces.add((Namespace)this.currentCompilationUnitPackage);
                this.processTypedeclaration(this.enclosingNamespaces, typeDecl);
                this.enclosingNamespaces.clear();
            }
        }
    }

    private void processTypedeclaration(final List<Namespace> enclosingParents, TypeDeclaration typeDecl) {
        Classifier classifier = (Classifier)new GenericSwitchVisitor<Classifier, List<Namespace>>(){

            @Override
            public Classifier visit(ClassOrInterfaceDeclaration n, List<Namespace> enclosingParents) {
                return CompilationUnitAnalyser.this.processClassOrInterfaceDeclaration(n, enclosingParents);
            }
        }.doSwitch(typeDecl, enclosingParents);
        this.createModifiers(classifier, typeDecl.getModifiers());
        if (typeDecl.getMembers() != null) {
            for (BodyDeclaration member : typeDecl.getMembers()) {
                new SwitchVisitor<org.eclipse.uml2.uml.Type>(){

                    @Override
                    public void visit(FieldDeclaration n, org.eclipse.uml2.uml.Type classifier) {
                        CompilationUnitAnalyser.this.createAttributes(n, classifier);
                    }

                    @Override
                    public void visit(MethodDeclaration n, org.eclipse.uml2.uml.Type classifier) {
                        CompilationUnitAnalyser.this.processMethod(n, (Classifier)classifier);
                    }

                    @Override
                    public void visit(ClassOrInterfaceDeclaration n, org.eclipse.uml2.uml.Type classifier) {
                        System.out.println("Found nested class (ClassOrInterface)'" + n.getName() + "'");
                        enclosingParents.add((Classifier)classifier);
                        CompilationUnitAnalyser.this.processTypedeclaration(enclosingParents, n);
                        enclosingParents.remove(classifier);
                        super.visit(n, classifier);
                    }
                }.doSwitch(member, (org.eclipse.uml2.uml.Type)classifier);
            }
        }
    }

    private void addImports(ImportedTypeCatalog importedTypes, List<ImportDeclaration> imports) {
        for (ImportDeclaration decl : imports) {
            List<String> qualifiedName = this.qualifiedNameParser.getImportQualifiedName(decl);
            if (decl.isAsterisk()) {
                qualifiedName.add("*");
            }
            importedTypes.addImport(qualifiedName);
        }
    }

    private Classifier getUmlClassifier(List<String> qualifiedName, boolean isInterface) {
        Classifier foundClass = this.classifierCatalog.getClassifier(qualifiedName);
        if (foundClass == null) {
            EClass expectedType = isInterface ? UMLPackage.eINSTANCE.getInterface() : UMLPackage.eINSTANCE.getClass_();
            if (this.importedTypes.isImportedType(qualifiedName)) {
                Package creationPackage = this.creationPackageCatalog.getCreationPackage(qualifiedName);
                foundClass = (Classifier)UmlUtils.getClassifier(creationPackage, qualifiedName, expectedType);
            } else {
                foundClass = UmlUtils.getGuessedClassifier(this.enclosingNamespaces, qualifiedName, expectedType);
            }
        }
        return foundClass;
    }

    private List<String> getQualifiedName(ClassOrInterfaceType astType) {
        QualifiedNameParser visitor = new QualifiedNameParser();
        List<String> res = visitor.getClassOrInterfaceQualifiedName(astType);
        return res;
    }

    protected void createAttributes(FieldDeclaration n, org.eclipse.uml2.uml.Type parent) {
        System.out.println("getAttributeType( from:" + n.getType().getClass().getName() + ")");
        TypeAnalyserAndTranslator.TranslatedTypeData typeData = this.processType(n.getType());
        org.eclipse.uml2.uml.Type umlType = this.getUmlType(typeData);
        for (VariableDeclarator var : n.getVariables()) {
            if (!(parent instanceof Classifier)) continue;
            this.createAttribute(n, var, (Classifier)parent, umlType, typeData);
        }
    }

    private TypeAnalyserAndTranslator.TranslatedTypeData processType(Type astType) {
        TypeAnalyserAndTranslator.TranslatedTypeData data = this.typeAnalyser.getTranslatedTypeData(astType);
        return data;
    }

    private org.eclipse.uml2.uml.Type getUmlType(TypeAnalyserAndTranslator.TranslatedTypeData data) {
        Classifier umlType = null;
        if (data.isPrimitive) {
            umlType = this.classifierCatalog.getClassifier(data.qualifiedName);
            if (umlType == null) {
                Package creationPackage = this.creationPackageCatalog.getCreationPackage(data.qualifiedName);
                umlType = UmlUtils.getPrimitive(creationPackage, data.qualifiedName);
            }
        } else {
            if (data.isVoid || data.isWildcard) {
                return null;
            }
            List<String> qualifiedName = data.getTranslatedQualifiedName();
            boolean isInterface = false;
            String shortName = qualifiedName.get(qualifiedName.size() - 1);
            if (shortName.length() > 2 && shortName.startsWith("I") && Character.isUpperCase(shortName.charAt(1))) {
                isInterface = true;
            }
            umlType = this.getUmlClassifier(qualifiedName, isInterface);
        }
        return umlType;
    }

    protected TypeData getAttributeType(Type astType) {
        TypeData res = new TypeData();
        new SwitchVisitor<TypeData>(){

            @Override
            public void visit(ClassOrInterfaceType n, TypeData data) {
                List qnameBefore = CompilationUnitAnalyser.this.getQualifiedName(n);
                List<String> qname = CompilationUnitAnalyser.this.importedTypes.getQualifiedName(qnameBefore);
                data.qualifiedName = qname;
                if (n.getTypeArgs() != null) {
                    data.genericData = new ArrayList<TypeData>();
                    for (Type arg : n.getTypeArgs()) {
                        TypeData argData = new TypeData();
                        arg.accept(this, argData);
                        data.genericData.add(argData);
                    }
                }
            }

            @Override
            public void visit(ReferenceType n, TypeData data) {
                data.arrayCount = n.getArrayCount();
                n.getType().accept(this, data);
            }

            @Override
            public void visit(PrimitiveType n, TypeData data) {
                String qnameBefore = CompilationUnitAnalyser.this.getPrimitiveName(n);
                List<String> qname = CompilationUnitAnalyser.this.importedTypes.getQualifiedName(qnameBefore);
                data.qualifiedName = qname;
                data.isPrimitive = true;
            }

            @Override
            public void visit(WildcardType n, TypeData data) {
                data.isWildcard = true;
                if (n.getExtends() != null) {
                    data.extends_ = new TypeData();
                    n.getExtends().accept(this, data.extends_);
                }
                if (n.getSuper() != null) {
                    data.super_ = new TypeData();
                    n.getSuper().accept(this, data.super_);
                }
            }

            @Override
            public void visit(VoidType n, TypeData data) {
                data.isVoid = true;
            }
        }.doSwitch(astType, res);
        return res;
    }

    protected String getPrimitiveName(PrimitiveType n) {
        String typeName = null;
        switch (n.getType()) {
            case Boolean: {
                typeName = "Boolean";
                break;
            }
            case Byte: {
                typeName = "Byte";
                break;
            }
            case Char: {
                typeName = "Char";
                break;
            }
            case Double: {
                typeName = "Double";
                break;
            }
            case Float: {
                typeName = "Float";
                break;
            }
            case Int: {
                typeName = "Integer";
                break;
            }
            case Long: {
                typeName = "Long";
                break;
            }
            case Short: {
                typeName = "Short";
            }
        }
        return typeName;
    }

    protected void createAttribute(FieldDeclaration n, VariableDeclarator var, Classifier parent, org.eclipse.uml2.uml.Type type, TypeAnalyserAndTranslator.TranslatedTypeData typeData) {
        Property property = UmlUtils.createProperty(parent, null, var.getId().getName(), var.getId().getArrayCount());
        property.setType(type);
        this.processJavadoc(n.getJavaDoc(), (Element)property);
        this.processModifiers(n.getModifiers(), (Feature)property);
        if (typeData.isCollection()) {
            property.setLower(typeData.getTranslatedLower());
            property.setUpper(typeData.getTranslatedUpper());
        }
    }

    private void processModifiers(int modifiers, Operation property) {
        if (ModifierSet.isAbstract(modifiers)) {
            property.setIsAbstract(true);
        }
        this.processModifiers(modifiers, (Feature)property);
    }

    private void processModifiers(int modifiers, Feature property) {
        if (ModifierSet.isPrivate(modifiers)) {
            property.setVisibility(VisibilityKind.PRIVATE_LITERAL);
        }
        if (ModifierSet.isProtected(modifiers)) {
            property.setVisibility(VisibilityKind.PROTECTED_LITERAL);
        }
        if (ModifierSet.isPublic(modifiers)) {
            property.setVisibility(VisibilityKind.PUBLIC_LITERAL);
        }
        if (ModifierSet.isStatic(modifiers)) {
            property.setIsStatic(true);
        }
        if (ModifierSet.isFinal(modifiers)) {
            property.setIsLeaf(true);
        }
    }

    private void processModifiers(int modifiers, org.eclipse.uml2.uml.Parameter property) {
        if (ModifierSet.isPrivate(modifiers)) {
            property.setVisibility(VisibilityKind.PRIVATE_LITERAL);
        }
        if (ModifierSet.isProtected(modifiers)) {
            property.setVisibility(VisibilityKind.PROTECTED_LITERAL);
        }
        if (ModifierSet.isPublic(modifiers)) {
            property.setVisibility(VisibilityKind.PUBLIC_LITERAL);
        }
        if (ModifierSet.isFinal(modifiers)) {
            property.setDirection(ParameterDirectionKind.IN_LITERAL);
        }
    }

    protected void processMethod(MethodDeclaration n, Classifier classifier) {
        ArrayList<org.eclipse.uml2.uml.Type> signature = new ArrayList<org.eclipse.uml2.uml.Type>();
        if (n.getParameters() != null) {
            ArrayList<MethodParameterData> paramDatas = new ArrayList<MethodParameterData>();
            for (Parameter param : n.getParameters()) {
                MethodParameterData data = new MethodParameterData();
                data.dataType = this.processType(param.getType());
                data.umlType = this.getUmlType(data.dataType);
                data.astParameter = param;
                paramDatas.add(data);
                signature.add(data.umlType);
            }
        }
        Operation method = this.getUmlOperation(classifier, n.getName(), signature);
        this.processJavadoc(n.getJavaDoc(), (Element)method);
        this.processAnnotation(n.getAnnotations(), (Element)method);
        this.processModifiers(n.getModifiers(), method);
        TypeAnalyserAndTranslator.TranslatedTypeData typeData = this.processType(n.getType());
        org.eclipse.uml2.uml.Type methodType = this.getUmlType(typeData);
        if (methodType != null) {
            method.setType(methodType);
            if (typeData.isCollection()) {
                method.setLower(typeData.getTranslatedLower());
                method.setUpper(typeData.getTranslatedUpper());
            }
        }
        if (n.getParameters() != null) {
            for (Parameter param : n.getParameters()) {
                this.processMethodParameter(param, method);
            }
        }
    }

    private Operation getUmlOperation(Classifier classifier, String name, List<org.eclipse.uml2.uml.Type> signature) {
        EList list = classifier.getOperations();
        for (Operation oper : list) {
            if (!this.isSameOperation(oper, name, signature)) continue;
            return oper;
        }
        return UmlUtils.createOperation(classifier, name);
    }

    private boolean isSameOperation(Operation oper, String name, List<org.eclipse.uml2.uml.Type> signature) {
        if (!name.equals(oper.getName())) {
            return false;
        }
        EList umlParams = oper.getOwnedParameters();
        if (signature == null) {
            return true;
        }
        if (umlParams == null) {
            return signature.size() == 0;
        }
        if (umlParams != null) {
            int umlParamIndex = 0;
            for (org.eclipse.uml2.uml.Type signatureType : signature) {
                try {
                    org.eclipse.uml2.uml.Parameter param = (org.eclipse.uml2.uml.Parameter)umlParams.get(umlParamIndex++);
                    while (param.getDirection() == ParameterDirectionKind.RETURN_LITERAL) {
                        param = (org.eclipse.uml2.uml.Parameter)umlParams.get(umlParamIndex++);
                    }
                    org.eclipse.uml2.uml.Type existingType = param.getType();
                    if (existingType == null || existingType.getName().equals(signatureType.getName())) continue;
                    return false;
                }
                catch (IndexOutOfBoundsException e) {
                    return false;
                }
            }
            while (umlParamIndex < umlParams.size()) {
                if (((org.eclipse.uml2.uml.Parameter)umlParams.get(umlParamIndex++)).getDirection() == ParameterDirectionKind.RETURN_LITERAL) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void processMethodParameter(Parameter param, Operation method) {
        TypeAnalyserAndTranslator.TranslatedTypeData typeData = this.processType(param.getType());
        org.eclipse.uml2.uml.Type type = this.getUmlType(typeData);
        System.out.println("getOwnedParameter(" + method.getName() + "= " + param.getId().getName() + ", " + type + " )");
        org.eclipse.uml2.uml.Parameter umlParameter = method.getOwnedParameter(param.getId().getName(), type, true, true);
        if (typeData.isCollection()) {
            umlParameter.setLower(typeData.getTranslatedLower());
            umlParameter.setUpper(typeData.getTranslatedUpper());
        }
        this.processModifiers(param.getModifiers(), umlParameter);
        this.processAnnotation(param.getAnnotations(), (Element)method);
    }

    private void processAnnotation(List<AnnotationExpr> annotations, Element method) {
    }

    private void processJavadoc(JavadocComment javaDoc, Element umlElement) {
        if (javaDoc == null) {
            return;
        }
        EList ownedComments = umlElement.getOwnedComments();
        Comment comment = ownedComments != null && ownedComments.size() > 0 ? (Comment)ownedComments.get(0) : umlElement.createOwnedComment();
        comment.setBody(javaDoc.getContent());
    }

    protected Class createClass(List<Namespace> enclosingParents, ClassOrInterfaceDeclaration n) {
        System.out.println("getClass( " + n.getName() + " )");
        return UmlUtils.getClass(enclosingParents, n.getName());
    }

    protected Interface createInterface(List<Namespace> enclosingParents, ClassOrInterfaceDeclaration n) {
        System.out.println("getInterface( " + n.getName() + " )");
        return UmlUtils.getInterface(enclosingParents, n.getName());
    }

    private Package getCuPackage(PackageDeclaration packageDecl) {
        if (packageDecl == null) {
            return this.defaultGenerationPackage;
        }
        List<String> qualifiedName = this.qualifiedNameParser.getPackageQualifiedName(packageDecl);
        Package creationPackage = this.creationPackageCatalog.getCreationPackage(qualifiedName);
        Package p = UmlUtils.getPackage(creationPackage, qualifiedName);
        return p;
    }

    private void createModifiers(Classifier c, int modifiers) {
        if (ModifierSet.isPrivate(modifiers)) {
            c.setVisibility(VisibilityKind.PRIVATE_LITERAL);
        }
        if (ModifierSet.isProtected(modifiers)) {
            c.setVisibility(VisibilityKind.PROTECTED_LITERAL);
        }
        if (ModifierSet.isPublic(modifiers)) {
            c.setVisibility(VisibilityKind.PUBLIC_LITERAL);
        }
        if (ModifierSet.isAbstract(modifiers)) {
            c.setIsAbstract(true);
        }
        if (ModifierSet.isFinal(modifiers)) {
            c.setIsLeaf(true);
        }
    }

    private Classifier processClassOrInterfaceDeclaration(ClassOrInterfaceDeclaration n, List<Namespace> enclosingParents) {
        Classifier generalization;
        List<String> qualifiedName;
        Object processedClass = n.isInterface() ? this.createInterface(enclosingParents, n) : this.createClass(enclosingParents, n);
        this.processJavadoc(n.getJavaDoc(), (Element)processedClass);
        if (n.getExtends() != null) {
            for (ClassOrInterfaceType type : n.getExtends()) {
                qualifiedName = this.getQualifiedName(type);
                qualifiedName = this.importedTypes.getQualifiedName(qualifiedName);
                generalization = this.getUmlClassifier(qualifiedName, n.isInterface());
                UmlUtils.getGeneralization((Classifier)processedClass, generalization);
            }
        }
        if (n.getImplements() != null) {
            for (ClassOrInterfaceType type : n.getImplements()) {
                qualifiedName = this.getQualifiedName(type);
                qualifiedName = this.importedTypes.getQualifiedName(qualifiedName);
                generalization = this.getUmlClassifier(qualifiedName, true);
                Package parentPackage = (Package)enclosingParents.get(0);
                if (generalization instanceof Interface && processedClass instanceof BehavioredClassifier) {
                    UmlUtils.getInterfaceRealization((BehavioredClassifier)processedClass, (Interface)generalization);
                    continue;
                }
                UmlUtils.getGeneralization((Classifier)processedClass, generalization);
            }
        }
        return processedClass;
    }

    protected class CreatePackage
    extends VoidVisitorAdapter<List<String>> {
        protected CreatePackage() {
        }

        public Package getPackage(PackageDeclaration decl, Package parent) {
            ArrayList names = new ArrayList();
            decl.accept(this, names);
            Package p = parent;
            for (String packageName : names) {
                p = UmlUtils.getPackage(p, packageName);
            }
            return p;
        }

        @Override
        public void visit(NameExpr n, List<String> names) {
            names.add(0, n.getName());
            super.visit(n, names);
        }

        @Override
        public void visit(QualifiedNameExpr n, List<String> names) {
            names.add(0, n.getName());
            super.visit(n, names);
        }
    }

    private class MethodParameterData {
        TypeAnalyserAndTranslator.TranslatedTypeData dataType;
        org.eclipse.uml2.uml.Type umlType;
        Parameter astParameter;

        private MethodParameterData() {
        }
    }

    protected class QualifiedNameParser
    extends VoidVisitorAdapter<List<String>> {
        protected QualifiedNameParser() {
        }

        public List<String> getClassOrInterfaceQualifiedName(ClassOrInterfaceType n) {
            ArrayList<String> res = new ArrayList<String>();
            n.accept(this, res);
            return res;
        }

        public List<String> getPackageQualifiedName(PackageDeclaration n) {
            ArrayList<String> res = new ArrayList<String>();
            n.accept(this, res);
            return res;
        }

        public List<String> getImportQualifiedName(ImportDeclaration n) {
            return this.getQualifiedName(n);
        }

        private List<String> getQualifiedName(Node n) {
            ArrayList<String> res = new ArrayList<String>();
            n.accept(this, res);
            return res;
        }

        @Override
        public void visit(ClassOrInterfaceType n, List<String> names) {
            names.add(0, n.getName());
            if (n.getScope() != null) {
                n.getScope().accept(this, names);
            }
        }

        @Override
        public void visit(NameExpr n, List<String> names) {
            names.add(0, n.getName());
        }

        @Override
        public void visit(QualifiedNameExpr n, List<String> names) {
            names.add(0, n.getName());
            if (n.getQualifier() != null) {
                n.getQualifier().accept(this, names);
            }
        }
    }

    protected class TypeData {
        List<String> qualifiedName;
        protected List<TypeData> genericData;
        boolean isInterface = false;
        boolean isPrimitive = false;
        protected int arrayCount;
        protected boolean isWildcard = false;
        protected TypeData extends_;
        protected TypeData super_;
        protected boolean isVoid = false;

        protected TypeData() {
        }
    }
}

