/*
 * Decompiled with CFR 0.152.
 */
package javagen.umlparser;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javagen.umlparser.UmlUtils;

public class ImportedTypeCatalog {
    private Map<String, List<String>> map = new HashMap<String, List<String>>();
    public String[] defaultMappingNames = new String[]{"String", "java.lang.String", "Class", "java.lang.Class", "Object", "java.lang.Object", "Exception", "java.lang.Exception", "Integer", "datatype.Integer", "Boolean", "datatype.Boolean", "Long", "datatype.Long", "Char", "datatype.Char", "Byte", "datatype.Byte", "Runnable", "java.lang.Runnable", "Throwable", "java.lang.Throwable", "Thread", "java.lang.Thread"};

    public ImportedTypeCatalog() {
        this.setDefaultMapping(this.defaultMappingNames);
    }

    private void setDefaultMapping(String[] defaultMappingNames) {
        int i = 0;
        while (i < defaultMappingNames.length) {
            this.map.put(defaultMappingNames[i], UmlUtils.toQualifiedName(defaultMappingNames[i + 1]));
            System.out.println("setDefaultMapping().add(" + defaultMappingNames[i] + ", " + UmlUtils.toQualifiedName(defaultMappingNames[i + 1]) + ")");
            i += 2;
        }
    }

    public List<String> getQualifiedName(String name) {
        List<String> res = this.map.get(name);
        if (res == null) {
            res = UmlUtils.toQualifiedName(name);
        }
        return res;
    }

    private List<String> lookupQualifiedName(String name) {
        List<String> res = this.map.get(name);
        return res;
    }

    public List<String> getQualifiedName(List<String> possiblyQualifiedName) {
        if (possiblyQualifiedName.size() == 1) {
            List<String> res = this.lookupQualifiedName(possiblyQualifiedName.get(0));
            if (res == null) {
                res = possiblyQualifiedName;
            }
            return res;
        }
        return possiblyQualifiedName;
    }

    public boolean isImportedType(List<String> qualifiedName) {
        String lastName = qualifiedName.get(qualifiedName.size() - 1);
        List<String> found = this.map.get(lastName);
        return found != null && found.equals(qualifiedName);
    }

    public void addImport(List<String> qualifiedName) {
        String lastName = qualifiedName.get(qualifiedName.size() - 1);
        System.out.println("ImportedCatalog.add(" + qualifiedName + ")");
        if ("*".equals(lastName)) {
            this.addPackageClasses(qualifiedName);
        } else {
            this.map.put(lastName, qualifiedName);
        }
    }

    private void addPackageClasses(List<String> qualifiedName) {
        System.err.println(String.valueOf(this.getClass().getName()) + ".addPackageClasses() - Not yet implemented - can't process import with 'p1.p2.*;'");
    }

    public void clear() {
        this.map.clear();
        this.setDefaultMapping(this.defaultMappingNames);
    }
}

