/*
 * Decompiled with CFR 0.152.
 */
package javagen.umlparser;

import japa.parser.ast.type.ClassOrInterfaceType;
import japa.parser.ast.type.PrimitiveType;
import japa.parser.ast.type.ReferenceType;
import japa.parser.ast.type.Type;
import japa.parser.ast.type.VoidType;
import japa.parser.ast.type.WildcardType;
import java.util.ArrayList;
import java.util.List;
import javagen.umlparser.ImportedTypeCatalog;
import javagen.umlparser.SwitchVisitor;

public class TypeAnalyser {
    private ImportedTypeCatalog importedTypes;

    public TypeAnalyser(ImportedTypeCatalog importedType) {
        this.importedTypes = importedType;
    }

    public TypeData getTypeData(Type astType) {
        TypeData res = this.createTypeData();
        new SwitchVisitor<TypeData>(){

            @Override
            public void visit(ClassOrInterfaceType n, TypeData data) {
                List qnameBefore = TypeAnalyser.this.getQualifiedName(n);
                List<String> qname = TypeAnalyser.this.importedTypes.getQualifiedName(qnameBefore);
                data.qualifiedName = qname;
                if (n.getTypeArgs() != null) {
                    data.genericData = new ArrayList<TypeData>();
                    for (Type arg : n.getTypeArgs()) {
                        TypeData argData = TypeAnalyser.this.createTypeData();
                        arg.accept(this, argData);
                        data.genericData.add(argData);
                    }
                }
            }

            @Override
            public void visit(ReferenceType n, TypeData data) {
                data.arrayCount = n.getArrayCount();
                n.getType().accept(this, data);
            }

            @Override
            public void visit(PrimitiveType n, TypeData data) {
                String qnameBefore = TypeAnalyser.this.getPrimitiveName(n);
                List<String> qname = TypeAnalyser.this.importedTypes.getQualifiedName(qnameBefore);
                data.qualifiedName = qname;
                data.isPrimitive = true;
            }

            @Override
            public void visit(WildcardType n, TypeData data) {
                data.isWildcard = true;
                if (n.getExtends() != null) {
                    data.extends_ = TypeAnalyser.this.createTypeData();
                    n.getExtends().accept(this, data.extends_);
                }
                if (n.getSuper() != null) {
                    data.super_ = TypeAnalyser.this.createTypeData();
                    n.getSuper().accept(this, data.super_);
                }
            }

            @Override
            public void visit(VoidType n, TypeData data) {
                data.isVoid = true;
            }
        }.doSwitch(astType, res);
        return res;
    }

    protected TypeData createTypeData() {
        return new TypeData();
    }

    private List<String> getQualifiedName(ClassOrInterfaceType n) {
        ArrayList<String> qname = new ArrayList<String>();
        this.getQualifiedName(n, qname);
        return qname;
    }

    private void getQualifiedName(ClassOrInterfaceType n, List<String> qname) {
        if (n.getScope() != null) {
            this.getQualifiedName(n.getScope(), qname);
        }
        qname.add(n.getName());
    }

    private String getPrimitiveName(PrimitiveType n) {
        String typeName = null;
        switch (n.getType()) {
            case Boolean: {
                typeName = "Boolean";
                break;
            }
            case Byte: {
                typeName = "Byte";
                break;
            }
            case Char: {
                typeName = "Char";
                break;
            }
            case Double: {
                typeName = "Double";
                break;
            }
            case Float: {
                typeName = "Float";
                break;
            }
            case Int: {
                typeName = "Integer";
                break;
            }
            case Long: {
                typeName = "Long";
                break;
            }
            case Short: {
                typeName = "Short";
            }
        }
        return typeName;
    }

    public class TypeData {
        List<String> qualifiedName;
        protected List<TypeData> genericData;
        boolean isInterface = false;
        boolean isPrimitive = false;
        protected int arrayCount;
        protected boolean isWildcard = false;
        protected TypeData extends_;
        protected TypeData super_;
        protected boolean isVoid = false;
    }
}

