/*
 * Decompiled with CFR 0.152.
 */
package javagen.umlparser;

import java.util.Arrays;
import java.util.List;
import javagen.umlparser.GenericTransformer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.uml2.uml.BehavioredClassifier;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.InterfaceRealization;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Realization;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;

public class UmlUtils {
    private static final String WILDCARD = "*";

    public static List<String> toQualifiedName(String qname) {
        String[] splittedName = qname.split("\\.");
        return Arrays.asList(splittedName);
    }

    public static List<String> slashNameToQualifiedName(String qname) {
        String[] splittedName = qname.split("/");
        return Arrays.asList(splittedName);
    }

    public static Package getPackage(Package parent, String name) {
        Package p = (Package)parent.getPackagedElement(name, false, UMLPackage.eINSTANCE.getPackage(), true);
        return p;
    }

    public static Package getModel(Package parent, String name) {
        Package p = UmlUtils.lookupPackage(parent, name);
        if (p == null) {
            p = (Package)parent.getPackagedElement(name, false, UMLPackage.eINSTANCE.getModel(), true);
        }
        return p;
    }

    private static Package lookupPackage(Package parent, String name) {
        Package p = (Package)parent.getPackagedElement(name, false, UMLPackage.eINSTANCE.getPackage(), false);
        return p;
    }

    private static Namespace lookupNamespace(Namespace parent, String name) {
        NamedElement foundElement = parent.getOwnedMember(name);
        if (foundElement instanceof Namespace) {
            return (Namespace)foundElement;
        }
        return null;
    }

    public static Package getContainingPackage(Package root, List<String> qualifiedName) {
        Package cur = root;
        int i = 0;
        while (i < qualifiedName.size() - 1) {
            String name = qualifiedName.get(i);
            cur = UmlUtils.getPackage(cur, name);
            ++i;
        }
        return cur;
    }

    private static Package lookupContainingPackage(Package root, List<String> qualifiedName) {
        Package cur = root;
        int i = 0;
        while (i < qualifiedName.size() - 1) {
            String name = qualifiedName.get(i);
            if ((cur = UmlUtils.lookupPackage(cur, name)) == null) {
                return null;
            }
            ++i;
        }
        return cur;
    }

    private static Namespace lookupContainingNamespace(Namespace parent, List<String> qualifiedName) {
        Namespace cur = parent;
        int i = 0;
        while (i < qualifiedName.size() - 1) {
            String name = qualifiedName.get(i);
            cur = UmlUtils.lookupNamespace(parent, name);
            if (cur == null) {
                return null;
            }
            ++i;
        }
        return cur;
    }

    public static Package lookupPackageBeforeWildcard(Package root, List<String> qualifiedName) {
        Package cur = root;
        int i = 0;
        while (i < qualifiedName.size()) {
            String name = qualifiedName.get(i);
            if (WILDCARD.equals(name)) break;
            if ((cur = UmlUtils.lookupPackage(cur, name)) == null) {
                return null;
            }
            ++i;
        }
        return cur;
    }

    public static Package getContainingPackage(Resource model, List<String> qualifiedName) {
        Package cur = (Package)UmlUtils.getNamedElement(model, UMLPackage.eINSTANCE.getPackage(), qualifiedName.get(0));
        int i = 1;
        while (i < qualifiedName.size() - 1) {
            String name = qualifiedName.get(i);
            cur = UmlUtils.getPackage(cur, name);
            ++i;
        }
        return cur;
    }

    private static Package lookupContainingPackage(Resource model, List<String> qualifiedName) {
        Package cur = (Package)UmlUtils.lookupNamedElement(model, UMLPackage.eINSTANCE.getPackage(), qualifiedName.get(0));
        if (cur == null) {
            return null;
        }
        int i = 1;
        while (i < qualifiedName.size() - 1) {
            String name = qualifiedName.get(i);
            if ((cur = UmlUtils.lookupPackage(cur, name)) == null) {
                return null;
            }
            ++i;
        }
        return cur;
    }

    public static Package getPackage(Resource model, List<String> qualifiedName) {
        Package cur = (Package)UmlUtils.getNamedElement(model, UMLPackage.eINSTANCE.getPackage(), qualifiedName.get(0));
        int i = 1;
        while (i < qualifiedName.size()) {
            String name = qualifiedName.get(i);
            cur = UmlUtils.getPackage(cur, name);
            ++i;
        }
        return cur;
    }

    public static Package lookupPackage(Resource model, List<String> qualifiedName) {
        Package cur = (Package)UmlUtils.lookupNamedElement(model, UMLPackage.eINSTANCE.getPackage(), qualifiedName.get(0));
        if (cur == null) {
            return null;
        }
        int i = 1;
        while (i < qualifiedName.size()) {
            String name = qualifiedName.get(i);
            if ((cur = UmlUtils.lookupPackage(cur, name)) == null) {
                return null;
            }
            ++i;
        }
        return cur;
    }

    public static Package getPackage(Package parent, List<String> qualifiedName) {
        Package cur = parent;
        int i = 0;
        while (i < qualifiedName.size()) {
            String name = qualifiedName.get(i);
            cur = UmlUtils.getPackage(cur, name);
            ++i;
        }
        return cur;
    }

    public static Package getModel(Package parent, List<String> qualifiedName) {
        String name;
        Package cur = parent;
        int i = 0;
        i = 0;
        while (i < qualifiedName.size() - 1) {
            name = qualifiedName.get(i);
            cur = UmlUtils.getPackage(cur, name);
            ++i;
        }
        name = qualifiedName.get(i);
        cur = UmlUtils.getModel(cur, name);
        return cur;
    }

    public static Package lookupPackage(Package parent, List<String> qualifiedName) {
        Package cur = parent;
        int i = 0;
        while (i < qualifiedName.size()) {
            String name = qualifiedName.get(i);
            if ((cur = UmlUtils.lookupPackage(cur, name)) == null) {
                return null;
            }
            ++i;
        }
        return cur;
    }

    protected static <R extends NamedElement> R getNamedElement(Resource model, EClass expectedType, String name) {
        for (Object cur : model.getContents()) {
            if (!expectedType.getInstanceClass().isInstance(cur) || !name.equals(((NamedElement)cur).getName())) continue;
            return (R)((NamedElement)cur);
        }
        NamedElement res = (NamedElement)UMLFactory.eINSTANCE.create(expectedType);
        res.setName(name);
        model.getContents().add((Object)res);
        return (R)res;
    }

    protected static <R extends NamedElement> R lookupNamedElement(Resource model, EClass expectedType, String name) {
        for (Object cur : model.getContents()) {
            if (!expectedType.isInstance(cur) || !name.equals(((NamedElement)cur).getName())) continue;
            return (R)((NamedElement)cur);
        }
        return null;
    }

    public static <R extends Type> R getClassifier(Package parent, List<String> qualifiedName, EClass expectedType) {
        Package p = UmlUtils.getContainingPackage(parent, qualifiedName);
        return (R)p.getOwnedType(qualifiedName.get(qualifiedName.size() - 1), false, expectedType, true);
    }

    public static <R extends Type> R lookupClassifier(Resource model, List<String> qualifiedName, EClass expectedType) {
        Package p = UmlUtils.lookupContainingPackage(model, qualifiedName);
        if (p == null) {
            return null;
        }
        return (R)p.getOwnedType(qualifiedName.get(qualifiedName.size() - 1), false, expectedType, false);
    }

    public static <R extends Type> R lookupClassifierWithWildcard(Resource model, List<String> qualifiedName, EClass expectedType) {
        Package p = UmlUtils.lookupContainingPackage(model, qualifiedName);
        if (p == null) {
            return null;
        }
        return (R)p.getOwnedType(qualifiedName.get(qualifiedName.size() - 1), false, expectedType, false);
    }

    public static <R extends Type> R lookupClassifierWithWildcard(Package parent, List<String> qualifiedName, EClass expectedType) {
        int wildcardIndex = qualifiedName.indexOf(WILDCARD);
        if (wildcardIndex < 0) {
            return UmlUtils.lookupClassifier(parent, qualifiedName, expectedType);
        }
        Package p = UmlUtils.lookupPackageBeforeWildcard(parent, qualifiedName);
        if (p == null) {
            return null;
        }
        EList existingPackages = p.getNestedPackages();
        List<String> remainingPath = qualifiedName.subList(wildcardIndex + 1, qualifiedName.size());
        for (Package nestedPackage : existingPackages) {
            R r = UmlUtils.lookupClassifier(nestedPackage, qualifiedName, expectedType);
            if (r == null) continue;
            return r;
        }
        return null;
    }

    public static <R extends Type> R lookupClassifier(Package parent, List<String> qualifiedName, EClass expectedType) {
        Package p = UmlUtils.lookupContainingPackage(parent, qualifiedName);
        if (p == null) {
            return null;
        }
        return (R)p.getOwnedType(qualifiedName.get(qualifiedName.size() - 1), false, expectedType, false);
    }

    public static <R extends Classifier> R lookupClassifier(Namespace parent, List<String> qualifiedName, EClass expectedType) {
        Classifier result;
        Namespace p = UmlUtils.lookupContainingNamespace(parent, qualifiedName);
        if (p == null) {
            return null;
        }
        parent = p;
        String shortname = qualifiedName.get(qualifiedName.size() - 1);
        if (parent instanceof Package) {
            result = (Classifier)((Package)parent).getOwnedType(shortname, false, expectedType, false);
        } else if (parent instanceof Interface) {
            result = ((Interface)parent).getNestedClassifier(shortname, false, expectedType, false);
        } else if (parent instanceof Class) {
            result = ((Class)parent).getNestedClassifier(shortname, false, expectedType, false);
        } else {
            return null;
        }
        return (R)result;
    }

    public static Class getClass(Package parent, String name) {
        Class p = (Class)parent.getOwnedType(name, false, UMLPackage.eINSTANCE.getClass_(), true);
        return p;
    }

    public static Class getClass(Package parent, List<String> qualifiedName) {
        Package p = UmlUtils.getContainingPackage(parent, qualifiedName);
        return UmlUtils.getClass(p, qualifiedName.get(qualifiedName.size() - 1));
    }

    public static Class getClass(List<Namespace> enclosingParents, String name) {
        EClass type = UMLPackage.eINSTANCE.getClass_();
        Class result = (Class)UmlUtils.getClassifier(enclosingParents, name, type);
        return result;
    }

    private static Classifier getClassifier(List<Namespace> enclosingParents, String name, EClass type) {
        Classifier result = null;
        int parentsCount = enclosingParents.size();
        Namespace parent = enclosingParents.get(parentsCount - 1);
        int i = parentsCount - 1;
        while (i >= 0) {
            Namespace namespace = enclosingParents.get(i);
            result = (Classifier)namespace.getOwnedMember(name, false, type);
            if (result == null) {
                result = (Classifier)namespace.getOwnedMember(name, false, UMLPackage.eINSTANCE.getClassifier());
            }
            if (result != null) {
                if (result.eClass() != type) {
                    System.err.println("Classifier type need to be corrected for (" + result.getQualifiedName() + ")");
                    result = (Classifier)UmlUtils.transformInto(result, type);
                }
                if (result.getOwner() != parent) {
                    UmlUtils.setClassifierOwner(result, parent);
                }
                return result;
            }
            --i;
        }
        if (parent instanceof Package) {
            result = (Classifier)((Package)parent).getOwnedType(name, false, type, true);
        } else if (parent instanceof Interface) {
            result = ((Interface)parent).createNestedClassifier(name, type);
        } else if (parent instanceof Class) {
            result = ((Class)parent).createNestedClassifier(name, type);
        } else {
            Package parentPackage = (Package)enclosingParents.get(0);
            result = (Classifier)parentPackage.getOwnedType(name, false, type, true);
        }
        return result;
    }

    private static void setClassifierOwner(Classifier classifier, Namespace newParent) {
        if (newParent instanceof Package) {
            classifier.setPackage((Package)newParent);
        } else if (newParent instanceof Interface) {
            ((Interface)newParent).getNestedClassifiers().add((Object)classifier);
        } else if (newParent instanceof Class) {
            ((Class)newParent).getNestedClassifiers().add((Object)classifier);
        } else {
            System.err.println("Don't know how to change classifier owner for " + newParent);
        }
    }

    private static EObject transformInto(Classifier toTransform, EClass type) {
        GenericTransformer transformer = new GenericTransformer((EObject)toTransform);
        EObject result = transformer.transform(type);
        return result;
    }

    public static Classifier getGuessedClassifier(List<Namespace> enclosingParents, List<String> name, EClass type) {
        Object result = null;
        int parentsCount = enclosingParents.size();
        Namespace parent = enclosingParents.get(parentsCount - 1);
        int i = parentsCount - 1;
        while (i >= 0) {
            Namespace namespace = enclosingParents.get(i);
            result = UmlUtils.lookupClassifier(namespace, name, UMLPackage.eINSTANCE.getClassifier());
            if (result != null) {
                return result;
            }
            --i;
        }
        Package parentPackage = (Package)enclosingParents.get(0);
        result = (Classifier)UmlUtils.getClassifier(parentPackage, name, type);
        return result;
    }

    public static Interface getInterface(Package parent, String name) {
        Interface p = (Interface)parent.getOwnedType(name, false, UMLPackage.eINSTANCE.getInterface(), true);
        return p;
    }

    public static Interface getInterface(List<Namespace> enclosingParents, String name) {
        return (Interface)UmlUtils.getClassifier(enclosingParents, name, UMLPackage.eINSTANCE.getInterface());
    }

    public static Property createProperty(Classifier parent, Type type, String name, int arrayCount) {
        Property p;
        if (parent instanceof Class) {
            p = UmlUtils.createProperty((Class)parent, type, name, arrayCount);
        } else if (parent instanceof Interface) {
            p = UmlUtils.createProperty((Interface)parent, type, name, arrayCount);
        } else {
            return null;
        }
        p.setIsUnique(false);
        return p;
    }

    public static Property createProperty(Class parent, Type type, String name, int arrayCount) {
        return parent.getOwnedAttribute(name, type, false, UMLPackage.eINSTANCE.getProperty(), true);
    }

    public static Property createProperty(Interface parent, Type type, String name, int arrayCount) {
        return parent.getOwnedAttribute(name, type, false, UMLPackage.eINSTANCE.getProperty(), true);
    }

    public static void getGeneralization(Classifier child, Classifier general) {
        child.getGeneralization(general, true);
    }

    public static void getInterfaceRealization(BehavioredClassifier child, Interface general) {
        InterfaceRealization res = UmlUtils.lookupInterfaceRealization((Classifier)child, (Classifier)general);
        if (res == null) {
            UmlUtils.createInterfaceRealization(child, general);
        }
    }

    private static InterfaceRealization lookupInterfaceRealization(Classifier child, Classifier general) {
        for (Dependency ele : child.getClientDependencies()) {
            InterfaceRealization real;
            if (!(ele instanceof InterfaceRealization) || !(real = (InterfaceRealization)ele).getClients().contains((Object)child) || !real.getSuppliers().contains((Object)general)) continue;
            return real;
        }
        return null;
    }

    public static void createInterfaceRealization(BehavioredClassifier child, Interface general) {
        InterfaceRealization res = UMLFactory.eINSTANCE.createInterfaceRealization();
        res.setContract(general);
        res.setImplementingClassifier(child);
        res.setName(String.valueOf(child.getName()) + " implements " + general.getName());
    }

    public static void getRealization(Package parent, Classifier child, Classifier general) {
        Realization res = UmlUtils.lookupRealization(parent, child, general);
        if (res == null) {
            UmlUtils.createRealization(parent, child, general);
        }
    }

    private static Realization lookupRealization(Package parent, Classifier child, Classifier general) {
        for (PackageableElement ele : parent.getPackagedElements()) {
            Realization real;
            if (!(ele instanceof Realization) || !(real = (Realization)ele).getClients().contains((Object)child) || !real.getSuppliers().contains((Object)general)) continue;
            return real;
        }
        return null;
    }

    public static void createRealization(Package parent, Classifier child, Classifier general) {
        Realization res = UMLFactory.eINSTANCE.createRealization();
        res.getClients().add((Object)child);
        res.getSuppliers().add((Object)general);
        res.setName(String.valueOf(child.getName()) + " extends " + general.getName());
        parent.getPackagedElements().add((Object)res);
    }

    public static PrimitiveType getPrimitive(Package parent, String typeName) {
        return (PrimitiveType)parent.getOwnedType(typeName, true, UMLPackage.eINSTANCE.getPrimitiveType(), true);
    }

    public static PrimitiveType getPrimitive(Package parent, List<String> qualifiedName) {
        Package p = UmlUtils.getContainingPackage(parent, qualifiedName);
        return UmlUtils.getPrimitive(p, qualifiedName.get(qualifiedName.size() - 1));
    }

    public static Operation getOperation(Classifier classifier, String name) {
        EList opers = classifier.getOperations();
        for (Operation op : opers) {
            if (!name.equals(op.getName())) continue;
            return op;
        }
        Operation res = UmlUtils.createOperation(classifier, name);
        return res;
    }

    public static Operation createOperation(Classifier classifier, String name) {
        Operation res = UMLFactory.eINSTANCE.createOperation();
        res.setName(name);
        if (classifier instanceof Class) {
            ((Class)classifier).getOwnedOperations().add((Object)res);
        } else if (classifier instanceof Interface) {
            ((Interface)classifier).getOwnedOperations().add((Object)res);
        } else if (classifier instanceof DataType) {
            ((DataType)classifier).getOwnedOperations().add((Object)res);
        }
        return res;
    }
}

