/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.layers.runtime;

import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.layers.runtime.LayerStackSynchronizer;
import org.eclipse.papyrus.layers.runtime.LayerStackSynchronizerSubclass;
import org.eclipse.papyrus.layers.runtime.LayersModelEventUtils;
import org.eclipse.papyrus.layers.runtime.utils.TriggeredEventTraces;
import org.eclipse.papyrus.layers.stackmodel.LayersException;
import org.eclipse.papyrus.layers.stackmodel.layers.BooleanInstance;
import org.eclipse.papyrus.layers.stackmodel.layers.Layer;
import org.eclipse.papyrus.layers.stackmodel.layers.LayerExpression;
import org.eclipse.papyrus.layers.stackmodel.layers.LayerOperator;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersFactory;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersStack;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersStackApplication;
import org.eclipse.papyrus.layers.stackmodel.layers.Property;
import org.eclipse.papyrus.layers.stackmodel.layers.PropertyRegistry;
import org.eclipse.papyrus.layers.stackmodel.layers.StringInstance;
import org.eclipse.papyrus.layers.stackmodel.layers.TopLayerOperator;
import org.eclipse.papyrus.layers.stackmodel.layers.TypeInstance;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class LayerStackSynchronizerWithApplicationTest {
    protected static final String PROJECT_MODEL_URI = "org.eclipse.papyrus.infra.core/tmp/model1.di";
    protected ModelSet modelSet;

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testLayerStackSynchronizer() throws LayersException {
        LayersStackApplication application = LayersFactory.eINSTANCE.createLayersStackApplication();
        PropertyRegistry propertyRegistry = application.getPropertyRegistry();
        Diagram diagram = NotationFactory.eINSTANCE.createDiagram();
        LayersStack stack = application.getLayersStackFor(diagram);
        LayerStackSynchronizer synchronizer = new LayerStackSynchronizer(stack);
        Assert.assertNotNull((String)"object created", (Object)synchronizer);
        TopLayerOperator layer = LayersFactory.eINSTANCE.createTopLayerOperator();
        layer.setApplication(application);
        Shape view1 = NotationFactory.eINSTANCE.createShape();
        Shape view2 = NotationFactory.eINSTANCE.createShape();
        Shape view3 = NotationFactory.eINSTANCE.createShape();
        Shape view4 = NotationFactory.eINSTANCE.createShape();
        int index = 0;
        Property property1 = (Property)propertyRegistry.getProperties().get(index++);
        Property property2 = (Property)propertyRegistry.getProperties().get(index++);
        Property property3 = (Property)propertyRegistry.getProperties().get(index++);
        Property property4 = (Property)propertyRegistry.getProperties().get(index++);
        Layer layer1 = this.createLayer((LayerOperator)layer, Arrays.asList(view1), Arrays.asList(property1));
        Layer layer2 = this.createLayer((LayerOperator)layer, Arrays.asList(view1, view2), Arrays.asList(property1, property2));
        Layer layer3 = this.createLayer((LayerOperator)layer, Arrays.asList(view3), Arrays.asList(property3));
    }

    @Test
    public void testGetDiagram() {
        LayersStackApplication application = LayersFactory.eINSTANCE.createLayersStackApplication();
        PropertyRegistry propertyRegistry = application.getPropertyRegistry();
        Diagram diagram = NotationFactory.eINSTANCE.createDiagram();
        LayersStack stack = application.getLayersStackFor(diagram);
        LayerStackSynchronizer synchronizer = new LayerStackSynchronizer(stack);
        Assert.assertNotNull((String)"getDiagram", (Object)synchronizer.getDiagram());
        Assert.assertSame((String)"getDiagram", (Object)diagram, (Object)synchronizer.getDiagram());
    }

    @Test
    public void testGetLayersStack() {
        LayersStackApplication application = LayersFactory.eINSTANCE.createLayersStackApplication();
        PropertyRegistry propertyRegistry = application.getPropertyRegistry();
        Diagram diagram = NotationFactory.eINSTANCE.createDiagram();
        LayersStack stack = application.getLayersStackFor(diagram);
        LayerStackSynchronizer synchronizer = new LayerStackSynchronizer(stack);
        Assert.assertNotNull((String)"getLayersStack", (Object)synchronizer.getLayersStack());
        Assert.assertSame((String)"getLayersStack", (Object)stack, (Object)synchronizer.getLayersStack());
    }

    @Test
    @Ignore
    public void testDispose() {
        Assert.fail((String)"Not yet implemented");
    }

    @Test
    @Ignore
    public void testIsDisposed() {
        Assert.fail((String)"Not yet implemented");
    }

    @Test
    public void testPropertyValueAdded() throws LayersException {
        LayersStackApplication application = LayersFactory.eINSTANCE.createLayersStackApplication();
        PropertyRegistry propertyRegistry = application.getPropertyRegistry();
        Diagram diagram = NotationFactory.eINSTANCE.createDiagram();
        LayersStack stack = application.getLayersStackFor(diagram);
        TopLayerOperator layer = LayersFactory.eINSTANCE.createTopLayerOperator();
        layer.setApplication(application);
        stack.setLayers((LayerExpression)layer);
        LayerStackSynchronizerSubclass synchronizer = new LayerStackSynchronizerSubclass(stack);
        TriggeredEventTraces traces = synchronizer.traces;
        Shape view1 = NotationFactory.eINSTANCE.createShape();
        int index = 0;
        Property property1 = (Property)propertyRegistry.getProperties().get(index++);
        Property property2 = (Property)propertyRegistry.getProperties().get(index++);
        Layer layer1 = this.createLayer((LayerOperator)layer, Arrays.asList(view1), Arrays.asList(property1));
        traces.clear();
        layer1.addPropertyInstance(property2);
        Assert.assertTrue((String)"event sent", (traces.size() > 0 ? 1 : 0) != 0);
        Assert.assertSame((String)"event sent", (Object)"propertyValueAdded", (Object)traces.get((int)0).name);
    }

    @Test
    public void testPropertyValueRemoved() throws LayersException {
        LayersStackApplication application = LayersFactory.eINSTANCE.createLayersStackApplication();
        PropertyRegistry propertyRegistry = application.getPropertyRegistry();
        Diagram diagram = NotationFactory.eINSTANCE.createDiagram();
        LayersStack stack = application.getLayersStackFor(diagram);
        TopLayerOperator layer = LayersFactory.eINSTANCE.createTopLayerOperator();
        layer.setApplication(application);
        stack.setLayers((LayerExpression)layer);
        LayerStackSynchronizerSubclass synchronizer = new LayerStackSynchronizerSubclass(stack);
        TriggeredEventTraces traces = synchronizer.traces;
        Shape view1 = NotationFactory.eINSTANCE.createShape();
        int index = 0;
        Property property1 = (Property)propertyRegistry.getProperties().get(index++);
        Property property2 = (Property)propertyRegistry.getProperties().get(index++);
        Layer layer1 = this.createLayer((LayerOperator)layer, Arrays.asList(view1), Arrays.asList(property1, property2));
        traces.clear();
        layer1.removePropertyInstance(property2);
        Assert.assertTrue((String)"event sent", (traces.size() > 0 ? 1 : 0) != 0);
        Assert.assertSame((String)"event sent", (Object)"propertyValueRemoved", (Object)traces.get((int)0).name);
    }

    @Test
    public void testPropertyValueChanged() throws LayersException {
        LayersStackApplication application = LayersFactory.eINSTANCE.createLayersStackApplication();
        PropertyRegistry propertyRegistry = application.getPropertyRegistry();
        Diagram diagram = NotationFactory.eINSTANCE.createDiagram();
        LayersStack stack = application.getLayersStackFor(diagram);
        TopLayerOperator layer = LayersFactory.eINSTANCE.createTopLayerOperator();
        layer.setApplication(application);
        stack.setLayers((LayerExpression)layer);
        LayerStackSynchronizerSubclass synchronizer = new LayerStackSynchronizerSubclass(stack);
        TriggeredEventTraces traces = synchronizer.traces;
        Shape view1 = NotationFactory.eINSTANCE.createShape();
        int index = 0;
        Property property1 = (Property)propertyRegistry.getProperties().get(index++);
        Property property2 = (Property)propertyRegistry.getProperties().get(index++);
        Layer layer1 = this.createLayer((LayerOperator)layer, Arrays.asList(view1), Arrays.asList(property1, property2));
        traces.clear();
        TypeInstance value = layer1.getPropertyInstance(property1);
        if (value instanceof StringInstance) {
            Assert.assertTrue((String)"value is instance of String", (boolean)(value instanceof StringInstance));
            StringInstance stringValue = (StringInstance)value;
            stringValue.setValue("newValue");
        } else if (value instanceof BooleanInstance) {
            BooleanInstance realValue = (BooleanInstance)value;
            realValue.setValue(true);
        }
        layer1.removePropertyInstance(property2);
        Assert.assertTrue((String)"event sent", (traces.size() > 0 ? 1 : 0) != 0);
        Assert.assertSame((String)"event sent", (Object)"propertyValueChanged", (Object)traces.get((int)0).name);
    }

    @Test
    @Ignore
    public void testLayerAdded() {
        Assert.fail((String)"Not yet implemented");
    }

    @Test
    @Ignore
    public void testLayerRemoved() {
        Assert.fail((String)"Not yet implemented");
    }

    @Test
    @Ignore
    public void testLayerMoved() {
        Assert.fail((String)"Not yet implemented");
    }

    @Test
    @Ignore
    public void testLayerSet() {
        Assert.fail((String)"Not yet implemented");
    }

    @Test
    public void testViewAddedToLayer() throws LayersException {
        LayersStackApplication application = LayersFactory.eINSTANCE.createLayersStackApplication();
        PropertyRegistry propertyRegistry = application.getPropertyRegistry();
        Diagram diagram = NotationFactory.eINSTANCE.createDiagram();
        LayersStack stack = application.getLayersStackFor(diagram);
        TopLayerOperator layer = LayersFactory.eINSTANCE.createTopLayerOperator();
        layer.setApplication(application);
        stack.setLayers((LayerExpression)layer);
        LayerStackSynchronizerSubclass synchronizer = new LayerStackSynchronizerSubclass(stack);
        TriggeredEventTraces traces = synchronizer.traces;
        Shape view1 = NotationFactory.eINSTANCE.createShape();
        Shape view2 = NotationFactory.eINSTANCE.createShape();
        int index = 0;
        Property property1 = (Property)propertyRegistry.getProperties().get(index++);
        Layer layer1 = this.createLayer((LayerOperator)layer, Arrays.asList(view1), Arrays.asList(property1));
        traces.clear();
        layer1.getViews().add((Object)view2);
        Assert.assertTrue((String)"event sent", (traces.size() > 0 ? 1 : 0) != 0);
        TriggeredEventTraces.TriggeredEvent event = traces.get(0);
        Assert.assertSame((String)"event sent", (Object)"viewAddedToLayer", (Object)event.name);
    }

    @Test
    public void testNViewAddedToLayer() throws LayersException {
        LayersStackApplication application = LayersFactory.eINSTANCE.createLayersStackApplication();
        PropertyRegistry propertyRegistry = application.getPropertyRegistry();
        Diagram diagram = NotationFactory.eINSTANCE.createDiagram();
        LayersStack stack = application.getLayersStackFor(diagram);
        TopLayerOperator layer = LayersFactory.eINSTANCE.createTopLayerOperator();
        layer.setApplication(application);
        stack.setLayers((LayerExpression)layer);
        LayerStackSynchronizerSubclass synchronizer = new LayerStackSynchronizerSubclass(stack);
        TriggeredEventTraces traces = synchronizer.traces;
        Shape view1 = NotationFactory.eINSTANCE.createShape();
        Shape view2 = NotationFactory.eINSTANCE.createShape();
        Shape view3 = NotationFactory.eINSTANCE.createShape();
        List<View> viewsToAttach = Arrays.asList(view1);
        List<View> viewsToAdd = Arrays.asList(view2, view3);
        int index = 0;
        Property property1 = (Property)propertyRegistry.getProperties().get(index++);
        Layer layer1 = this.createLayer((LayerOperator)layer, viewsToAttach, Arrays.asList(property1));
        traces.clear();
        layer1.getViews().addAll(viewsToAdd);
        Assert.assertTrue((String)"event sent", (traces.size() > 0 ? 1 : 0) != 0);
        TriggeredEventTraces.TriggeredEvent event = traces.get(0);
        Assert.assertSame((String)"event sent", (Object)"multiViewsAddedToLayer", (Object)event.name);
        Notification notification = event.notifier;
        Assert.assertNotNull((String)"notification is set", (Object)notification);
        List<View> addedViews = LayersModelEventUtils.ViewEvents.getViewsAdded(notification);
        Assert.assertEquals((String)"both removed list have the same size", (long)viewsToAdd.size(), (long)addedViews.size());
        Assert.assertTrue((String)"notification contains removed views", (boolean)addedViews.containsAll(viewsToAdd));
    }

    @Test
    public void testViewRemovedFromLayer() throws LayersException {
        LayersStackApplication application = LayersFactory.eINSTANCE.createLayersStackApplication();
        PropertyRegistry propertyRegistry = application.getPropertyRegistry();
        Diagram diagram = NotationFactory.eINSTANCE.createDiagram();
        LayersStack stack = application.getLayersStackFor(diagram);
        TopLayerOperator layer = LayersFactory.eINSTANCE.createTopLayerOperator();
        layer.setApplication(application);
        stack.setLayers((LayerExpression)layer);
        LayerStackSynchronizerSubclass synchronizer = new LayerStackSynchronizerSubclass(stack);
        TriggeredEventTraces traces = synchronizer.traces;
        Shape view1 = NotationFactory.eINSTANCE.createShape();
        Shape view2 = NotationFactory.eINSTANCE.createShape();
        int index = 0;
        Property property1 = (Property)propertyRegistry.getProperties().get(index++);
        Layer layer1 = this.createLayer((LayerOperator)layer, Arrays.asList(view1, view2), Arrays.asList(property1));
        traces.clear();
        layer1.getViews().remove((Object)view2);
        Assert.assertTrue((String)"event sent", (traces.size() > 0 ? 1 : 0) != 0);
        TriggeredEventTraces.TriggeredEvent event = traces.get(0);
        Assert.assertSame((String)"event sent", (Object)"viewRemovedFromLayer", (Object)event.name);
    }

    @Test
    public void testNViewRemovedFromLayer() throws LayersException {
        LayersStackApplication application = LayersFactory.eINSTANCE.createLayersStackApplication();
        PropertyRegistry propertyRegistry = application.getPropertyRegistry();
        Diagram diagram = NotationFactory.eINSTANCE.createDiagram();
        LayersStack stack = application.getLayersStackFor(diagram);
        TopLayerOperator layer = LayersFactory.eINSTANCE.createTopLayerOperator();
        layer.setApplication(application);
        stack.setLayers((LayerExpression)layer);
        LayerStackSynchronizerSubclass synchronizer = new LayerStackSynchronizerSubclass(stack);
        TriggeredEventTraces traces = synchronizer.traces;
        Shape view1 = NotationFactory.eINSTANCE.createShape();
        Shape view2 = NotationFactory.eINSTANCE.createShape();
        Shape view3 = NotationFactory.eINSTANCE.createShape();
        List<View> viewsToAttach = Arrays.asList(view1, view2, view3);
        List<View> viewsToRemove = Arrays.asList(view2, view3);
        int index = 0;
        Property property1 = (Property)propertyRegistry.getProperties().get(index++);
        Layer layer1 = this.createLayer((LayerOperator)layer, viewsToAttach, Arrays.asList(property1));
        traces.clear();
        layer1.getViews().removeAll(viewsToRemove);
        Assert.assertTrue((String)"event sent", (traces.size() > 0 ? 1 : 0) != 0);
        TriggeredEventTraces.TriggeredEvent event = traces.get(0);
        Assert.assertSame((String)"event sent", (Object)"multiViewsRemovedFromLayer", (Object)event.name);
        Notification notification = event.notifier;
        Assert.assertNotNull((String)"notification is set", (Object)notification);
        List<View> removedViews = LayersModelEventUtils.ViewEvents.getViewsRemoved(notification);
        Assert.assertEquals((String)"both removed list have the same size", (long)removedViews.size(), (long)viewsToRemove.size());
        Assert.assertTrue((String)"notification contains removed views", (boolean)removedViews.containsAll(viewsToRemove));
    }

    @Test
    @Ignore
    public void testViewMovedBetweenLayer() {
        Assert.fail((String)"Not yet implemented");
    }

    @Test
    @Ignore
    public void testDiagramViewAdded() {
        Assert.fail((String)"Not yet implemented");
    }

    @Test
    @Ignore
    public void testDiagramViewRemoved() {
        Assert.fail((String)"Not yet implemented");
    }

    protected Layer createLayer(LayerOperator parent, List<View> views, List<Property> properties) throws LayersException {
        Layer layer = LayersFactory.eINSTANCE.createLayer();
        layer.setApplication(parent.getApplication());
        parent.getLayers().add((Object)layer);
        for (View view : views) {
            layer.getViews().add((Object)view);
        }
        for (Property property : properties) {
            layer.addPropertyInstance(property);
        }
        return layer;
    }

    @Test
    public void testCreateLayer() throws LayersException {
        TopLayerOperator layerParent = LayersFactory.eINSTANCE.createTopLayerOperator();
        LayersStackApplication application = LayersFactory.eINSTANCE.createLayersStackApplication();
        layerParent.setApplication(application);
        PropertyRegistry propertyRegistry = application.getPropertyRegistry();
        Shape view1 = NotationFactory.eINSTANCE.createShape();
        Shape view2 = NotationFactory.eINSTANCE.createShape();
        Shape view3 = NotationFactory.eINSTANCE.createShape();
        int index = 0;
        Property property1 = (Property)propertyRegistry.getProperties().get(index++);
        Property property2 = (Property)propertyRegistry.getProperties().get(index++);
        Property property3 = (Property)propertyRegistry.getProperties().get(index++);
        Layer layer = this.createLayer((LayerOperator)layerParent, Arrays.asList(view1, view2), Arrays.asList(property1, property2));
        Assert.assertNotNull((String)"layer created", (Object)layer);
        Assert.assertSame((String)"views added", (Object)2, (Object)layer.getViews().size());
        Assert.assertSame((String)"property instance added", (Object)2, (Object)layer.getPropertyValueMap().values().size());
        Assert.assertSame((String)"property instance is correctly set", (Object)layer.getPropertyValueMap().get((Object)property1.getName()), (Object)layer.getPropertyInstance(property1));
        Assert.assertSame((String)"property instance is correctly set", (Object)layer.getPropertyValueMap().get((Object)property2.getName()), (Object)layer.getPropertyInstance(property2));
    }
}

