/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.layers.runtime;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationModel;
import org.eclipse.papyrus.layers.runtime.INotationDiagramRemovedEventListener;

public class NotationDiagramRemovedFromResourceEventNotifier {
    protected NotationModel notationModel;
    protected List<INotationDiagramRemovedEventListener> listeners = new ArrayList<INotationDiagramRemovedEventListener>();
    protected Adapter notationDiagramRemovedListener = new AdapterImpl(){

        public void notifyChanged(Notification msg) {
            Resource resource;
            if (msg.getEventType() == 4 && msg.getNotifier() instanceof Resource && msg.getOldValue() instanceof Diagram && (resource = (Resource)msg.getNotifier()).isLoaded()) {
                NotationDiagramRemovedFromResourceEventNotifier.this.fireDiagramRemovedEvent(msg);
            }
        }
    };

    public NotationDiagramRemovedFromResourceEventNotifier(NotationModel notationModel) {
        this.notationModel = notationModel;
        this.activate();
    }

    protected void activate() {
        this.notationModel.getResource().eAdapters().add((Object)this.notationDiagramRemovedListener);
    }

    protected void deactivate() {
        this.notationModel.getResource().eAdapters().remove((Object)this.notationDiagramRemovedListener);
    }

    protected void dispose() {
        this.deactivate();
        this.notationModel = null;
    }

    protected boolean isDisposed() {
        return this.notationModel == null;
    }

    public void addLayersModelEventListener(INotationDiagramRemovedEventListener listener) {
        if (listener == null) {
            return;
        }
        if (this.listeners.contains(listener)) {
            return;
        }
        this.listeners.add(listener);
    }

    public void removeLayersModelEventListener(INotationDiagramRemovedEventListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireDiagramRemovedEvent(Notification msg) {
        for (INotationDiagramRemovedEventListener listener : this.listeners) {
            listener.diagramRemoved(msg);
        }
    }

    public static Diagram getRemovedDiagram(Notification msg) {
        return (Diagram)msg.getOldValue();
    }
}

