/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.layers.runtime;

import org.eclipse.emf.common.util.URI;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.papyrus.infra.core.resource.IModel;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationModel;
import org.eclipse.papyrus.layers.runtime.NotationDiagramHelper;
import org.eclipse.papyrus.layers.runtime.NotationDiagramRemovedFromResourceEventNotifier;
import org.eclipse.papyrus.layers.runtime.TraceNotationDiagramRemovedFromResourceEventListener;
import org.eclipse.papyrus.layers.runtime.model.LayersModel;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class NotationDiagramRemovedFromResourceEventNotifierTest {
    protected static final String PROJECT_MODEL_URI = "org.eclipse.papyrus.infra.core/tmp/model1.di";
    protected ModelSet modelSet;

    @Before
    public void setUp() throws Exception {
        ModelSet mngr = new ModelSet();
        LayersModel layersModel = new LayersModel();
        mngr.registerModel((IModel)layersModel);
        NotationModel notationModel = new NotationModel();
        mngr.registerModel((IModel)notationModel);
        URI uri = URI.createPlatformResourceURI((String)PROJECT_MODEL_URI, (boolean)true);
        mngr.createModels(uri);
        this.modelSet = mngr;
    }

    @After
    public void tearDown() throws Exception {
        this.modelSet.unload();
    }

    @Test
    public void testNotationDiagramRemovedFromResourceEventNotifier() {
        NotationModel notationModel = (NotationModel)this.modelSet.getModel("org.eclipse.papyrus.infra.core.resource.notation.NotationModel");
        NotationDiagramRemovedFromResourceEventNotifier notifier = new NotationDiagramRemovedFromResourceEventNotifier(notationModel);
        Assert.assertNotNull((String)"application created", (Object)notifier);
        notifier.dispose();
    }

    @Test
    public void testModelSetCreation() {
        NotationModel notationModel = (NotationModel)this.modelSet.getModel("org.eclipse.papyrus.infra.core.resource.notation.NotationModel");
        Assert.assertNotNull((String)"NotationModel is created", (Object)notationModel);
        notationModel.addDiagram(NotationFactory.eINSTANCE.createDiagram());
        Assert.assertNotNull((String)"Diagram is in the roots", (Object)notationModel.getResource().getContents().get(0));
        LayersModel layersModel = (LayersModel)this.modelSet.getModel("org.eclipse.papyrus.layers.runtime.model.LayersModel");
        Assert.assertNotNull((String)"LayerModel is created", (Object)((Object)layersModel));
        Assert.assertNotNull((String)"LayerStackApplication is created", (Object)layersModel.getLayerStackApplication());
    }

    @Test
    public void testDispose() {
        NotationModel notationModel = (NotationModel)this.modelSet.getModel("org.eclipse.papyrus.infra.core.resource.notation.NotationModel");
        NotationDiagramRemovedFromResourceEventNotifier notifier = new NotationDiagramRemovedFromResourceEventNotifier(notationModel);
        Assert.assertFalse((String)"application created", (boolean)notifier.isDisposed());
        notifier.dispose();
        Assert.assertTrue((String)"object is disposed", (boolean)notifier.isDisposed());
    }

    @Test
    @Ignore
    public void testAddLayersModelEventListener() {
        Assert.fail((String)"Not yet implemented");
    }

    @Test
    @Ignore
    public void testRemoveLayersModelEventListener() {
        Assert.fail((String)"Not yet implemented");
    }

    @Test
    public void testFireDiagramRemovedEvent() {
        NotationModel notationModel = (NotationModel)this.modelSet.getModel("org.eclipse.papyrus.infra.core.resource.notation.NotationModel");
        LayersModel layersModel = (LayersModel)this.modelSet.getModel("org.eclipse.papyrus.layers.runtime.model.LayersModel");
        Diagram diagram1 = NotationFactory.eINSTANCE.createDiagram();
        notationModel.addDiagram(diagram1);
        NotationDiagramHelper helperForDiag1 = new NotationDiagramHelper(layersModel, diagram1);
        Diagram diagram2 = NotationFactory.eINSTANCE.createDiagram();
        notationModel.addDiagram(diagram2);
        NotationDiagramHelper helperForDiag2 = new NotationDiagramHelper(layersModel, diagram2);
        NotationDiagramRemovedFromResourceEventNotifier notifier = new NotationDiagramRemovedFromResourceEventNotifier(notationModel);
        TraceNotationDiagramRemovedFromResourceEventListener traces = new TraceNotationDiagramRemovedFromResourceEventListener();
        notifier.addLayersModelEventListener(traces);
        helperForDiag1.attachLayersStack();
        helperForDiag2.attachLayersStack();
        traces.traces.clear();
        notationModel.getResource().getContents().remove((Object)diagram2);
        Assert.assertTrue((String)"event catched", (boolean)traces.traces.contains("diagramRemoved"));
        Assert.assertEquals((String)"number of events", (long)1L, (long)traces.traces.size());
        Assert.assertEquals((String)"diagram found in notification", (Object)diagram2, (Object)traces.traces.get((int)0).notifier.getOldValue());
        notifier.dispose();
    }
}

