/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.layers.runtime.model;

import org.eclipse.emf.common.util.URI;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.papyrus.infra.core.resource.IModel;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationModel;
import org.eclipse.papyrus.layers.runtime.model.LayersModel;
import org.eclipse.papyrus.layers.runtime.model.LayersModelEventRootNotifier;
import org.eclipse.papyrus.layers.runtime.model.TraceLayersModelRootEventListener;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersStackApplication;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class LayersModelRootEventNotifierTest {
    protected static final String PROJECT_MODEL_URI = "org.eclipse.papyrus.infra.core/tmp/model1.di";
    protected ModelSet modelSet;

    @Before
    public void setUp() throws Exception {
        ModelSet mngr = new ModelSet();
        LayersModel layersModel = new LayersModel();
        mngr.registerModel((IModel)layersModel);
        NotationModel notationModel = new NotationModel();
        mngr.registerModel((IModel)notationModel);
        URI uri = URI.createPlatformResourceURI((String)PROJECT_MODEL_URI, (boolean)true);
        mngr.createModels(uri);
        this.modelSet = mngr;
    }

    @After
    public void tearDown() throws Exception {
        this.modelSet.unload();
    }

    @Test
    public void testModelSetCreation() {
        NotationModel notationModel = (NotationModel)this.modelSet.getModel("org.eclipse.papyrus.infra.core.resource.notation.NotationModel");
        Assert.assertNotNull((String)"NotationModel is created", (Object)notationModel);
        notationModel.addDiagram(NotationFactory.eINSTANCE.createDiagram());
        Assert.assertNotNull((String)"Diagram is in the roots", (Object)notationModel.getResource().getContents().get(0));
        LayersModel layersModel = (LayersModel)this.modelSet.getModel("org.eclipse.papyrus.layers.runtime.model.LayersModel");
        Assert.assertNotNull((String)"LayerModel is created", (Object)((Object)layersModel));
        Assert.assertNotNull((String)"LayerStackApplication is created", (Object)layersModel.getLayerStackApplication());
    }

    @Test
    public void testLayersModelEventRootNotifier() {
        LayersModel layersModel = (LayersModel)this.modelSet.getModel("org.eclipse.papyrus.layers.runtime.model.LayersModel");
        LayersModelEventRootNotifier notifier = new LayersModelEventRootNotifier(layersModel);
        Assert.assertNotNull((String)"notifier created", (Object)notifier);
        notifier.dispose();
    }

    @Test
    public void testDispose() {
        LayersModel layersModel = (LayersModel)this.modelSet.getModel("org.eclipse.papyrus.layers.runtime.model.LayersModel");
        LayersModelEventRootNotifier notifier = new LayersModelEventRootNotifier(layersModel);
        Assert.assertNotNull((String)"notifier created", (Object)notifier);
        Assert.assertFalse((String)"notifier is disposed", (boolean)notifier.isDisposed());
        notifier.dispose();
        Assert.assertTrue((String)"notifier is disposed", (boolean)notifier.isDisposed());
    }

    @Test
    @Ignore
    public void testAddEventListener() {
        Assert.fail((String)"Not yet implemented");
    }

    @Test
    @Ignore
    public void testRemoveEventListener() {
        Assert.fail((String)"Not yet implemented");
    }

    @Test
    public void testFireLayersModelRootAddedEvent() {
        LayersModel layersModel = (LayersModel)this.modelSet.getModel("org.eclipse.papyrus.layers.runtime.model.LayersModel");
        LayersModelEventRootNotifier notifier = new LayersModelEventRootNotifier(layersModel);
        TraceLayersModelRootEventListener listener = new TraceLayersModelRootEventListener();
        notifier.addEventListener(listener);
        LayersStackApplication application = layersModel.getLayerStackApplication();
        Assert.assertTrue((String)"event sent", (listener.traces.size() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((String)"event found", (Object)"layersModelRootAdded", (Object)listener.traces.get((int)0).name);
    }

    @Test
    public void testFireLayersModelRootRemovedEvent() {
        LayersModel layersModel = (LayersModel)this.modelSet.getModel("org.eclipse.papyrus.layers.runtime.model.LayersModel");
        LayersModelEventRootNotifier notifier = new LayersModelEventRootNotifier(layersModel);
        TraceLayersModelRootEventListener listener = new TraceLayersModelRootEventListener();
        notifier.addEventListener(listener);
        LayersStackApplication application = layersModel.getLayerStackApplication();
        listener.traces.clear();
        layersModel.removeRoot(application);
        Assert.assertTrue((String)"event sent", (listener.traces.size() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((String)"event found", (Object)"layersModelRootRemoved", (Object)listener.traces.get((int)0).name);
    }
}

