/*******************************************************************************
 * Copyright (c) 2013 CEA LIST.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Cedric Dumoulin - cedric.dumoulin@lifl.fr
 ******************************************************************************/
/**
 */
package org.eclipse.papyrus.layers.stackmodel.layers.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersPackage;
import org.eclipse.papyrus.layers.stackmodel.layers.LineInstance;
import org.eclipse.papyrus.layers.stackmodel.layers.TypeInstance;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Line Instance</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 * <li>{@link org.eclipse.papyrus.layers.stackmodel.layers.impl.LineInstanceImpl#getLineColor <em>Line Color</em>}</li>
 * <li>{@link org.eclipse.papyrus.layers.stackmodel.layers.impl.LineInstanceImpl#getLineWith <em>Line With</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class LineInstanceImpl extends TypeInstanceImpl implements LineInstance {
	/**
	 * The default value of the '{@link #getLineColor() <em>Line Color</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @see #getLineColor()
	 * @generated
	 * @ordered
	 */
	protected static final int LINE_COLOR_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getLineColor() <em>Line Color</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @see #getLineColor()
	 * @generated
	 * @ordered
	 */
	protected int lineColor = LINE_COLOR_EDEFAULT;

	/**
	 * The default value of the '{@link #getLineWith() <em>Line With</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @see #getLineWith()
	 * @generated
	 * @ordered
	 */
	protected static final int LINE_WITH_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getLineWith() <em>Line With</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @see #getLineWith()
	 * @generated
	 * @ordered
	 */
	protected int lineWith = LINE_WITH_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected LineInstanceImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return LayersPackage.Literals.LINE_INSTANCE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public int getLineColor() {
		return lineColor;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public void setLineColor(int newLineColor) {
		int oldLineColor = lineColor;
		lineColor = newLineColor;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET, LayersPackage.LINE_INSTANCE__LINE_COLOR, oldLineColor, lineColor));
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public int getLineWith() {
		return lineWith;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public void setLineWith(int newLineWith) {
		int oldLineWith = lineWith;
		lineWith = newLineWith;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET, LayersPackage.LINE_INSTANCE__LINE_WITH, oldLineWith, lineWith));
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
		case LayersPackage.LINE_INSTANCE__LINE_COLOR:
			return getLineColor();
		case LayersPackage.LINE_INSTANCE__LINE_WITH:
			return getLineWith();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
		case LayersPackage.LINE_INSTANCE__LINE_COLOR:
			setLineColor((Integer) newValue);
			return;
		case LayersPackage.LINE_INSTANCE__LINE_WITH:
			setLineWith((Integer) newValue);
			return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
		case LayersPackage.LINE_INSTANCE__LINE_COLOR:
			setLineColor(LINE_COLOR_EDEFAULT);
			return;
		case LayersPackage.LINE_INSTANCE__LINE_WITH:
			setLineWith(LINE_WITH_EDEFAULT);
			return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
		case LayersPackage.LINE_INSTANCE__LINE_COLOR:
			return lineColor != LINE_COLOR_EDEFAULT;
		case LayersPackage.LINE_INSTANCE__LINE_WITH:
			return lineWith != LINE_WITH_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated NOT
	 */
	@Override
	public void setValueFromString(String value) {

		if (value == null || value.length() == 0) {
			return;
		}

		// The value should contains the 2 values, separated by comma
		// "lineColor, lineWith"
		String[] values = value.split(",");
		try {
			setLineColor(Integer.parseInt(values[0].trim()));
			setLineWith(Integer.parseInt(values[1].trim()));
		} catch (NumberFormatException e) {
			// fail silently
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated NOT
	 */
	@Override
	public void setValueFromInstance(TypeInstance value) {

		// Check if the value is of the right instance
		if (!getClass().isInstance(value)) {
			return;
		}

		LineInstance instance = (LineInstance) value;
		setLineColor(instance.getLineColor());
		setLineWith(instance.getLineWith());
	}


	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) {
			return super.toString();
		}

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (lineColor: ");
		result.append(lineColor);
		result.append(", lineWith: ");
		result.append(lineWith);
		result.append(')');
		return result.toString();
	}

} // LineInstanceImpl
