/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.layers.configmodel.layersconfig;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ClassnameKind implements Enumerator
{
    UNDEFINED(0, "UNDEFINED", "UNDEFINED"),
    EMF_CLASSNAME(1, "EMF_CLASSNAME", "EMF_CLASSNAME"),
    POJO_CLASSNAME(2, "POJO_CLASSNAME", "POJO_CLASSNAME"),
    NOT_FOUND(3, "NOT_FOUND", "NOT_FOUND");

    public static final int UNDEFINED_VALUE = 0;
    public static final int EMF_CLASSNAME_VALUE = 1;
    public static final int POJO_CLASSNAME_VALUE = 2;
    public static final int NOT_FOUND_VALUE = 3;
    private static final ClassnameKind[] VALUES_ARRAY;
    public static final List<ClassnameKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ClassnameKind[]{UNDEFINED, EMF_CLASSNAME, POJO_CLASSNAME, NOT_FOUND};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ClassnameKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ClassnameKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ClassnameKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ClassnameKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ClassnameKind get(int value) {
        switch (value) {
            case 0: {
                return UNDEFINED;
            }
            case 1: {
                return EMF_CLASSNAME;
            }
            case 2: {
                return POJO_CLASSNAME;
            }
            case 3: {
                return NOT_FOUND;
            }
        }
        return null;
    }

    private ClassnameKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

