/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.layers.stackmodel.exprmatcher;

import java.io.IOException;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.layers.stackmodel.LayersException;
import org.eclipse.papyrus.layers.stackmodel.exprmatcher.ExpressionMatcher;
import org.eclipse.papyrus.layers.stackmodel.util.FakeObservableListListener;
import org.eclipse.papyrus.layers.stackmodel.util.ObservableListView;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ExpressionMatcherTest {
    protected final String PLUGIN_PROJECT_NAME = "org.eclipse.papyrus.layers.stackmodel";

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    private Resource getResource(String modelFileName, String modelNotationKey) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        URI uri = URI.createPlatformPluginURI((String)("org.eclipse.papyrus.layers.stackmodel" + modelFileName + "." + modelNotationKey), (boolean)true);
        System.out.println("URI=" + uri.toString());
        Resource resource = resourceSet.getResource(uri, true);
        return resource;
    }

    private Diagram getDiagram(String modelFileName) {
        EObject root = (EObject)this.getResource(modelFileName, "notation").getContents().get(0);
        return (Diagram)root;
    }

    @Test
    public void testExpressionMatcher() throws LayersException {
        String expression = "self.oclIsKindOf(Shape)";
        String modelFileName = "/test/models/model1";
        Diagram diagram = this.getDiagram(modelFileName);
        EList searchRoots = diagram.getChildren();
        ExpressionMatcher expressionMatcher = new ExpressionMatcher(expression, (List<EObject>)searchRoots);
        Assert.assertNotNull((String)"object created", (Object)expressionMatcher);
    }

    @Test
    public void testExpression() throws LayersException {
        String expression = "self.oclAsType(Shape).visible = true";
        String modelFileName = "/test/models/model1";
        Diagram diagram = this.getDiagram(modelFileName);
        EList searchRoots = diagram.getChildren();
        ExpressionMatcher expressionMatcher = new ExpressionMatcher(expression, (List<EObject>)searchRoots);
        Assert.assertNotNull((String)"object created", (Object)expressionMatcher);
        Assert.assertTrue((String)"result not empty", (!expressionMatcher.getMatchingElements().isEmpty() ? 1 : 0) != 0);
    }

    @Test
    public void testExpressionMatcherWithWrongExpr() throws LayersException {
        String expression = "self.o";
        String modelFileName = "/test/models/model1";
        Diagram diagram = this.getDiagram(modelFileName);
        EList searchRoots = diagram.getChildren();
        try {
            ExpressionMatcher expressionMatcher = new ExpressionMatcher(expression, (List<EObject>)searchRoots);
        }
        catch (Exception e) {
            return;
        }
        Assert.fail((String)"An exception should be thrown");
    }

    @Test
    public void testRefreshMatchingElements() throws LayersException {
        String expression = "self.oclIsKindOf(Shape)";
        String modelFileName = "/test/models/model1";
        Diagram diagram = this.getDiagram(modelFileName);
        EList searchRoots = diagram.getChildren();
        ExpressionMatcher expressionMatcher = new ExpressionMatcher(expression, (List<EObject>)searchRoots);
        Assert.assertNotNull((String)"object created", (Object)expressionMatcher);
        Assert.assertTrue((String)"elements founds", (expressionMatcher.getMatchingElements().size() > 0 ? 1 : 0) != 0);
        expressionMatcher.refreshMatchingElements();
        Assert.assertEquals((String)"elements founds", (long)20L, (long)expressionMatcher.getMatchingElements().size());
    }

    @Test
    public void testGetExpression() throws LayersException {
        String expression = "self.oclIsKindOf(Shape)";
        String modelFileName = "/test/models/model1";
        Diagram diagram = this.getDiagram(modelFileName);
        EList searchRoots = diagram.getChildren();
        ExpressionMatcher expressionMatcher = new ExpressionMatcher(expression, (List<EObject>)searchRoots);
        Assert.assertEquals((String)"expression found", (Object)expression, (Object)expressionMatcher.getExpression());
    }

    @Test
    public void testSetExpression() throws LayersException {
        String expression = "self.oclIsKindOf(Shape)";
        String modelFileName = "/test/models/model1";
        Diagram diagram = this.getDiagram(modelFileName);
        EList searchRoots = diagram.getChildren();
        ExpressionMatcher expressionMatcher = new ExpressionMatcher(expression, (List<EObject>)searchRoots);
        Assert.assertNotNull((String)"object created", (Object)expressionMatcher);
        Assert.assertTrue((String)"elements founds", (expressionMatcher.getMatchingElements().size() > 0 ? 1 : 0) != 0);
        expressionMatcher.setExpression("self.oclAsType(Shape).visible = true");
        Assert.assertTrue((String)"elements founds", (expressionMatcher.getMatchingElements().size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetMatchingElements() throws LayersException {
        String expression = "self.oclIsKindOf(Shape)";
        String modelFileName = "/test/models/model1";
        Diagram diagram = this.getDiagram(modelFileName);
        EList searchRoots = diagram.getChildren();
        ExpressionMatcher expressionMatcher = new ExpressionMatcher(expression, (List<EObject>)searchRoots);
        Assert.assertNotNull((String)"object created", (Object)expressionMatcher);
        Assert.assertTrue((String)"elements founds", (expressionMatcher.getMatchingElements().size() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((String)"elements founds", (long)20L, (long)expressionMatcher.getMatchingElements().size());
    }

    @Test
    public void testResourceExist() throws IOException, CoreException {
        String modelNotationKey = "notation";
        String modelUMLKey = "uml";
        String modelFileName = "/test/models/model1";
        Resource resource = this.getResource(modelFileName, modelNotationKey);
        Assert.assertNotNull((String)"modelFile exist", (Object)resource);
        Assert.assertTrue((String)"model is loaded", (!resource.getContents().isEmpty() ? 1 : 0) != 0);
    }

    @Test
    public void testDiagramExist() throws IOException, CoreException {
        String modelFileName = "/test/models/model1";
        Diagram diagram = this.getDiagram(modelFileName);
        Assert.assertNotNull((String)"Diagram exist", (Object)diagram);
    }

    @Test
    public void testRemoveElements() throws LayersException {
        String expression = "self.oclIsKindOf(Shape)";
        String modelFileName = "/test/models/model1";
        Diagram diagram = this.getDiagram(modelFileName);
        int removedElementCount = 5;
        int addedElementCount = 0;
        int expectedEventCount = 1;
        ObservableListView matchingElements = new ObservableListView();
        ExpressionMatcher expressionMatcher = new ExpressionMatcher(expression, (List<View>)((Object)matchingElements), (EObject)diagram);
        FakeObservableListListener notifyingListListener = new FakeObservableListListener();
        matchingElements.getEventBus().register(notifyingListListener);
        notifyingListListener.traces.clear();
        this.removeElements(diagram, removedElementCount);
        expressionMatcher.refreshMatchingElements();
        Assert.assertSame((String)"event propagated", (Object)expectedEventCount, (Object)notifyingListListener.traces.size());
        ObservableListView.ObservableListEvent event = (ObservableListView.ObservableListEvent)notifyingListListener.traces.get((int)0).notifier;
        Assert.assertEquals((String)"expected removed count", (long)removedElementCount, (long)event.getRemovedElements().size());
        Assert.assertEquals((String)"expected added count", (long)addedElementCount, (long)event.getAddedElements().size());
    }

    @Test
    public void testAddElements() throws LayersException {
        String expression = "self.oclIsKindOf(Shape)";
        String modelFileName = "/test/models/model1";
        Diagram diagram = this.getDiagram(modelFileName);
        int removedElementCount = 0;
        int addedElementCount = 5;
        int expectedEventCount = 1;
        int viewsCount = diagram.getChildren().size();
        ObservableListView matchingElements = new ObservableListView();
        ExpressionMatcher expressionMatcher = new ExpressionMatcher(expression, (List<View>)((Object)matchingElements), (EObject)diagram);
        FakeObservableListListener notifyingListListener = new FakeObservableListListener();
        matchingElements.getEventBus().register(notifyingListListener);
        notifyingListListener.traces.clear();
        this.addShapeElements(diagram, addedElementCount);
        this.removeElements(diagram, removedElementCount);
        expressionMatcher.refreshMatchingElements();
        Assert.assertSame((String)"elements added", (Object)(viewsCount + addedElementCount), (Object)diagram.getChildren().size());
        Assert.assertSame((String)"event propagated", (Object)expectedEventCount, (Object)notifyingListListener.traces.size());
        ObservableListView.ObservableListEvent event = (ObservableListView.ObservableListEvent)notifyingListListener.traces.get((int)0).notifier;
        Assert.assertEquals((String)"expected removed count", (long)removedElementCount, (long)event.getRemovedElements().size());
        Assert.assertEquals((String)"expected added count", (long)addedElementCount, (long)event.getAddedElements().size());
    }

    @Test
    public void testAddAndRemoveElements() throws LayersException {
        String expression = "self.oclIsKindOf(Shape)";
        String modelFileName = "/test/models/model1";
        Diagram diagram = this.getDiagram(modelFileName);
        int removedElementCount = 4;
        int addedElementCount = 5;
        int expectedEventCount = 1;
        int viewsCount = diagram.getChildren().size();
        ObservableListView matchingElements = new ObservableListView();
        ExpressionMatcher expressionMatcher = new ExpressionMatcher(expression, (List<View>)((Object)matchingElements), (EObject)diagram);
        FakeObservableListListener notifyingListListener = new FakeObservableListListener();
        matchingElements.getEventBus().register(notifyingListListener);
        notifyingListListener.traces.clear();
        this.removeElements(diagram, removedElementCount);
        this.addShapeElements(diagram, addedElementCount);
        expressionMatcher.refreshMatchingElements();
        Assert.assertSame((String)"elements added", (Object)(viewsCount + addedElementCount - removedElementCount), (Object)diagram.getChildren().size());
        Assert.assertSame((String)"event propagated", (Object)expectedEventCount, (Object)notifyingListListener.traces.size());
        ObservableListView.ObservableListEvent event = (ObservableListView.ObservableListEvent)notifyingListListener.traces.get((int)0).notifier;
        Assert.assertEquals((String)"expected removed count", (long)removedElementCount, (long)event.getRemovedElements().size());
        Assert.assertEquals((String)"expected added count", (long)addedElementCount, (long)event.getAddedElements().size());
    }

    private void removeElements(Diagram diagram, int removedElementCount) {
        EList views = diagram.getChildren();
        int index = views.size() - 1;
        int i = 0;
        while (i < removedElementCount && index >= 0) {
            diagram.removeChild((View)views.get(index));
            index = views.size() - 1;
            ++i;
        }
    }

    private void addShapeElements(Diagram diagram, int elementCount) {
        int i = 0;
        while (i < elementCount) {
            diagram.createChild(NotationPackage.eINSTANCE.getShape());
            ++i;
        }
    }
}

