/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.layers.stackmodel.integration;

import org.eclipse.emf.common.util.EList;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.papyrus.layers.stackmodel.LayersException;
import org.eclipse.papyrus.layers.stackmodel.layers.AbstractLayerOperator;
import org.eclipse.papyrus.layers.stackmodel.layers.Layer;
import org.eclipse.papyrus.layers.stackmodel.layers.LayerOperatorDescriptor;
import org.eclipse.papyrus.layers.stackmodel.layers.LayerState;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersFactory;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersFactoryForStack;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersStack;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersStackApplication;
import org.eclipse.papyrus.layers.stackmodel.layers.RegExpLayer;
import org.eclipse.papyrus.layers.stackmodel.layers.StackedLayerOperator;
import org.eclipse.papyrus.layers.stackmodel.layers.TopLayerOperator;
import org.eclipse.papyrus.layers.stackmodel.layers.impl.LayersFactoryForStackImpl;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class LayersStateAfterReloadTest {
    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testCreateLayersFactoryForStackImpl() throws LayersException {
        LayersStackApplication application = LayersFactory.eINSTANCE.createLayersStackApplication();
        Diagram diagram = NotationFactory.eINSTANCE.createDiagram();
        LayersStack owningStack = application.getLayersStackFor(diagram);
        LayersFactoryForStack factory = LayersFactoryForStack.eINSTANCE;
        Assert.assertNotNull((String)"factory created", (Object)factory);
        TopLayerOperator rootLayer = factory.createTopLayerOperator(owningStack, owningStack, application);
        Layer layer1 = factory.createLayer(rootLayer, owningStack, application);
        Layer layer2 = factory.createLayer(rootLayer, owningStack, application);
        TopLayerOperator layerOperator1 = factory.createTopLayerOperator(rootLayer, owningStack, application);
        Layer layer3 = factory.createLayer(layerOperator1, owningStack, application);
        Assert.assertNotNull((String)"Layer created", (Object)rootLayer);
        Assert.assertNotNull((String)"Layer created", (Object)layer1);
        Assert.assertNotNull((String)"Layer created", (Object)layer2);
        Assert.assertNotNull((String)"Layer created", (Object)layerOperator1);
        Assert.assertNotNull((String)"Layer created", (Object)layer3);
    }

    @Test
    public void testFindNewLayerName() {
        LayersFactoryForStackImpl factory = new LayersFactoryForStackImpl();
        String expectedName1 = String.valueOf(factory.LAYER_NAME_PREFIX) + "0";
        TopLayerOperator parent = LayersFactory.eINSTANCE.createTopLayerOperator();
        String name1 = factory.findNewLayerName(parent);
        Assert.assertEquals((String)"expected name", (Object)expectedName1, (Object)name1);
    }

    @Test
    @Ignore
    public void testCreateLayersStack() {
        Assert.fail((String)"Not yet implemented");
    }

    @Test
    public void testInitLayer() throws LayersException {
        LayersStackApplication application = LayersFactory.eINSTANCE.createLayersStackApplication();
        Diagram diagram = NotationFactory.eINSTANCE.createDiagram();
        LayersStack owningStack = application.getLayersStackFor(diagram);
        LayersFactoryForStack factory = LayersFactoryForStack.eINSTANCE;
        TopLayerOperator rootLayer = factory.createTopLayerOperator(owningStack, owningStack, application);
        Layer layer1 = LayersFactory.eINSTANCE.createLayer();
        factory.initLayer(layer1, rootLayer, owningStack, application);
        Assert.assertNotNull((String)"Layer created", (Object)layer1);
        Assert.assertSame((String)"state attached", (Object)((Object)LayerState.ATTACHED), (Object)((Object)layer1.getState()));
        Assert.assertSame((String)"application set", (Object)application, (Object)layer1.getApplication());
        Assert.assertSame((String)"owningStack set", (Object)owningStack, (Object)layer1.getOwningLayersStack());
        Assert.assertSame((String)"parent set", (Object)rootLayer, (Object)layer1.eContainer());
    }

    @Test
    public void testCreateLayer() throws LayersException {
        LayersStackApplication application = LayersFactory.eINSTANCE.createLayersStackApplication();
        Diagram diagram = NotationFactory.eINSTANCE.createDiagram();
        LayersStack owningStack = application.getLayersStackFor(diagram);
        LayersFactoryForStack factory = LayersFactoryForStack.eINSTANCE;
        TopLayerOperator rootLayer = factory.createTopLayerOperator(owningStack, owningStack, application);
        Layer layer1 = factory.createLayer(rootLayer, owningStack, application);
        Assert.assertNotNull((String)"Layer created", (Object)layer1);
        Assert.assertSame((String)"state attached", (Object)((Object)LayerState.ATTACHED), (Object)((Object)layer1.getState()));
        Assert.assertSame((String)"application set", (Object)application, (Object)layer1.getApplication());
        Assert.assertSame((String)"owningStack set", (Object)owningStack, (Object)layer1.getOwningLayersStack());
        Assert.assertSame((String)"parent set", (Object)rootLayer, (Object)layer1.eContainer());
    }

    @Test
    public void testCreateLayerAsRoot() throws LayersException {
        LayersStackApplication application = LayersFactory.eINSTANCE.createLayersStackApplication();
        Diagram diagram = NotationFactory.eINSTANCE.createDiagram();
        LayersStack owningStack = application.getLayersStackFor(diagram);
        LayersFactoryForStack factory = LayersFactoryForStack.eINSTANCE;
        Layer layer1 = factory.createLayer(owningStack, owningStack, application);
        Assert.assertNotNull((String)"Layer created", (Object)layer1);
        Assert.assertSame((String)"state attached", (Object)((Object)LayerState.ATTACHED), (Object)((Object)layer1.getState()));
        Assert.assertSame((String)"application set", (Object)application, (Object)layer1.getApplication());
        Assert.assertSame((String)"owningStack set", (Object)owningStack, (Object)layer1.getOwningLayersStack());
        Assert.assertSame((String)"parent set", (Object)owningStack, (Object)layer1.eContainer());
    }

    @Test
    public void testCreateRegExpLayer() throws LayersException {
        LayersStackApplication application = LayersFactory.eINSTANCE.createLayersStackApplication();
        Diagram diagram = NotationFactory.eINSTANCE.createDiagram();
        LayersStack owningStack = application.getLayersStackFor(diagram);
        LayersFactoryForStack factory = LayersFactoryForStack.eINSTANCE;
        TopLayerOperator rootLayer = factory.createTopLayerOperator(owningStack, owningStack, application);
        RegExpLayer layer1 = factory.createRegExpLayer(rootLayer, owningStack, application);
        Assert.assertNotNull((String)"Layer created", (Object)layer1);
        Assert.assertSame((String)"state attached", (Object)((Object)LayerState.ATTACHED), (Object)((Object)layer1.getState()));
        Assert.assertSame((String)"application set", (Object)application, (Object)layer1.getApplication());
        Assert.assertSame((String)"owningStack set", (Object)owningStack, (Object)layer1.getOwningLayersStack());
        Assert.assertSame((String)"parent set", (Object)rootLayer, (Object)layer1.eContainer());
    }

    @Test
    public void testCreateRegExpLayerAsRoot() throws LayersException {
        LayersStackApplication application = LayersFactory.eINSTANCE.createLayersStackApplication();
        Diagram diagram = NotationFactory.eINSTANCE.createDiagram();
        LayersStack owningStack = application.getLayersStackFor(diagram);
        LayersFactoryForStack factory = LayersFactoryForStack.eINSTANCE;
        RegExpLayer layer1 = factory.createRegExpLayer(owningStack, owningStack, application);
        Assert.assertNotNull((String)"Layer created", (Object)layer1);
        Assert.assertSame((String)"state attached", (Object)((Object)LayerState.ATTACHED), (Object)((Object)layer1.getState()));
        Assert.assertSame((String)"application set", (Object)application, (Object)layer1.getApplication());
        Assert.assertSame((String)"owningStack set", (Object)owningStack, (Object)layer1.getOwningLayersStack());
        Assert.assertSame((String)"parent set", (Object)owningStack, (Object)layer1.eContainer());
    }

    @Test
    public void testCreateTopLayerOperator() throws LayersException {
        LayersStackApplication application = LayersFactory.eINSTANCE.createLayersStackApplication();
        Diagram diagram = NotationFactory.eINSTANCE.createDiagram();
        LayersStack owningStack = application.getLayersStackFor(diagram);
        LayersFactoryForStack factory = LayersFactoryForStack.eINSTANCE;
        TopLayerOperator rootLayer = factory.createTopLayerOperator(owningStack, owningStack, application);
        TopLayerOperator layer1 = factory.createTopLayerOperator(rootLayer, owningStack, application);
        Assert.assertNotNull((String)"Layer created", (Object)layer1);
        Assert.assertSame((String)"state attached", (Object)((Object)LayerState.ATTACHED), (Object)((Object)layer1.getState()));
        Assert.assertSame((String)"application set", (Object)application, (Object)layer1.getApplication());
        Assert.assertSame((String)"owningStack set", (Object)owningStack, (Object)layer1.getOwningLayersStack());
        Assert.assertSame((String)"parent set", (Object)rootLayer, (Object)layer1.eContainer());
    }

    @Test
    public void testCreateTopLayerOperatorAsRoot() throws LayersException {
        LayersStackApplication application = LayersFactory.eINSTANCE.createLayersStackApplication();
        Diagram diagram = NotationFactory.eINSTANCE.createDiagram();
        LayersStack owningStack = application.getLayersStackFor(diagram);
        LayersFactoryForStack factory = LayersFactoryForStack.eINSTANCE;
        TopLayerOperator layer1 = factory.createTopLayerOperator(owningStack, owningStack, application);
        Assert.assertNotNull((String)"Layer created", (Object)layer1);
        Assert.assertSame((String)"state attached", (Object)((Object)LayerState.ATTACHED), (Object)((Object)layer1.getState()));
        Assert.assertSame((String)"application set", (Object)application, (Object)layer1.getApplication());
        Assert.assertSame((String)"owningStack set", (Object)owningStack, (Object)layer1.getOwningLayersStack());
        Assert.assertSame((String)"parent set", (Object)owningStack, (Object)layer1.eContainer());
    }

    @Test
    public void testCreateStackedLayerOperator() throws LayersException {
        LayersStackApplication application = LayersFactory.eINSTANCE.createLayersStackApplication();
        Diagram diagram = NotationFactory.eINSTANCE.createDiagram();
        LayersStack owningStack = application.getLayersStackFor(diagram);
        LayersFactoryForStack factory = LayersFactoryForStack.eINSTANCE;
        TopLayerOperator rootLayer = factory.createTopLayerOperator(owningStack, owningStack, application);
        StackedLayerOperator layer1 = factory.createStackedLayerOperator(rootLayer, owningStack, application);
        Assert.assertNotNull((String)"Layer created", (Object)layer1);
        Assert.assertSame((String)"state attached", (Object)((Object)LayerState.ATTACHED), (Object)((Object)layer1.getState()));
        Assert.assertSame((String)"application set", (Object)application, (Object)layer1.getApplication());
        Assert.assertSame((String)"owningStack set", (Object)owningStack, (Object)layer1.getOwningLayersStack());
        Assert.assertSame((String)"parent set", (Object)rootLayer, (Object)layer1.eContainer());
    }

    @Test
    public void testCreateStackedLayerOperatorAsRoot() throws LayersException {
        LayersStackApplication application = LayersFactory.eINSTANCE.createLayersStackApplication();
        Diagram diagram = NotationFactory.eINSTANCE.createDiagram();
        LayersStack owningStack = application.getLayersStackFor(diagram);
        LayersFactoryForStack factory = LayersFactoryForStack.eINSTANCE;
        StackedLayerOperator layer1 = factory.createStackedLayerOperator(owningStack, owningStack, application);
        Assert.assertNotNull((String)"Layer created", (Object)layer1);
        Assert.assertSame((String)"state attached", (Object)((Object)LayerState.ATTACHED), (Object)((Object)layer1.getState()));
        Assert.assertSame((String)"application set", (Object)application, (Object)layer1.getApplication());
        Assert.assertSame((String)"owningStack set", (Object)owningStack, (Object)layer1.getOwningLayersStack());
        Assert.assertSame((String)"parent set", (Object)owningStack, (Object)layer1.eContainer());
    }

    @Test
    public void testCreateLayerOperator() throws LayersException {
        LayersStackApplication application = LayersFactory.eINSTANCE.createLayersStackApplication();
        Diagram diagram = NotationFactory.eINSTANCE.createDiagram();
        LayersStack owningStack = application.getLayersStackFor(diagram);
        LayersFactoryForStack factory = LayersFactoryForStack.eINSTANCE;
        TopLayerOperator rootLayer = factory.createTopLayerOperator(owningStack, owningStack, application);
        EList<LayerOperatorDescriptor> operatorDescs = application.getLayerOperatorDescriptorRegistry().getDescriptors();
        Assert.assertNotNull((String)"descs found", operatorDescs);
        Assert.assertTrue((String)"a least one desc is defined", (operatorDescs.size() > 0 ? 1 : 0) != 0);
        String layerID = ((LayerOperatorDescriptor)operatorDescs.get(0)).getName();
        AbstractLayerOperator layer1 = factory.createLayerOperator(layerID, rootLayer, owningStack, application);
        Assert.assertNotNull((String)"Layer created", (Object)layer1);
        Assert.assertSame((String)"state attached", (Object)((Object)LayerState.ATTACHED), (Object)((Object)layer1.getState()));
        Assert.assertSame((String)"application set", (Object)application, (Object)layer1.getApplication());
        Assert.assertSame((String)"owningStack set", (Object)owningStack, (Object)layer1.getOwningLayersStack());
        Assert.assertSame((String)"parent set", (Object)rootLayer, (Object)layer1.eContainer());
    }
}

