/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.layers.stackmodel.layers;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum EventLevel implements Enumerator
{
    LEVEL1(0, "level1", "level1"),
    ALL_LEVELS(-1, "allLevels", "allLevels");

    public static final int LEVEL1_VALUE = 0;
    public static final int ALL_LEVELS_VALUE = -1;
    private static final EventLevel[] VALUES_ARRAY;
    public static final List<EventLevel> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new EventLevel[]{LEVEL1, ALL_LEVELS};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static EventLevel get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EventLevel result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EventLevel getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EventLevel result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EventLevel get(int value) {
        switch (value) {
            case 0: {
                return LEVEL1;
            }
            case -1: {
                return ALL_LEVELS;
            }
        }
        return null;
    }

    private EventLevel(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

