/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.layers.stackmodel.layers.impl;

import org.eclipse.papyrus.layers.stackmodel.LayersException;
import org.eclipse.papyrus.layers.stackmodel.layers.CustomPropertyOperator;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersFactory;
import org.eclipse.papyrus.layers.stackmodel.operators.BooleanAndOperator;
import org.eclipse.papyrus.layers.stackmodel.operators.FakePropertyOperator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class CustomPropertyOperatorImplTest {
    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testGetComputePropertyValueCommand() throws LayersException {
        CustomPropertyOperator operator = LayersFactory.eINSTANCE.createCustomPropertyOperator();
        FakePropertyOperator opInstance = new FakePropertyOperator();
        operator.setOperatorInstance(opInstance);
        operator.getComputePropertyValueCommand(null);
        Assert.assertTrue((String)"custom op getCmd method is called", (boolean)opInstance.isComputePropertyValueCommandCalled);
    }

    @Test
    public void testCustomPropertyOperatorImpl() {
        CustomPropertyOperator operator = LayersFactory.eINSTANCE.createCustomPropertyOperator();
        Assert.assertNotNull((String)"object created", (Object)operator);
    }

    @Test
    public void testSetClassname() {
        CustomPropertyOperator operator = LayersFactory.eINSTANCE.createCustomPropertyOperator();
        String classname = BooleanAndOperator.class.getName();
        operator.setClassname(classname);
        Assert.assertSame((String)"classname found", (Object)classname, (Object)operator.getClassname());
    }

    @Test
    public void testGetOperatorInstance() {
        CustomPropertyOperator operator = LayersFactory.eINSTANCE.createCustomPropertyOperator();
        BooleanAndOperator opInstance = new BooleanAndOperator();
        operator.setOperatorInstance(opInstance);
        Assert.assertSame((String)"custom op found", (Object)opInstance, (Object)operator.getOperatorInstance());
    }

    @Test
    public void testGetOperatorInstanceFromClassname() {
        CustomPropertyOperator operator = LayersFactory.eINSTANCE.createCustomPropertyOperator();
        operator.setClassname(BooleanAndOperator.class.getName());
        Assert.assertNotNull((String)"custom op created and found", (Object)operator.getOperatorInstance());
    }

    @Test
    public void testSetOperatorInstance() {
        CustomPropertyOperator operator = LayersFactory.eINSTANCE.createCustomPropertyOperator();
        BooleanAndOperator opInstance = new BooleanAndOperator();
        operator.setOperatorInstance(opInstance);
        Assert.assertSame((String)"custom op found", (Object)opInstance, (Object)operator.getOperatorInstance());
    }

    @Test
    @Ignore
    public void testSetClassBundleID() {
        Assert.fail((String)"Not yet implemented");
    }

    @Test
    @Ignore
    public void testResetOperatorInstance() {
        Assert.fail((String)"Not yet implemented");
    }
}

