/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.layers.stackmodel.layers.impl;

import org.eclipse.papyrus.layers.stackmodel.LayersException;
import org.eclipse.papyrus.layers.stackmodel.layers.AbstractLayerOperator;
import org.eclipse.papyrus.layers.stackmodel.layers.Layer;
import org.eclipse.papyrus.layers.stackmodel.layers.LayerExpression;
import org.eclipse.papyrus.layers.stackmodel.layers.LayerOperator;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersContainer;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersFactory;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersFactoryForStack;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersStack;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersStackApplication;
import org.eclipse.papyrus.layers.stackmodel.layers.RegExpLayer;
import org.eclipse.papyrus.layers.stackmodel.layers.StackedLayerOperator;
import org.eclipse.papyrus.layers.stackmodel.layers.TopLayerOperator;

public class LayersFactoryForStackImpl
implements LayersFactoryForStack {
    protected int newIndex = 0;
    public final String LAYER_NAME_PREFIX = "layer";

    public static LayersFactoryForStack init() {
        return new LayersFactoryForStackImpl();
    }

    public String findNewLayerName(LayersContainer parent) {
        String proposedName = "layer" + this.newIndex++;
        if (parent instanceof LayerOperator) {
            LayerOperator parentOperator = (LayerOperator)parent;
            while (this.getLayerByName(parentOperator, proposedName) != null) {
                proposedName = "layer" + this.newIndex++;
            }
        }
        return proposedName;
    }

    private LayerExpression getLayerByName(LayerOperator parentOperator, String name) {
        for (LayerExpression layer : parentOperator.getLayers()) {
            if (!name.equals(layer.getName())) continue;
            return layer;
        }
        return null;
    }

    @Override
    public LayersStack createLayersStack() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public LayerExpression initLayer(LayerExpression layer, LayersContainer parentLayer, LayersStack owningStack, LayersStackApplication application) throws LayersException {
        layer.setApplication(application);
        layer.setName(this.findNewLayerName(parentLayer));
        parentLayer.addLayer(layer);
        layer.setOwningLayersStack(owningStack);
        layer.attach();
        return layer;
    }

    @Override
    public Layer createLayer(LayersContainer parent, LayersStack owningStack, LayersStackApplication application) throws LayersException {
        Layer layer = LayersFactory.eINSTANCE.createLayer();
        this.initLayer(layer, parent, owningStack, application);
        return layer;
    }

    @Override
    public RegExpLayer createRegExpLayer(LayersContainer parent, LayersStack owningStack, LayersStackApplication application) throws LayersException {
        RegExpLayer layer = LayersFactory.eINSTANCE.createRegExpLayer();
        this.initLayer(layer, parent, owningStack, application);
        return layer;
    }

    @Override
    public TopLayerOperator createTopLayerOperator(LayersContainer parent, LayersStack owningStack, LayersStackApplication application) throws LayersException {
        TopLayerOperator layer = LayersFactory.eINSTANCE.createTopLayerOperator();
        this.initLayer(layer, parent, owningStack, application);
        return layer;
    }

    @Override
    public StackedLayerOperator createStackedLayerOperator(LayersContainer parent, LayersStack owningStack, LayersStackApplication application) throws LayersException {
        StackedLayerOperator layer = LayersFactory.eINSTANCE.createStackedLayerOperator();
        this.initLayer(layer, parent, owningStack, application);
        return layer;
    }

    @Override
    public AbstractLayerOperator createLayerOperator(String layerOperatorID, LayersContainer parent, LayersStack owningStack, LayersStackApplication application) throws LayersException {
        AbstractLayerOperator layerOperator = application.getLayerOperatorDescriptorRegistry().createLayerOperator(layerOperatorID);
        this.initLayer(layerOperator, parent, owningStack, application);
        return layerOperator;
    }
}

