/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.layers.stackmodel.layers.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.layers.stackmodel.NotFoundException;
import org.eclipse.papyrus.layers.stackmodel.layers.LayerApplicationFactory;
import org.eclipse.papyrus.layers.stackmodel.layers.LayerDescriptorRegistry;
import org.eclipse.papyrus.layers.stackmodel.layers.LayerOperatorDescriptorRegistry;
import org.eclipse.papyrus.layers.stackmodel.layers.LayerStackDescriptorRegistry;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersFactory;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersPackage;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersStack;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersStackApplication;
import org.eclipse.papyrus.layers.stackmodel.layers.PropertyRegistry;
import org.eclipse.papyrus.layers.stackmodel.layers.PropertySetterRegistry;
import org.eclipse.papyrus.layers.stackmodel.layers.TopLayerOperator;
import org.eclipse.papyrus.layers.stackmodel.layers.impl.FolderElementImpl;
import org.eclipse.papyrus.layers.stackmodel.layers.loaders.LayersConfigModel;
import org.eclipse.papyrus.layers.stackmodel.layers.loaders.RegistriesLoader;

public class LayersStackApplicationImpl
extends FolderElementImpl
implements LayersStackApplication {
    protected EList<LayersStack> layersStacks;
    protected LayerStackDescriptorRegistry layerStackRegistry;
    protected PropertyRegistry propertyRegistry;
    protected LayerDescriptorRegistry layerDescriptorRegistry;
    protected LayerApplicationFactory factory;
    protected PropertySetterRegistry propertySetterRegistry;
    protected LayerOperatorDescriptorRegistry layerOperatorDescriptorRegistry;

    protected LayersStackApplicationImpl() {
        this.init();
    }

    protected void init() {
        PropertyRegistry propertyRegistry = LayersFactory.eINSTANCE.createPropertyRegistry();
        this.setPropertyRegistry(propertyRegistry);
        LayerStackDescriptorRegistry layerStackDescriptorRegistry = LayersFactory.eINSTANCE.createLayerStackDescriptorRegistry();
        this.setLayerStackRegistry(layerStackDescriptorRegistry);
        LayerDescriptorRegistry layerDescriptorRegistry = LayersFactory.eINSTANCE.createLayerDescriptorRegistry();
        this.setLayerDescriptorRegistry(layerDescriptorRegistry);
        LayersConfigModel configModel = LayersConfigModel.getInstance();
        RegistriesLoader registriesLoader = new RegistriesLoader(configModel);
        LayerOperatorDescriptorRegistry layerOperatorDescriptorRegistry = LayersFactory.eINSTANCE.createLayerOperatorDescriptorRegistry();
        layerOperatorDescriptorRegistry.setPropertyCollectionSize(propertyRegistry.getPropertiesCount());
        registriesLoader.loadLayerOperatorDescriptorRegistry(layerOperatorDescriptorRegistry, propertyRegistry);
        this.setLayerOperatorDescriptorRegistry(layerOperatorDescriptorRegistry);
        LayerApplicationFactory layerApplicationFactory = LayersFactory.eINSTANCE.createLayerApplicationFactory();
        this.setFactory(layerApplicationFactory);
        PropertySetterRegistry propertySetterRegistry = LayersFactory.eINSTANCE.createPropertySetterRegistry();
        propertySetterRegistry.setApplication(this);
        this.setPropertySetterRegistry(propertySetterRegistry);
    }

    @Override
    protected EClass eStaticClass() {
        return LayersPackage.Literals.LAYERS_STACK_APPLICATION;
    }

    @Override
    public EList<LayersStack> getLayersStacks() {
        if (this.layersStacks == null) {
            this.layersStacks = new EObjectContainmentEList(LayersStack.class, (InternalEObject)this, 0);
        }
        return this.layersStacks;
    }

    @Override
    public LayerStackDescriptorRegistry getLayerStackRegistry() {
        return this.layerStackRegistry;
    }

    public NotificationChain basicSetLayerStackRegistry(LayerStackDescriptorRegistry newLayerStackRegistry, NotificationChain msgs) {
        LayerStackDescriptorRegistry oldLayerStackRegistry = this.layerStackRegistry;
        this.layerStackRegistry = newLayerStackRegistry;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldLayerStackRegistry, (Object)newLayerStackRegistry);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setLayerStackRegistry(LayerStackDescriptorRegistry newLayerStackRegistry) {
        if (newLayerStackRegistry != this.layerStackRegistry) {
            NotificationChain msgs = null;
            if (this.layerStackRegistry != null) {
                msgs = ((InternalEObject)this.layerStackRegistry).eInverseRemove((InternalEObject)this, -2, null, msgs);
            }
            if (newLayerStackRegistry != null) {
                msgs = ((InternalEObject)newLayerStackRegistry).eInverseAdd((InternalEObject)this, -2, null, msgs);
            }
            if ((msgs = this.basicSetLayerStackRegistry(newLayerStackRegistry, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)newLayerStackRegistry, (Object)newLayerStackRegistry));
        }
    }

    @Override
    public PropertyRegistry getPropertyRegistry() {
        return this.propertyRegistry;
    }

    public NotificationChain basicSetPropertyRegistry(PropertyRegistry newPropertyRegistry, NotificationChain msgs) {
        PropertyRegistry oldPropertyRegistry = this.propertyRegistry;
        this.propertyRegistry = newPropertyRegistry;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldPropertyRegistry, (Object)newPropertyRegistry);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setPropertyRegistry(PropertyRegistry newPropertyRegistry) {
        if (newPropertyRegistry != this.propertyRegistry) {
            NotificationChain msgs = null;
            if (this.propertyRegistry != null) {
                msgs = ((InternalEObject)this.propertyRegistry).eInverseRemove((InternalEObject)this, -3, null, msgs);
            }
            if (newPropertyRegistry != null) {
                msgs = ((InternalEObject)newPropertyRegistry).eInverseAdd((InternalEObject)this, -3, null, msgs);
            }
            if ((msgs = this.basicSetPropertyRegistry(newPropertyRegistry, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)newPropertyRegistry, (Object)newPropertyRegistry));
        }
    }

    @Override
    public LayerDescriptorRegistry getLayerDescriptorRegistry() {
        return this.layerDescriptorRegistry;
    }

    public NotificationChain basicSetLayerDescriptorRegistry(LayerDescriptorRegistry newLayerDescriptorRegistry, NotificationChain msgs) {
        LayerDescriptorRegistry oldLayerDescriptorRegistry = this.layerDescriptorRegistry;
        this.layerDescriptorRegistry = newLayerDescriptorRegistry;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldLayerDescriptorRegistry, (Object)newLayerDescriptorRegistry);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setLayerDescriptorRegistry(LayerDescriptorRegistry newLayerDescriptorRegistry) {
        if (newLayerDescriptorRegistry != this.layerDescriptorRegistry) {
            NotificationChain msgs = null;
            if (this.layerDescriptorRegistry != null) {
                msgs = ((InternalEObject)this.layerDescriptorRegistry).eInverseRemove((InternalEObject)this, -4, null, msgs);
            }
            if (newLayerDescriptorRegistry != null) {
                msgs = ((InternalEObject)newLayerDescriptorRegistry).eInverseAdd((InternalEObject)this, -4, null, msgs);
            }
            if ((msgs = this.basicSetLayerDescriptorRegistry(newLayerDescriptorRegistry, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)newLayerDescriptorRegistry, (Object)newLayerDescriptorRegistry));
        }
    }

    @Override
    public LayerApplicationFactory getFactory() {
        return this.factory;
    }

    public NotificationChain basicSetFactory(LayerApplicationFactory newFactory, NotificationChain msgs) {
        LayerApplicationFactory oldFactory = this.factory;
        this.factory = newFactory;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldFactory, (Object)newFactory);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setFactory(LayerApplicationFactory newFactory) {
        if (newFactory != this.factory) {
            NotificationChain msgs = null;
            if (this.factory != null) {
                msgs = ((InternalEObject)this.factory).eInverseRemove((InternalEObject)this, 0, LayerApplicationFactory.class, msgs);
            }
            if (newFactory != null) {
                msgs = ((InternalEObject)newFactory).eInverseAdd((InternalEObject)this, 0, LayerApplicationFactory.class, msgs);
            }
            if ((msgs = this.basicSetFactory(newFactory, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)newFactory, (Object)newFactory));
        }
    }

    @Override
    public PropertySetterRegistry getPropertySetterRegistry() {
        return this.propertySetterRegistry;
    }

    public NotificationChain basicSetPropertySetterRegistry(PropertySetterRegistry newPropertySetterRegistry, NotificationChain msgs) {
        PropertySetterRegistry oldPropertySetterRegistry = this.propertySetterRegistry;
        this.propertySetterRegistry = newPropertySetterRegistry;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldPropertySetterRegistry, (Object)newPropertySetterRegistry);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setPropertySetterRegistry(PropertySetterRegistry newPropertySetterRegistry) {
        if (newPropertySetterRegistry != this.propertySetterRegistry) {
            NotificationChain msgs = null;
            if (this.propertySetterRegistry != null) {
                msgs = ((InternalEObject)this.propertySetterRegistry).eInverseRemove((InternalEObject)this, 2, PropertySetterRegistry.class, msgs);
            }
            if (newPropertySetterRegistry != null) {
                msgs = ((InternalEObject)newPropertySetterRegistry).eInverseAdd((InternalEObject)this, 2, PropertySetterRegistry.class, msgs);
            }
            if ((msgs = this.basicSetPropertySetterRegistry(newPropertySetterRegistry, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)newPropertySetterRegistry, (Object)newPropertySetterRegistry));
        }
    }

    @Override
    public LayerOperatorDescriptorRegistry getLayerOperatorDescriptorRegistry() {
        return this.layerOperatorDescriptorRegistry;
    }

    public NotificationChain basicSetLayerOperatorDescriptorRegistry(LayerOperatorDescriptorRegistry newLayerOperatorDescriptorRegistry, NotificationChain msgs) {
        LayerOperatorDescriptorRegistry oldLayerOperatorDescriptorRegistry = this.layerOperatorDescriptorRegistry;
        this.layerOperatorDescriptorRegistry = newLayerOperatorDescriptorRegistry;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 6, (Object)oldLayerOperatorDescriptorRegistry, (Object)newLayerOperatorDescriptorRegistry);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setLayerOperatorDescriptorRegistry(LayerOperatorDescriptorRegistry newLayerOperatorDescriptorRegistry) {
        if (newLayerOperatorDescriptorRegistry != this.layerOperatorDescriptorRegistry) {
            NotificationChain msgs = null;
            if (this.layerOperatorDescriptorRegistry != null) {
                msgs = ((InternalEObject)this.layerOperatorDescriptorRegistry).eInverseRemove((InternalEObject)this, -7, null, msgs);
            }
            if (newLayerOperatorDescriptorRegistry != null) {
                msgs = ((InternalEObject)newLayerOperatorDescriptorRegistry).eInverseAdd((InternalEObject)this, -7, null, msgs);
            }
            if ((msgs = this.basicSetLayerOperatorDescriptorRegistry(newLayerOperatorDescriptorRegistry, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, (Object)newLayerOperatorDescriptorRegistry, (Object)newLayerOperatorDescriptorRegistry));
        }
    }

    @Override
    public void removeLayersStackFor(Diagram diagram) {
        try {
            LayersStack stack = this.lookupLayersStackFor(diagram);
            this.getLayersStacks().remove((Object)stack);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Override
    public boolean isLayersStackAttachedFor(Diagram diagram) {
        try {
            this.lookupLayersStackFor(diagram);
            return true;
        }
        catch (NotFoundException e) {
            return false;
        }
    }

    @Override
    public LayersStack lookupLayersStackFor(Diagram diagram) throws NotFoundException {
        for (LayersStack stack : this.getLayersStacks()) {
            if (stack.getDiagram() != diagram) continue;
            return stack;
        }
        throw new NotFoundException("No LayersStack attached for diagram: " + diagram);
    }

    @Override
    public LayersStack getLayersStackFor(Diagram diagram) {
        try {
            return this.lookupLayersStackFor(diagram);
        }
        catch (NotFoundException e) {
            return this.createLayersStackFor(diagram);
        }
    }

    @Override
    public LayersStack createLayersStackFor(Diagram diagram) {
        LayersStack layer = LayersFactory.eINSTANCE.createLayersStack();
        layer.startAfterCreation();
        layer.setDiagram(diagram);
        TopLayerOperator rootLayer = LayersFactory.eINSTANCE.createTopLayerOperator();
        rootLayer.setName("Top Layer");
        rootLayer.setApplication(this);
        layer.setLayers(rootLayer);
        this.getLayersStacks().add((Object)layer);
        return layer;
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 4: {
                if (this.factory != null) {
                    msgs = ((InternalEObject)this.factory).eInverseRemove((InternalEObject)this, -5, null, msgs);
                }
                return this.basicSetFactory((LayerApplicationFactory)otherEnd, msgs);
            }
            case 5: {
                if (this.propertySetterRegistry != null) {
                    msgs = ((InternalEObject)this.propertySetterRegistry).eInverseRemove((InternalEObject)this, -6, null, msgs);
                }
                return this.basicSetPropertySetterRegistry((PropertySetterRegistry)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return ((InternalEList)this.getLayersStacks()).basicRemove((Object)otherEnd, msgs);
            }
            case 1: {
                return this.basicSetLayerStackRegistry(null, msgs);
            }
            case 2: {
                return this.basicSetPropertyRegistry(null, msgs);
            }
            case 3: {
                return this.basicSetLayerDescriptorRegistry(null, msgs);
            }
            case 4: {
                return this.basicSetFactory(null, msgs);
            }
            case 5: {
                return this.basicSetPropertySetterRegistry(null, msgs);
            }
            case 6: {
                return this.basicSetLayerOperatorDescriptorRegistry(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getLayersStacks();
            }
            case 1: {
                return this.getLayerStackRegistry();
            }
            case 2: {
                return this.getPropertyRegistry();
            }
            case 3: {
                return this.getLayerDescriptorRegistry();
            }
            case 4: {
                return this.getFactory();
            }
            case 5: {
                return this.getPropertySetterRegistry();
            }
            case 6: {
                return this.getLayerOperatorDescriptorRegistry();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.getLayersStacks().clear();
                this.getLayersStacks().addAll((Collection)newValue);
                return;
            }
            case 1: {
                this.setLayerStackRegistry((LayerStackDescriptorRegistry)newValue);
                return;
            }
            case 2: {
                this.setPropertyRegistry((PropertyRegistry)newValue);
                return;
            }
            case 3: {
                this.setLayerDescriptorRegistry((LayerDescriptorRegistry)newValue);
                return;
            }
            case 4: {
                this.setFactory((LayerApplicationFactory)newValue);
                return;
            }
            case 5: {
                this.setPropertySetterRegistry((PropertySetterRegistry)newValue);
                return;
            }
            case 6: {
                this.setLayerOperatorDescriptorRegistry((LayerOperatorDescriptorRegistry)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.getLayersStacks().clear();
                return;
            }
            case 1: {
                this.setLayerStackRegistry(null);
                return;
            }
            case 2: {
                this.setPropertyRegistry(null);
                return;
            }
            case 3: {
                this.setLayerDescriptorRegistry(null);
                return;
            }
            case 4: {
                this.setFactory(null);
                return;
            }
            case 5: {
                this.setPropertySetterRegistry(null);
                return;
            }
            case 6: {
                this.setLayerOperatorDescriptorRegistry(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.layersStacks != null && !this.layersStacks.isEmpty();
            }
            case 1: {
                return this.layerStackRegistry != null;
            }
            case 2: {
                return this.propertyRegistry != null;
            }
            case 3: {
                return this.layerDescriptorRegistry != null;
            }
            case 4: {
                return this.factory != null;
            }
            case 5: {
                return this.propertySetterRegistry != null;
            }
            case 6: {
                return this.layerOperatorDescriptorRegistry != null;
            }
        }
        return super.eIsSet(featureID);
    }

    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 0: {
                return this.getLayersStackFor((Diagram)arguments.get(0));
            }
            case 1: {
                this.removeLayersStackFor((Diagram)arguments.get(0));
                return null;
            }
            case 2: {
                return this.isLayersStackAttachedFor((Diagram)arguments.get(0));
            }
            case 3: {
                return this.createLayersStackFor((Diagram)arguments.get(0));
            }
            case 4: {
                try {
                    return this.lookupLayersStackFor((Diagram)arguments.get(0));
                }
                catch (Throwable throwable) {
                    throw new InvocationTargetException(throwable);
                }
            }
        }
        return super.eInvoke(operationID, arguments);
    }
}

