/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.layers.stackmodel.layers.impl;

import org.eclipse.papyrus.layers.stackmodel.layers.LayerOperatorDescriptor;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersFactory;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersStackApplication;
import org.eclipse.papyrus.layers.stackmodel.layers.StackedLayerOperator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StackedLayerOperatorImplWithAplicationTest {
    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testResetDescriptor() {
        LayersStackApplication application = LayersFactory.eINSTANCE.createLayersStackApplication();
        LayerOperatorDescriptor layerDesc = LayersFactory.eINSTANCE.createLayerOperatorDescriptor();
        String layerDescName = "myLayerDesc";
        layerDesc.setName(layerDescName);
        application.getLayerOperatorDescriptorRegistry().addLayerOperatorDescriptor(layerDesc);
        StackedLayerOperator layer = LayersFactory.eINSTANCE.createStackedLayerOperator();
        Assert.assertFalse((String)"descriptor is not set", (boolean)layer.isDescriptorSet());
        layer.setLayerOperatorDescriptorName(layerDescName);
        layer.setApplication(application);
        Assert.assertTrue((String)"descriptor is set", (boolean)layer.isDescriptorSet());
        Assert.assertSame((String)"right descriptor is set", (Object)layerDesc, (Object)layer.getLayerOperatorDescriptor());
    }

    @Test
    public void testStackedLayerOperatorImpl() {
        StackedLayerOperator layer = LayersFactory.eINSTANCE.createStackedLayerOperator();
        Assert.assertNotNull((String)"layer is created", (Object)layer);
        Assert.assertFalse((String)"descriptor is not set", (boolean)layer.isDescriptorSet());
    }
}

