/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.layers.stackmodel.layers.loaders;

import org.eclipse.papyrus.layers.configmodel.layersconfig.Folder;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersPackage;
import org.eclipse.papyrus.layers.stackmodel.layers.loaders.LayersConfigModel;
import org.eclipse.papyrus.layers.stackmodel.layers.loaders.LayersConfigModelUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LayersConfigModelTest {
    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testLayersConfigModel() {
        LayersConfigModel model = new LayersConfigModel();
        Assert.assertNotNull((String)"object created", (Object)model);
        Assert.assertNotNull((String)"resource created", (Object)model.getResource());
        Assert.assertNotNull((String)"root folder created", (Object)model.getRootFolder());
    }

    @Test
    public void testExternalInitialization() {
        LayersConfigModel model = new LayersConfigModel();
        this.initLayersConfigModel(model);
        Assert.assertTrue((String)"Some def are set in root", (model.getRootFolder().getFolderElements().size() > 0 ? 1 : 0) != 0);
    }

    private void initLayersConfigModel(LayersConfigModel model) {
        Folder layeropFolder = LayersConfigModelUtils.createFolder(model.getRootFolder(), "layerOpDesc");
        LayersConfigModelUtils.createLayerOperatorConfig(layeropFolder, "StackedLayersOperatorA", LayersPackage.eINSTANCE.getStackedLayerOperatorDescriptor().getName());
        LayersConfigModelUtils.createLayerOperatorConfig(layeropFolder, "StackedLayersOperatorB", LayersPackage.eINSTANCE.getStackedLayerOperatorDescriptor().getName());
        LayersConfigModelUtils.createLayerOperatorConfig(layeropFolder, "StackedLayersOperatorC", LayersPackage.eINSTANCE.getStackedLayerOperatorDescriptor().getName());
        LayersConfigModelUtils.createLayerOperatorConfig(layeropFolder, "StackedLayersOperatorD", LayersPackage.eINSTANCE.getStackedLayerOperatorDescriptor().getName());
    }

    @Test
    public void testInternalInitialization() {
        LayersConfigModel model = LayersConfigModel.getInstance();
        Assert.assertNotNull((String)"object created", (Object)model);
        Assert.assertTrue((String)"Some def are set in root", (model.getRootFolder().getFolderElements().size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetResource() {
        LayersConfigModel model = new LayersConfigModel();
        Assert.assertNotNull((String)"resource created", (Object)model.getResource());
        Assert.assertTrue((String)"resource populated", (model.getResource().getContents().size() > 0 ? 1 : 0) != 0);
    }
}

