/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.layers.stackmodel.notifier;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.layers.stackmodel.notifier.IDiagramViewEventListener;

public class DiagramViewChangedEventNotifier
extends EContentAdapter {
    boolean isDisposed = false;
    protected List<IDiagramViewEventListener> listeners = new ArrayList<IDiagramViewEventListener>();

    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        Object newValue = notification.getNewValue();
        if (!(newValue instanceof View) && !(notification.getOldValue() instanceof View)) {
            return;
        }
        Object feature = notification.getFeature();
        if (feature == NotationPackage.eINSTANCE.getView_PersistedChildren() || feature == NotationPackage.eINSTANCE.getView_TransientChildren() || feature == NotationPackage.eINSTANCE.getDiagram_PersistedEdges() || feature == NotationPackage.eINSTANCE.getDiagram_TransientEdges()) {
            switch (notification.getEventType()) {
                case 1: {
                    break;
                }
                case 3: {
                    this.fireDiagramViewAddedEvent(notification);
                    break;
                }
                case 4: {
                    this.fireDiagramViewRemovedEvent(notification);
                }
            }
        }
    }

    public boolean isAdapterForType(Object type) {
        return type == DiagramViewChangedEventNotifier.class;
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        this.isDisposed = true;
        this.listeners.clear();
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }

    public void addEventListener(IDiagramViewEventListener listener) {
        if (listener == null) {
            return;
        }
        if (this.listeners.contains(listener)) {
            return;
        }
        this.listeners.add(listener);
    }

    public void removeEventListener(IDiagramViewEventListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireDiagramViewAddedEvent(Notification msg) {
        for (IDiagramViewEventListener listener : this.listeners) {
            listener.diagramViewAdded(msg);
        }
    }

    protected void fireDiagramViewRemovedEvent(Notification msg) {
        for (IDiagramViewEventListener listener : this.listeners) {
            listener.diagramViewRemoved(msg);
        }
    }

    public static View viewAddedEvent_getAddedView(Notification msg) {
        return (View)msg.getNewValue();
    }

    public static View viewAddedEvent_getRemovedView(Notification msg) {
        return (View)msg.getOldValue();
    }
}

