/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.layers.stackmodel.notifier;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.layers.stackmodel.notifier.DiagramViewChangedEventNotifier;
import org.eclipse.papyrus.layers.stackmodel.notifier.DiagramViewChangedEventNotifierFactory;
import org.eclipse.papyrus.layers.stackmodel.notifier.TraceDiagramViewChangedEventListener;
import org.eclipse.papyrus.layers.stackmodel.util.NotationAndUmlModelsFactory;
import org.eclipse.papyrus.layers.stackmodel.util.TriggeredEventTraces;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.NamedElement;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class DiagramViewChangedEventNotifierTest {
    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testDiagramViewChangedEventNotifier() {
        NotationAndUmlModelsFactory factory = new NotationAndUmlModelsFactory();
        Diagram diagram1 = factory.newDiagram();
        DiagramViewChangedEventNotifier notifier = new DiagramViewChangedEventNotifier();
        Class c1 = factory.newClass(diagram1, "C1");
    }

    @Test
    @Ignore
    public void testAddEventListener() {
        Assert.fail((String)"Not yet implemented");
    }

    @Test
    @Ignore
    public void testRemoveEventListener() {
        Assert.fail((String)"Not yet implemented");
    }

    @Test
    public void testFireDiagramViewAddedEvent() {
        DiagramViewChangedEventNotifierFactory notifierFactory = new DiagramViewChangedEventNotifierFactory();
        NotationAndUmlModelsFactory modelsFactory = new NotationAndUmlModelsFactory();
        Diagram diagram1 = modelsFactory.newDiagram();
        Class c1 = modelsFactory.newClass(diagram1, "C1");
        DiagramViewChangedEventNotifier eventNotifier = (DiagramViewChangedEventNotifier)notifierFactory.adapt((Notifier)diagram1, DiagramViewChangedEventNotifier.class);
        TraceDiagramViewChangedEventListener listener = new TraceDiagramViewChangedEventListener();
        eventNotifier.addEventListener(listener);
        TriggeredEventTraces<Notification> traces = listener.traces;
        traces.clear();
        Class c2 = modelsFactory.newClass(diagram1, "C2");
        Shape shape2 = (Shape)modelsFactory.lookupViewFor(diagram1, (NamedElement)c2);
        Assert.assertTrue((String)"event recorded", (boolean)traces.contains("diagramViewAdded"));
        Assert.assertEquals((String)"one event recorded", (long)1L, (long)traces.traces.size());
        TriggeredEventTraces.TriggeredEvent event = traces.traces.get(0);
        Assert.assertEquals((String)"right element in event", (Object)shape2, (Object)((Notification)event.notifier).getNewValue());
    }

    @Test
    public void testFireDiagramViewRemovedEvent() {
        DiagramViewChangedEventNotifierFactory notifierFactory = new DiagramViewChangedEventNotifierFactory();
        NotationAndUmlModelsFactory modelsFactory = new NotationAndUmlModelsFactory();
        Diagram diagram1 = modelsFactory.newDiagram();
        Class c1 = modelsFactory.newClass(diagram1, "C1");
        Shape shape1 = (Shape)modelsFactory.lookupViewFor(diagram1, (NamedElement)c1);
        Class c2 = modelsFactory.newClass(diagram1, "C2");
        Shape shape2 = (Shape)modelsFactory.lookupViewFor(diagram1, (NamedElement)c2);
        DiagramViewChangedEventNotifier eventNotifier = (DiagramViewChangedEventNotifier)notifierFactory.adapt((Notifier)diagram1, DiagramViewChangedEventNotifier.class);
        TraceDiagramViewChangedEventListener listener = new TraceDiagramViewChangedEventListener();
        eventNotifier.addEventListener(listener);
        TriggeredEventTraces<Notification> traces = listener.traces;
        traces.clear();
        View removedShape = modelsFactory.remove(diagram1, (NamedElement)c2);
        Assert.assertTrue((String)"event recorded", (boolean)traces.contains("diagramViewRemoved"));
        Assert.assertEquals((String)"one event recorded", (long)1L, (long)traces.traces.size());
        TriggeredEventTraces.TriggeredEvent event = traces.traces.get(0);
        Assert.assertEquals((String)"right element in event", (Object)shape2, (Object)((Notification)event.notifier).getOldValue());
    }
}

