/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.MARTE.MARTE_DesignModel.HRM.HwPhysical.HwLayout;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ComponentKind implements Enumerator
{
    CARD(0, "card", "card"),
    CHANNEL(1, "channel", "channel"),
    CHIP(2, "chip", "chip"),
    PORT(3, "port", "port"),
    UNIT(4, "unit", "unit"),
    OTHER(5, "other", "other"),
    UNDEF(6, "undef", "undef");

    public static final int CARD_VALUE = 0;
    public static final int CHANNEL_VALUE = 1;
    public static final int CHIP_VALUE = 2;
    public static final int PORT_VALUE = 3;
    public static final int UNIT_VALUE = 4;
    public static final int OTHER_VALUE = 5;
    public static final int UNDEF_VALUE = 6;
    private static final ComponentKind[] VALUES_ARRAY;
    public static final List<ComponentKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ComponentKind[]{CARD, CHANNEL, CHIP, PORT, UNIT, OTHER, UNDEF};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ComponentKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ComponentKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ComponentKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ComponentKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ComponentKind get(int value) {
        switch (value) {
            case 0: {
                return CARD;
            }
            case 1: {
                return CHANNEL;
            }
            case 2: {
                return CHIP;
            }
            case 3: {
                return PORT;
            }
            case 4: {
                return UNIT;
            }
            case 5: {
                return OTHER;
            }
            case 6: {
                return UNDEF;
            }
        }
        return null;
    }

    private ComponentKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

