/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.migration.rsa.transformation;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.ecore.xmi.impl.URIHandlerImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.gmf.runtime.emf.core.resources.GMFResource;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Style;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.m2m.qvt.oml.BasicModelExtent;
import org.eclipse.m2m.qvt.oml.ExecutionContext;
import org.eclipse.m2m.qvt.oml.ExecutionContextImpl;
import org.eclipse.m2m.qvt.oml.ExecutionDiagnostic;
import org.eclipse.m2m.qvt.oml.ModelExtent;
import org.eclipse.m2m.qvt.oml.TransformationExecutor;
import org.eclipse.m2m.qvt.oml.util.Log;
import org.eclipse.m2m.qvt.oml.util.WriterLog;
import org.eclipse.papyrus.dsml.validation.PapyrusDSMLValidationRule.PapyrusDSMLValidationRulePackage;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.tools.util.ListHelper;
import org.eclipse.papyrus.migration.rsa.Activator;
import org.eclipse.papyrus.migration.rsa.RSAToPapyrusParameters.Config;
import org.eclipse.papyrus.migration.rsa.RSAToPapyrusParameters.RSAToPapyrusParametersFactory;
import org.eclipse.papyrus.migration.rsa.concurrent.ExecutorsPool;
import org.eclipse.papyrus.migration.rsa.concurrent.ResourceAccessHelper;
import org.eclipse.papyrus.migration.rsa.default_.DefaultPackage;
import org.eclipse.papyrus.migration.rsa.profilebase.ProfileBasePackage;
import org.eclipse.papyrus.migration.rsa.transformation.DependencyAnalysisHelper;
import org.eclipse.papyrus.migration.rsa.transformation.MigrationResourceSet;
import org.eclipse.papyrus.migration.rsa.transformation.MigrationResourceSetImpl;
import org.eclipse.papyrus.uml.documentation.Documentation.DocumentationPackage;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.UMLRealTimePackage;
import org.eclipse.papyrusrt.umlrt.profile.statemachine.UMLRealTimeStateMach.UMLRealTimeStateMachPackage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.uml2.common.util.CacheAdapter;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.util.UMLUtil;

public class ImportTransformation {
    private static final boolean DEBUG = false;
    protected final URI sourceURI;
    protected URI targetURI;
    protected ModelExtent outUML;
    protected ModelExtent outNotation;
    protected ModelExtent outSashModel;
    protected ModelExtent inParameters;
    protected ModelExtent inPapyrusProfiles;
    protected MigrationResourceSet resourceSet;
    protected Job job;
    protected Resource umlResource;
    protected Config parameters;
    protected boolean complete = false;
    protected long executionTime = 0L;
    protected long loadingTime = 0L;
    protected long danglingRefTime = 0L;
    protected long importRTTime = 0L;
    protected final Map<URI, URI> uriMappings = new HashMap<URI, URI>();
    protected final Map<URI, URI> profileURIMappings = new HashMap<URI, URI>();
    protected List<Diagram> diagramsToDelete = new LinkedList<Diagram>();
    protected static final ExecutorsPool executorsPool = new ExecutorsPool(2);
    protected static final Set<EPackage> sourceEPackages = new HashSet<EPackage>();
    protected final DependencyAnalysisHelper analysisHelper;
    protected static final Set<String> supportedDiagramIds;

    static {
        sourceEPackages.add(DefaultPackage.eINSTANCE);
        sourceEPackages.add(ProfileBasePackage.eINSTANCE);
        sourceEPackages.add(org.eclipse.papyrus.migration.rsa.umlrt.UMLRealTimePackage.eINSTANCE);
        supportedDiagramIds = new HashSet<String>();
        supportedDiagramIds.addAll(Arrays.asList("Class", "Object", "Activity", "Statechart", "Structure"));
    }

    public ImportTransformation(URI sourceURI) {
        this(sourceURI, RSAToPapyrusParametersFactory.eINSTANCE.createConfig(), null);
    }

    public ImportTransformation(URI sourceURI, Config config, DependencyAnalysisHelper analysisHelper) {
        Assert.isNotNull((Object)sourceURI);
        this.sourceURI = sourceURI;
        this.parameters = config;
        this.analysisHelper = analysisHelper;
    }

    public void run() {
        this.run(true);
    }

    public void run(final boolean isUserJob) {
        this.job = new Job("Import " + this.getModelName()){

            protected IStatus run(IProgressMonitor monitor) {
                long begin = System.nanoTime();
                IStatus result = ImportTransformation.this.run(monitor);
                long end = System.nanoTime();
                ImportTransformation.this.executionTime = end - begin;
                return result;
            }
        };
        this.job.setUser(isUserJob);
        this.job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                ImportTransformation.this.complete = true;
                if (isUserJob) {
                    if (event.getResult().getSeverity() == 0) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)(this).ImportTransformation.this.job.getName(), (String)String.format("Model %s has been successfully imported", ImportTransformation.this.getModelName()));
                            }
                        });
                    } else if (event.getResult().getSeverity() == 8) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)(this).ImportTransformation.this.job.getName(), (String)String.format("Operation canceled: %s", ImportTransformation.this.getModelName()));
                            }
                        });
                    } else {
                        StatusManager.getManager().handle(event.getResult(), 4);
                    }
                }
            }
        });
        this.job.schedule();
    }

    public void waitForCompletion() {
        try {
            this.job.join();
        }
        catch (InterruptedException ex) {
            Activator.log.error((Throwable)ex);
        }
    }

    public boolean isComplete() {
        return this.complete;
    }

    public IStatus getStatus() {
        if (this.job == null) {
            return new Status(8, "org.eclipse.papyrus.migration.rsa", "Operation canceled");
        }
        return this.job.getResult();
    }

    public long getExecutionTime() {
        return this.executionTime;
    }

    public long getLoadingTime() {
        return this.loadingTime;
    }

    public long getHandleDanglingRefTime() {
        return this.danglingRefTime;
    }

    public long getImportRTTime() {
        return this.importRTTime;
    }

    public Map<URI, URI> getURIMappings() {
        return this.uriMappings;
    }

    public Map<URI, URI> getProfileURIMappings() {
        return this.profileURIMappings;
    }

    public URI getTargetURI() {
        return this.targetURI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initResourceSet(IProgressMonitor monitor) {
        this.resourceSet = new MigrationResourceSetImpl();
        Class<UMLUtil> clazz = UMLUtil.class;
        synchronized (UMLUtil.class) {
            UMLUtil.init((ResourceSet)this.resourceSet);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.resourceSet.getLoadOptions().put("DEFER_ATTACHMENT", true);
            this.resourceSet.getLoadOptions().put("DEFER_IDREF_RESOLUTION", true);
            this.resourceSet.getLoadOptions().put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
            this.resourceSet.getLoadOptions().put("USE_PACKAGE_NS_URI_AS_LOCATION", Boolean.FALSE);
            monitor.subTask("Loading source model " + this.getModelName());
            try {
                this.resourceSet.getResource(this.sourceURI, true);
                this.loadInPapyrusProfiles();
            }
            catch (Exception ex) {
                Activator.log.error("An error occurred while loading " + this.getModelName(), (Throwable)ex);
            }
            return;
        }
    }

    protected int countSupportedElements() {
        int i = 0;
        ModelExtent extent = this.getInOutUMLModel();
        for (EObject eObject : extent.getContents()) {
            TreeIterator modelIterator = EcoreUtil.getAllContents((EObject)eObject, (boolean)true);
            while (modelIterator.hasNext()) {
                OpaqueExpression exp;
                EObject next = (EObject)modelIterator.next();
                if (next instanceof Diagram) {
                    Diagram diagram = (Diagram)next;
                    if (ImportTransformation.isSupported(diagram)) {
                        ++i;
                        this.diagramsToDelete.add(diagram);
                    }
                    modelIterator.prune();
                    continue;
                }
                if (!(next instanceof OpaqueExpression) || !this.parameters.isConvertOpaqueExpressionToLiteralString() || !ImportTransformation.needsConversion(exp = (OpaqueExpression)next)) continue;
                ++i;
            }
        }
        return i += this.getAllTransformationURIs().size();
    }

    protected static boolean needsConversion(OpaqueExpression exp) {
        EList languages = exp.getLanguages();
        EList bodies = exp.getBodies();
        if (bodies.size() > 1) {
            return false;
        }
        return languages.isEmpty() || languages.size() == 1 && ((String)exp.getLanguages().get(0)).isEmpty();
    }

    protected static boolean isSupported(Diagram diagram) {
        return supportedDiagramIds.contains(diagram.getType());
    }

    protected IStatus loadTransformations(IProgressMonitor monitor) {
        for (URI transformationURI : this.getAllTransformationURIs()) {
            executorsPool.preLoad(transformationURI);
            monitor.worked(1);
        }
        return Status.OK_STATUS;
    }

    protected static IStatus createStatusFromDiagnostic(Diagnostic diagnostic) {
        return new Status(diagnostic.getSeverity(), diagnostic.getSource(), diagnostic.getMessage(), diagnostic.getException());
    }

    protected IStatus run(IProgressMonitor monitor) {
        monitor.subTask("Loading source model " + this.getModelName());
        long startLoad = System.nanoTime();
        this.initResourceSet(monitor);
        int numberOfElements = this.countSupportedElements();
        monitor.beginTask("Importing " + this.getModelName(), numberOfElements);
        monitor.subTask("Loading transformations (This may take a few seconds for the first import)...");
        this.loadTransformations(monitor);
        List<ModelExtent> extents = this.getModelExtents();
        String statusMessage = String.format("Import %s", this.getModelName());
        MultiStatus generationStatus = new MultiStatus("org.eclipse.papyrus.migration.rsa", 0, statusMessage, null);
        ExecutionContext context = this.createExecutionContext(monitor, generationStatus);
        this.getInPapyrusProfiles();
        long endLoad = System.nanoTime();
        this.loadingTime = endLoad - startLoad;
        long startRT = System.nanoTime();
        IStatus result = this.importRTProfile(context, monitor);
        long endRT = System.nanoTime();
        this.importRTTime = endRT - startRT;
        generationStatus.add(result);
        Collection<URI> transformations = this.getDiagramTransformationURIs();
        monitor.subTask("Importing diagrams...");
        for (URI transformationURI : transformations) {
            result = this.runTransformation(transformationURI, context, monitor, extents);
            generationStatus.add(result);
        }
        monitor.subTask("Importing semantic model...");
        result = this.runTransformation(this.getSemanticTransformationURI(), context, monitor, extents);
        generationStatus.add(result);
        if (!monitor.isCanceled()) {
            monitor.subTask("Handle additional profiles...");
            result = this.importRSAProfiles(context, monitor);
            generationStatus.add(result);
        }
        if (generationStatus.getSeverity() <= 2) {
            monitor.subTask("Cleaning-up target model...");
            URI notationModelURI = null;
            URI sashModelURI = null;
            this.targetURI = this.convertToPapyrus(this.sourceURI, "uml");
            notationModelURI = this.convertToPapyrus(this.sourceURI, "notation");
            sashModelURI = this.convertToPapyrus(this.sourceURI, "di");
            if ("epx".equals(this.sourceURI.fileExtension())) {
                this.profileURIMappings.put(this.sourceURI, this.targetURI);
            }
            this.uriMappings.put(this.sourceURI, this.targetURI);
            this.umlResource = this.createUMLResource(this.resourceSet, this.sourceURI, this.targetURI);
            List outUMLObjects = this.getInOutUMLModel().getContents();
            this.umlResource.getContents().addAll((Collection)outUMLObjects);
            GMFResource notationResource = new GMFResource(notationModelURI);
            this.resourceSet.getResources().add((Object)notationResource);
            List outNotationObjects = this.getInoutNotationModel().getContents();
            notationResource.getContents().addAll((Collection)outNotationObjects);
            LinkedList contentsCopy = new LinkedList(notationResource.getContents());
            for (EObject next : contentsCopy) {
                Diagram diagram;
                if (!(next instanceof Diagram) || (diagram = (Diagram)next).getType() != null && !"".equals(diagram.getType())) continue;
                this.delete((EObject)diagram);
            }
            XMIResourceImpl sashResource = new XMIResourceImpl(sashModelURI);
            this.resourceSet.getResources().add((Object)sashResource);
            List sashModelObjects = this.getOutSashModel().getContents();
            sashResource.getContents().addAll((Collection)sashModelObjects);
            this.configureResource((XMIResource)sashResource);
            this.configureResource((XMIResource)notationResource);
            this.configureResource((XMIResource)this.umlResource);
            LinkedList notationRootElements = new LinkedList(notationResource.getContents());
            for (EObject rootElement : notationRootElements) {
                if (rootElement instanceof View) {
                    View rootView = (View)rootElement;
                    if (rootView instanceof Diagram) continue;
                    this.delete(rootElement);
                    continue;
                }
                if (!(rootElement instanceof Style)) continue;
                this.delete(rootElement);
            }
            monitor.subTask("Handling fragments...");
            Collection<Resource> resourcesToSave = this.handleFragments(this.umlResource, (Resource)notationResource, (Resource)sashResource);
            for (Resource resource : resourcesToSave) {
                LinkedList rootElements = new LinkedList(resource.getContents());
                for (EObject rootElement : rootElements) {
                    EPackage ePackage = rootElement.eClass().getEPackage();
                    if (ePackage != ProfileBasePackage.eINSTANCE && ePackage != DefaultPackage.eINSTANCE) continue;
                    this.delete(rootElement);
                }
            }
            monitor.subTask("Deleting source diagrams...");
            for (Diagram diagram : this.diagramsToDelete) {
                EAnnotation annotation;
                EObject container = diagram.eContainer();
                this.delete((EObject)diagram);
                if (!(container instanceof EAnnotation) || !(annotation = (EAnnotation)container).getContents().isEmpty()) continue;
                this.delete((EObject)annotation);
            }
            this.diagramsToDelete.clear();
            monitor.subTask("Analyzing dangling references...");
            long startDangling = System.nanoTime();
            this.handleDanglingURIs(resourcesToSave);
            long endDangling = System.nanoTime();
            this.danglingRefTime = endDangling - startDangling;
            monitor.subTask("Saving models...");
            for (Resource resource : resourcesToSave) {
                try {
                    this.cleanMetadataAnnotations(resource);
                    ResourceAccessHelper.INSTANCE.saveResource(resource, null);
                }
                catch (Exception ex) {
                    Activator.log.error((Throwable)ex);
                    generationStatus.add((IStatus)new Status(4, "org.eclipse.papyrus.migration.rsa", "An exception occurred during save", (Throwable)ex));
                }
            }
        }
        monitor.subTask("Releasing memory...");
        this.unloadResourceSet(this.resourceSet);
        this.resourceSet = null;
        this.umlResource = null;
        this.outUML = null;
        this.outSashModel = null;
        this.inParameters = null;
        this.outNotation = null;
        monitor.done();
        return generationStatus;
    }

    private void cleanMetadataAnnotations(Resource resource) {
        Iterator rootElementsIterator = resource.getContents().iterator();
        while (rootElementsIterator.hasNext()) {
            EAnnotation annotation;
            EObject root = (EObject)rootElementsIterator.next();
            if (!(root instanceof EAnnotation) || !"http:///org/eclipse/emf/ecore/util/ExtendedMetaData".equals((annotation = (EAnnotation)root).getSource())) continue;
            rootElementsIterator.remove();
        }
    }

    protected void handleDanglingURIs(Collection<Resource> resourcesToSave) {
        if (this.analysisHelper != null) {
            this.resourceSet.freeze();
            try {
                this.analysisHelper.computeURIMappings(resourcesToSave);
            }
            finally {
                this.resourceSet.unfreeze();
            }
        }
    }

    protected void unloadResourceSet(ResourceSet resourceSet) {
        EMFHelper.unload((ResourceSet)resourceSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus importRSAProfiles(ExecutionContext context, IProgressMonitor monitor) {
        ExecutionDiagnostic transformationResult;
        TransformationExecutor executor;
        URI transformationURI = this.getProfilesTransformationURI();
        LinkedList<ModelExtent> extents = new LinkedList<ModelExtent>();
        extents.add(this.getInOutUMLModel());
        extents.add(this.getInoutNotationModel());
        Diagnostic loadedProfiles = this.loadInPapyrusProfiles();
        extents.add(this.getInPapyrusProfiles());
        extents.add(this.getInProfileDefinitions());
        extents.add(this.getInConfig());
        try {
            executor = this.getTransformation(transformationURI, monitor);
        }
        catch (DiagnosticException ex) {
            Diagnostic diagnostic = ex.getDiagnostic();
            Activator.log.warn(String.format("Cannot load the transformation : %s. Diagnostic: %s", transformationURI, diagnostic.getMessage()));
            return ImportTransformation.createStatusFromDiagnostic(diagnostic);
        }
        TransformationExecutor diagnostic = executor;
        synchronized (diagnostic) {
            try {
                transformationResult = executor.execute(context, extents.toArray(new ModelExtent[0]));
            }
            finally {
                executor.cleanup();
                executorsPool.releaseExecutor(executor);
            }
        }
        IStatus loadedProfilesStatus = ImportTransformation.createStatusFromDiagnostic(loadedProfiles);
        IStatus transformationStatus = ImportTransformation.createStatusFromDiagnostic((Diagnostic)transformationResult);
        int severity = Math.max(loadedProfiles.getSeverity(), transformationResult.getSeverity());
        String message = severity > 0 ? "The following errors occurred:" : "OK";
        MultiStatus completeResult = new MultiStatus("org.eclipse.papyrus.migration.rsa", severity, new IStatus[]{loadedProfilesStatus, transformationStatus}, message, null);
        return completeResult;
    }

    protected TransformationExecutor getTransformation(URI transformationURI, IProgressMonitor monitor) throws DiagnosticException {
        return executorsPool.getExecutor(transformationURI);
    }

    protected static synchronized TransformationExecutor loadTransformationExecutor(URI transformationURI, IProgressMonitor monitor) throws DiagnosticException {
        TransformationExecutor executor = new TransformationExecutor(transformationURI);
        Diagnostic diagnostic = executor.loadTransformation(monitor);
        if (diagnostic.getSeverity() != 0) {
            throw new DiagnosticException(diagnostic);
        }
        return executor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Properties readProfileBaseProperties() {
        URI propertiesURI = this.sourceURI.trimFileExtension().appendFileExtension("properties");
        Properties properties = new Properties();
        InputStream inputStream = null;
        try {
            try {
                URL url = new URL(propertiesURI.toString());
                inputStream = url.openStream();
                properties.load(inputStream);
                return properties;
            }
            catch (FileNotFoundException url) {
                if (inputStream == null) return properties;
                try {
                    inputStream.close();
                    return properties;
                }
                catch (IOException ex) {
                    Activator.log.error((Throwable)ex);
                }
                return properties;
            }
            catch (IOException ex) {
                Activator.log.error((Throwable)ex);
                if (inputStream == null) return properties;
                try {
                    inputStream.close();
                    return properties;
                }
                catch (IOException ex2) {
                    Activator.log.error((Throwable)ex2);
                }
                return properties;
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException ex) {
                    Activator.log.error((Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus importRTProfile(ExecutionContext context, IProgressMonitor monitor) {
        ExecutionDiagnostic result;
        TransformationExecutor executor;
        monitor.subTask("Importing RT Profile... ");
        URI transformationURI = this.getRTTransformationURI();
        LinkedList<ModelExtent> extents = new LinkedList<ModelExtent>();
        extents.add(this.getInOutUMLModel());
        extents.add(this.getInoutNotationModel());
        extents.add(this.getInPapyrusProfiles());
        extents.add(this.getInProfileDefinitions());
        extents.add(this.getInConfig());
        try {
            executor = this.getTransformation(transformationURI, monitor);
        }
        catch (DiagnosticException ex) {
            Diagnostic diagnostic = ex.getDiagnostic();
            Activator.log.warn(String.format("Cannot load the transformation : %s. Diagnostic: %s", transformationURI, diagnostic.getMessage()));
            return ImportTransformation.createStatusFromDiagnostic(diagnostic);
        }
        TransformationExecutor transformationExecutor = executor;
        synchronized (transformationExecutor) {
            try {
                result = executor.execute(context, extents.toArray(new ModelExtent[0]));
            }
            finally {
                executor.cleanup();
                executorsPool.releaseExecutor(executor);
            }
        }
        return ImportTransformation.createStatusFromDiagnostic((Diagnostic)result);
    }

    protected ModelExtent getInProfileDefinitions() {
        return new BasicModelExtent(Arrays.asList(PapyrusDSMLValidationRulePackage.eINSTANCE, DocumentationPackage.eINSTANCE, UMLRealTimePackage.eINSTANCE, UMLRealTimeStateMachPackage.eINSTANCE));
    }

    protected ModelExtent getInPapyrusProfiles() {
        if (this.inPapyrusProfiles == null) {
            this.loadInPapyrusProfiles();
        }
        return this.inPapyrusProfiles;
    }

    protected Diagnostic loadInPapyrusProfiles() {
        int code;
        String message;
        if (this.inPapyrusProfiles != null) {
            return Diagnostic.OK_INSTANCE;
        }
        LinkedList<String> missingProfiles = new LinkedList<String>();
        LinkedList allContents = new LinkedList();
        try {
            URI validationProfileURI = URI.createURI((String)"pathmap://DSMLValidation_PROFILES/PapyrusValidationRuleDSML.uml");
            Resource validationProfile = this.resourceSet.getResource(validationProfileURI, true);
            this.checkResource(validationProfile);
            allContents.addAll(validationProfile.getContents());
        }
        catch (WrappedException ex) {
            missingProfiles.add("Validation Rules Profile");
        }
        try {
            URI documentationProfileURI = URI.createURI((String)"pathmap://PAPYRUS_DOCUMENTATION/Papyrus.profile.uml");
            Resource documentationProfile = this.resourceSet.getResource(documentationProfileURI, true);
            this.checkResource(documentationProfile);
            allContents.addAll(documentationProfile.getContents());
        }
        catch (WrappedException ex) {
            missingProfiles.add("Documentation Profile");
        }
        try {
            URI umlrtProfileURI = URI.createURI((String)"pathmap://UML_RT_PROFILE/uml-rt.profile.uml");
            Resource umlrtProfile = this.resourceSet.getResource(umlrtProfileURI, true);
            this.checkResource(umlrtProfile);
            allContents.addAll(umlrtProfile.getContents());
        }
        catch (WrappedException ex) {
            missingProfiles.add("UML RT Profile");
        }
        try {
            URI umlrtSMProfileURI = URI.createURI((String)"pathmap://UML_RT_PROFILE/UMLRealTimeSM-addendum.profile.uml");
            Resource umlrtSMProfile = this.resourceSet.getResource(umlrtSMProfileURI, true);
            this.checkResource(umlrtSMProfile);
            allContents.addAll(umlrtSMProfile.getContents());
        }
        catch (WrappedException ex) {
            missingProfiles.add("UML RT / StateMachine extension Profile");
        }
        this.inPapyrusProfiles = new BasicModelExtent(allContents);
        if (missingProfiles.isEmpty()) {
            message = "OK";
            code = 0;
        } else {
            message = "The following Papyrus profiles cannot be found: " + ListHelper.deepToString(missingProfiles, (String)", ");
            code = 4;
        }
        BasicDiagnostic diagnostic = new BasicDiagnostic(code, "org.eclipse.papyrus.migration.rsa", code, message, null);
        return diagnostic;
    }

    protected void checkResource(Resource resource) {
        Assert.isNotNull((Object)resource);
        Assert.isTrue((!resource.getContents().isEmpty() ? 1 : 0) != 0, (String)("The resource " + resource.getURI() + " is empty"));
        for (EObject rootElement : resource.getContents()) {
            Assert.isTrue((!rootElement.eIsProxy() ? 1 : 0) != 0);
        }
    }

    protected Resource createUMLResource(ResourceSet resourceSet, URI sourceResourceURI, URI targetResourceURI) {
        Resource resource = resourceSet.getResource(sourceResourceURI, false);
        resource.setURI(targetResourceURI);
        return resource;
    }

    protected ModelExtent getInConfig() {
        if (this.inParameters == null) {
            this.inParameters = new BasicModelExtent(Collections.singletonList(this.parameters));
        }
        return this.inParameters;
    }

    protected Collection<Resource> handleFragments(Resource umlResource, Resource notationResource, Resource sashResource) {
        HashSet<Resource> result = new HashSet<Resource>();
        result.add(umlResource);
        result.add(notationResource);
        result.add(sashResource);
        ResourceSet resourceSet = umlResource.getResourceSet();
        TreeIterator elementIterator = umlResource.getAllContents();
        HashSet<Resource> fragmentResources = new HashSet<Resource>();
        while (elementIterator.hasNext()) {
            EObject element = (EObject)elementIterator.next();
            if (element.eResource() == umlResource || !element.eResource().getContents().contains((Object)element)) continue;
            fragmentResources.add(element.eResource());
        }
        LinkedList<Resource> fragmentUMLResources = new LinkedList<Resource>();
        for (Resource fragmentResource : fragmentResources) {
            URI papyrusFragmentURI = this.convertToPapyrus(fragmentResource.getURI(), "uml");
            this.uriMappings.put(fragmentResource.getURI(), papyrusFragmentURI);
            Resource newResource = resourceSet.getResource(papyrusFragmentURI, false);
            if (newResource == null) {
                newResource = this.createUMLResource(resourceSet, fragmentResource.getURI(), papyrusFragmentURI);
                fragmentUMLResources.add(newResource);
                GMFResource fragmentNotationResource = new GMFResource(this.convertToPapyrus(papyrusFragmentURI, "notation"));
                XMIResourceImpl fragmentDiResource = new XMIResourceImpl(this.convertToPapyrus(papyrusFragmentURI, "di"));
                result.add((Resource)fragmentNotationResource);
                result.add((Resource)fragmentDiResource);
                resourceSet.getResources().add((Object)fragmentNotationResource);
                resourceSet.getResources().add((Object)fragmentDiResource);
            }
            newResource.getContents().addAll((Collection)fragmentResource.getContents());
            result.add(newResource);
        }
        this.deleteSourceStereotypes(fragmentResources);
        LinkedList importedElements = new LinkedList(notationResource.getContents());
        for (EObject notationElement : importedElements) {
            EObject semanticElement;
            if (!(notationElement instanceof Diagram) || (semanticElement = ((Diagram)notationElement).getElement()).eResource() == umlResource || semanticElement.eResource() == null) continue;
            URI notationFragmentURI = this.convertToPapyrus(semanticElement.eResource().getURI(), "notation");
            Resource newNotationResource = resourceSet.getResource(notationFragmentURI, false);
            if (newNotationResource == null) {
                newNotationResource = new GMFResource(notationFragmentURI);
                resourceSet.getResources().add((Object)newNotationResource);
            }
            newNotationResource.getContents().add((Object)notationElement);
            result.add(newNotationResource);
        }
        this.handleFragmentStereotypes(umlResource, fragmentUMLResources);
        for (Resource resource : result) {
            if (!(resource instanceof XMIResource)) continue;
            this.configureResource((XMIResource)resource);
        }
        return result;
    }

    protected void handleFragmentStereotypes(Resource mainUMLResource, List<Resource> umlResources) {
        Iterator rootElementIterator = mainUMLResource.getContents().iterator();
        while (rootElementIterator.hasNext()) {
            Resource targetStereotypeResource;
            EObject rootElement = (EObject)rootElementIterator.next();
            if (rootElement instanceof Element || (targetStereotypeResource = this.getTargetStereotypeResource(rootElement, umlResources)) == null || targetStereotypeResource == mainUMLResource) continue;
            rootElementIterator.remove();
            targetStereotypeResource.getContents().add((Object)rootElement);
        }
    }

    protected Resource getTargetStereotypeResource(EObject rootElement, List<Resource> umlResources) {
        for (EReference eReference : rootElement.eClass().getEAllReferences()) {
            Object value;
            if (!eReference.getName().startsWith("base_") || !((value = rootElement.eGet((EStructuralFeature)eReference)) instanceof Element)) continue;
            return ((Element)value).eResource();
        }
        return null;
    }

    protected void deleteSourceStereotypes(Collection<Resource> fragmentResources) {
        HashSet<Resource> allResources = new HashSet<Resource>(fragmentResources);
        allResources.add(this.umlResource);
        for (Resource resource : allResources) {
            LinkedList resourceContents = new LinkedList(resource.getContents());
            for (EObject rootElement : resourceContents) {
                if (!sourceEPackages.contains(rootElement.eClass().getEPackage())) continue;
                this.delete(rootElement);
            }
        }
    }

    protected URI convertToPapyrus(URI rsaURI, String extension) {
        if ("epx".equals(rsaURI.fileExtension())) {
            return rsaURI.trimFileExtension().appendFileExtension("profile").appendFileExtension(extension);
        }
        return rsaURI.trimFileExtension().appendFileExtension(extension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus runTransformation(URI transformationURI, ExecutionContext context, IProgressMonitor monitor, List<ModelExtent> extents) {
        ExecutionDiagnostic result;
        TransformationExecutor executor;
        if (monitor.isCanceled()) {
            return new Status(8, "org.eclipse.papyrus.migration.rsa", "Operation canceled");
        }
        try {
            executor = this.getTransformation(transformationURI, monitor);
        }
        catch (DiagnosticException ex) {
            Diagnostic diagnostic = ex.getDiagnostic();
            Activator.log.warn(String.format("Cannot load the transformation : %s. Diagnostic: %s", transformationURI, diagnostic.getMessage()));
            return ImportTransformation.createStatusFromDiagnostic(diagnostic);
        }
        TransformationExecutor transformationExecutor = executor;
        synchronized (transformationExecutor) {
            try {
                result = executor.execute(context, extents.toArray(new ModelExtent[0]));
            }
            finally {
                executor.cleanup();
                executorsPool.releaseExecutor(executor);
            }
        }
        return ImportTransformation.createStatusFromDiagnostic((Diagnostic)result);
    }

    protected ExecutionContext createExecutionContext(IProgressMonitor monitor, final MultiStatus generationStatus) {
        ExecutionContextImpl context = new ExecutionContextImpl();
        context.setConfigProperty("keepModeling", (Object)true);
        context.setConfigProperty("monitor", (Object)monitor);
        context.setLog((Log)new WriterLog(new OutputStreamWriter(System.out)){

            public void log(String message) {
                super.log(message);
            }

            public void log(String message, Object param) {
                super.log(message, param);
            }

            public void log(int level, String message) {
                super.log(level, message);
                if (level >= 1) {
                    generationStatus.merge((IStatus)new Status(level, "org.eclipse.papyrus.migration.rsa", message));
                }
            }

            public void log(int level, String message, Object param) {
                super.log(level, message, param);
                if (level >= 1) {
                    generationStatus.merge((IStatus)new Status(level, "org.eclipse.papyrus.migration.rsa", String.valueOf(message) + ", data:" + param));
                }
            }
        });
        this.initTransformationProperties(context);
        return context;
    }

    protected void initTransformationProperties(ExecutionContextImpl context) {
        context.setConfigProperty("profilebase.properties", (Object)this.readProfileBaseProperties());
        URI innerClassDiagramViewURI = URI.createPlatformPluginURI((String)"org.eclipse.papyrus.infra.viewpoints.policy/builtin/default.configuration", (boolean)false);
        innerClassDiagramViewURI = innerClassDiagramViewURI.appendFragment("//@viewpoints.0/@modelKinds.0");
        context.setConfigProperty("InnerClassDiagramView", (Object)this.resourceSet.getEObject(innerClassDiagramViewURI, true));
    }

    protected void configureResource(XMIResource resource) {
        HashMap<String, Object> saveOptions = new HashMap<String, Object>();
        saveOptions.put("DECLARE_XML", Boolean.TRUE);
        saveOptions.put("PROCESS_DANGLING_HREF", "DISCARD");
        saveOptions.put("SCHEMA_LOCATION", Boolean.TRUE);
        saveOptions.put("USE_XMI_TYPE", Boolean.TRUE);
        saveOptions.put("SAVE_TYPE_INFORMATION", Boolean.TRUE);
        saveOptions.put("SKIP_ESCAPE_URI", Boolean.FALSE);
        saveOptions.put("ENCODING", "UTF-8");
        saveOptions.put("URI_HANDLER", new URIHandlerImpl.PlatformSchemeAware());
        resource.setEncoding("UTF-8");
        resource.getDefaultSaveOptions().putAll(saveOptions);
    }

    protected List<ModelExtent> getModelExtents() {
        LinkedList<ModelExtent> allExtents = new LinkedList<ModelExtent>();
        allExtents.add(this.getInOutUMLModel());
        allExtents.add(this.getInoutNotationModel());
        allExtents.add(this.getOutSashModel());
        allExtents.add(this.getInConfig());
        return allExtents;
    }

    protected ModelExtent getInOutUMLModel() {
        if (this.outUML == null) {
            try {
                Resource resource = this.resourceSet.getResource(this.sourceURI, true);
                LinkedList<EObject> allStereotypeApplications = new LinkedList<EObject>();
                TreeIterator allContents = resource.getAllContents();
                HashSet<Resource> browsedResources = new HashSet<Resource>();
                browsedResources.add(resource);
                while (allContents.hasNext()) {
                    EObject next = (EObject)allContents.next();
                    if (!(next instanceof Element)) {
                        allContents.prune();
                        continue;
                    }
                    Resource nextResource = next.eResource();
                    if (browsedResources.contains(nextResource)) continue;
                    browsedResources.add(nextResource);
                    for (EObject rootElement : nextResource.getContents()) {
                        EPackage rootElementPackage = rootElement.eClass().getEPackage();
                        if (!sourceEPackages.contains(rootElementPackage)) continue;
                        allStereotypeApplications.add(rootElement);
                    }
                }
                LinkedList<EObject> allRootElements = new LinkedList<EObject>((Collection<EObject>)resource.getContents());
                allRootElements.addAll(allStereotypeApplications);
                this.outUML = new BasicModelExtent(allRootElements);
            }
            catch (Exception ex) {
                Activator.log.error((Throwable)ex);
            }
        }
        return this.outUML;
    }

    protected ModelExtent getInoutNotationModel() {
        if (this.outNotation == null) {
            this.outNotation = new BasicModelExtent();
        }
        return this.outNotation;
    }

    protected ModelExtent getOutSashModel() {
        if (this.outSashModel == null) {
            this.outSashModel = new BasicModelExtent();
        }
        return this.outSashModel;
    }

    protected Collection<URI> getDiagramTransformationURIs() {
        return ListHelper.asList((Object[])new URI[]{this.getTransformationURI("RSAClassDiagram"), this.getTransformationURI("RSAStructureDiagram"), this.getTransformationURI("RSAActivityDiagram"), this.getTransformationURI("RSAStateMachineDiagram"), this.getTransformationURI("RSAProfileDiagram"), this.getTransformationURI("RSAUsecaseDiagram")});
    }

    protected URI getSemanticTransformationURI() {
        return this.getTransformationURI("RSAModelToPapyrus");
    }

    protected URI getRTTransformationURI() {
        return this.getTransformationURI("RSARTToPapyrusRT");
    }

    protected URI getProfilesTransformationURI() {
        return this.getTransformationURI("RSAProfilesToPapyrus");
    }

    protected Collection<URI> getAllTransformationURIs() {
        Collection<URI> allTransformations = this.getDiagramTransformationURIs();
        allTransformations.add(this.getRTTransformationURI());
        allTransformations.add(this.getProfilesTransformationURI());
        allTransformations.add(this.getSemanticTransformationURI());
        return allTransformations;
    }

    protected URI getTransformationURI(String transformationName) {
        return URI.createPlatformPluginURI((String)String.format("%s/transform/%s.qvto", "org.eclipse.papyrus.migration.rsa", transformationName), (boolean)true);
    }

    public String getModelName() {
        return URI.decode((String)this.sourceURI.lastSegment());
    }

    public void cancel() {
        this.job.cancel();
    }

    public void delete(EObject elementToDelete) {
        EObject parent;
        CacheAdapter adapter = CacheAdapter.getCacheAdapter((Notifier)elementToDelete);
        if (adapter == null) {
            adapter = CacheAdapter.getInstance();
        }
        adapter.unsetTarget((Notifier)elementToDelete);
        if (elementToDelete.eResource() != null) {
            elementToDelete.eResource().getContents().remove((Object)elementToDelete);
        }
        if ((parent = elementToDelete.eContainer()) == null) {
            return;
        }
        EReference containmentFeature = elementToDelete.eContainmentFeature();
        if (containmentFeature.getUpperBound() == 1) {
            parent.eUnset((EStructuralFeature)containmentFeature);
        } else {
            List values = (List)parent.eGet((EStructuralFeature)containmentFeature);
            values.remove(elementToDelete);
        }
    }
}

