/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.migration.rsa.transformation;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.InternalTransaction;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.infra.services.labelprovider.service.impl.LabelProviderServiceImpl;
import org.eclipse.papyrus.migration.rsa.Activator;
import org.eclipse.papyrus.uml.modelrepair.internal.stereotypes.IRepairAction;
import org.eclipse.papyrus.uml.modelrepair.internal.stereotypes.ZombieStereotypesDescriptor;
import org.eclipse.uml2.uml.Component;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.ProfileApplication;
import org.eclipse.uml2.uml.UMLPackage;

public class RepairStereotypes {
    private final ModelSet modelSet;
    private final Collection<Resource> resourcesToRepair;
    private final Map<URI, URI> profileMappings;

    public RepairStereotypes(ModelSet modelSet, Collection<Resource> resourcesToRepair, Map<URI, URI> profileMappings) {
        this.modelSet = modelSet;
        this.resourcesToRepair = resourcesToRepair;
        this.profileMappings = profileMappings;
    }

    public void execute() throws InterruptedException, RollbackException {
        ZombieStereotypesDescriptor result = null;
        LabelProviderServiceImpl labelProvider = new LabelProviderServiceImpl();
        try {
            labelProvider.startService();
        }
        catch (Exception ex) {
            Activator.log.error((Throwable)ex);
            return;
        }
        Function<? super EPackage, Profile> profileSupplier = this.getProfileSupplier();
        for (Resource resource : this.resourcesToRepair) {
            Element rootElement = (Element)EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)UMLPackage.Literals.ELEMENT);
            if (rootElement == null || rootElement.getNearestPackage() == null) continue;
            Package rootPackage = rootElement.getNearestPackage();
            ArrayList profileApplications = Lists.newArrayList();
            TreeIterator iter = EcoreUtil.getAllProperContents(Collections.singleton(rootPackage), (boolean)false);
            while (iter.hasNext()) {
                EObject next = (EObject)iter.next();
                if (next instanceof ProfileApplication) {
                    profileApplications.add((ProfileApplication)next);
                    iter.prune();
                    continue;
                }
                if (next instanceof Package || next instanceof Component) continue;
                iter.prune();
            }
            Set<EPackage> appliedDefinitions = this.getAppliedDefinitions(profileApplications);
            ZombieStereotypesDescriptor zombies = new ZombieStereotypesDescriptor(resource, rootPackage, appliedDefinitions, profileSupplier, (LabelProviderService)labelProvider);
            for (EObject next : resource.getContents()) {
                if (next instanceof Element) continue;
                zombies.analyze(next);
            }
            if (zombies.hasZombies()) {
                result = zombies;
            }
            if (result == null) continue;
            ZombieStereotypesDescriptor descriptor = result;
            TransactionalEditingDomain domain = this.modelSet.getTransactionalEditingDomain();
            InternalTransactionalEditingDomain internalDomain = (InternalTransactionalEditingDomain)domain;
            HashMap<String, Boolean> options = new HashMap<String, Boolean>();
            options.put("no_undo", true);
            options.put("no_validation", true);
            options.put("no_triggers", true);
            options.put("unprotected", true);
            InternalTransaction fastTransaction = internalDomain.startTransaction(false, options);
            try {
                BasicDiagnostic diagnostics = new BasicDiagnostic("org.eclipse.papyrus.migration.rsa", 0, "Problems in repairing stereotypes", null);
                for (IAdaptable packageToRepair : descriptor.getZombieSchemas()) {
                    IRepairAction action = descriptor.getRepairAction(packageToRepair, IRepairAction.Kind.APPLY_LATEST_PROFILE_DEFINITION);
                    descriptor.repair(packageToRepair, action, (DiagnosticChain)diagnostics, (IProgressMonitor)new NullProgressMonitor());
                }
            }
            finally {
                fastTransaction.commit();
            }
        }
        try {
            labelProvider.disposeService();
        }
        catch (ServiceException ex) {
            Activator.log.error((Throwable)ex);
        }
    }

    protected Function<? super EPackage, Profile> getProfileSupplier() {
        return new Function<EPackage, Profile>(){

            public Profile apply(EPackage input) {
                if (input.eResource() == null || input.eResource().getURI() == null) {
                    return null;
                }
                URI packageResourceURI = input.eResource().getURI();
                URI targetResourceURI = (URI)RepairStereotypes.this.profileMappings.get(packageResourceURI);
                Profile result = null;
                URI selectedProfileURI = targetResourceURI;
                if (selectedProfileURI != null && (result = (Profile)EMFHelper.load((ResourceSet)RepairStereotypes.this.modelSet, (URI)selectedProfileURI, Profile.class)) != null && !this.hasNestedProfiles(result)) {
                    return result;
                }
                return null;
            }

            boolean hasNestedProfiles(Profile profile) {
                return Iterators.any((Iterator)profile.eAllContents(), (Predicate)Predicates.instanceOf(Profile.class));
            }
        };
    }

    protected Set<EPackage> getAppliedDefinitions(Iterable<? extends ProfileApplication> profileApplications) {
        HashSet result = Sets.newHashSet();
        for (ProfileApplication profileApplication : profileApplications) {
            EPackage definition = profileApplication.getAppliedDefinition();
            if (definition == null || definition.eIsProxy()) continue;
            result.add(definition);
        }
        return result;
    }
}

