/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.migration.rsa.transformation.ui;

import java.text.Collator;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.infra.services.labelprovider.service.impl.LabelProviderServiceImpl;
import org.eclipse.papyrus.infra.widgets.editors.TreeSelectorDialog;
import org.eclipse.papyrus.infra.widgets.providers.CollectionContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.EncapsulatedContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.StaticContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.WorkspaceContentProvider;
import org.eclipse.papyrus.migration.rsa.Activator;
import org.eclipse.papyrus.migration.rsa.RSAToPapyrusParameters.MappingParameters;
import org.eclipse.papyrus.migration.rsa.RSAToPapyrusParameters.URIMapping;
import org.eclipse.papyrus.migration.rsa.transformation.DependencyAnalysisHelper;
import org.eclipse.papyrus.migration.rsa.transformation.ui.RegisteredItemLabelProvider;
import org.eclipse.papyrus.uml.extensionpoints.IRegisteredItem;
import org.eclipse.papyrus.uml.extensionpoints.Registry;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.dialogs.SelectionDialog;

public class URIMappingDialog
extends SelectionDialog {
    MappingParameters mappingParameters;
    MappingParameters result;
    TableViewer viewer;
    LabelProviderService labelProviderService;
    private static final int BROWSE_WORKSPACE_ID = 1025;
    private static final int BROWSE_REGISTERED_ID = 1026;
    private static final int BROWSE_PROFILES_ID = 1027;
    List<URIMapping> allMappings;
    final DependencyAnalysisHelper dependencyHelper;

    public URIMappingDialog(Shell shell, MappingParameters mappingParameters, DependencyAnalysisHelper dependencyHelper) {
        super(shell);
        this.dependencyHelper = dependencyHelper;
        this.mappingParameters = mappingParameters;
    }

    protected void configureShell(Shell shell) {
        this.setTitle("Some dependencies are missing");
        super.configureShell(shell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        this.labelProviderService = new LabelProviderServiceImpl();
        try {
            this.labelProviderService.startService();
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
        }
        Label description = new Label(area, 64);
        description.setLayoutData((Object)new GridData(4, 1, true, false));
        description.setText("Some elements in the following resources can't be resolved. Please choose the resources to replace them.");
        Composite self = new Composite(area, 0);
        self.setLayout((Layout)new GridLayout(1, true));
        self.setLayoutData((Object)new GridData(1808));
        this.result = (MappingParameters)EcoreUtil.copy((EObject)this.mappingParameters);
        this.setResult(Collections.singletonList(this.mappingParameters));
        Composite buttonsBarComposite = new Composite(self, 0);
        GridLayout buttonsLayout = new GridLayout(0, false);
        buttonsLayout.marginWidth = 0;
        buttonsBarComposite.setLayout((Layout)buttonsLayout);
        buttonsBarComposite.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        Button browseWorkspace = this.createButton(buttonsBarComposite, 1025, "", false);
        browseWorkspace.setImage(org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage("icons/browse_12x12.gif"));
        browseWorkspace.setToolTipText("Browse Workspace");
        Button browseRegistered = this.createButton(buttonsBarComposite, 1026, "", false);
        browseRegistered.setImage(org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage("icons/Add_12x12.gif"));
        browseRegistered.setToolTipText("Browse Registered Libraries");
        Button browseProfiles = this.createButton(buttonsBarComposite, 1027, "", false);
        browseProfiles.setImage(org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage("icons/AddReg.gif"));
        browseProfiles.setToolTipText("Browse Registered Profiles");
        this.viewer = new TableViewer(self, 67584);
        Table table = this.viewer.getTable();
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        GridData tableData = new GridData(4, 4, true, true);
        tableData.minimumHeight = 120;
        table.setLayoutData((Object)tableData);
        table.setHeaderVisible(true);
        TableColumn locationColumn = new TableColumn(table, 0);
        locationColumn.setText("Location");
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, 250, true));
        TableColumn newLocationColumn = new TableColumn(table, 0);
        newLocationColumn.setText("New Location");
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, 250, true));
        this.viewer.setContentProvider((IContentProvider)CollectionContentProvider.instance);
        this.viewer.setLabelProvider((IBaseLabelProvider)new URIColumnsLabelProvider());
        this.viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof URIMapping && e2 instanceof URIMapping) {
                    URIMapping map1 = (URIMapping)e1;
                    URIMapping map2 = (URIMapping)e2;
                    return Collator.getInstance().compare(map1.getSourceURI(), map2.getSourceURI());
                }
                return 0;
            }
        });
        this.allMappings = this.dependencyHelper.flattenURIMappings(this.result);
        this.viewer.setInput(this.allMappings);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                URIMappingDialog.this.updateControls();
            }
        });
        this.updateControls();
        return self;
    }

    public boolean close() {
        try {
            this.labelProviderService.disposeService();
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
        }
        return super.close();
    }

    protected void updateControls() {
        boolean enableBrowse = !this.viewer.getSelection().isEmpty();
        this.getButton(1026).setEnabled(enableBrowse);
        this.getButton(1025).setEnabled(enableBrowse);
        this.getButton(1027).setEnabled(enableBrowse);
        this.viewer.refresh();
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 1026: {
                this.browseRegisteredLibraries();
                return;
            }
            case 1025: {
                this.browseWorkspaceLibraries();
                return;
            }
            case 1027: {
                this.browseRegisteredProfiles();
                return;
            }
        }
        super.buttonPressed(buttonId);
    }

    protected URIMapping getSelectedMapping() {
        Object selectedElement;
        ISelection selection = this.viewer.getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        if (selection instanceof IStructuredSelection && (selectedElement = ((IStructuredSelection)selection).getFirstElement()) instanceof URIMapping) {
            return (URIMapping)selectedElement;
        }
        return null;
    }

    protected void browseWorkspaceLibraries() {
        if (this.getSelectedMapping() == null) {
            return;
        }
        LinkedHashMap<String, String> extensionFilters = new LinkedHashMap<String, String>();
        extensionFilters.put("*.uml", "UML (*.uml)");
        extensionFilters.put("*", "All (*)");
        TreeSelectorDialog dialog = new TreeSelectorDialog(this.getShell());
        dialog.setTitle("Browse Workspace");
        dialog.setDescription("Select a library in the workspace.");
        WorkspaceContentProvider workspaceContentProvider = new WorkspaceContentProvider();
        workspaceContentProvider.setExtensionFilters(extensionFilters);
        dialog.setContentProvider((ITreeContentProvider)workspaceContentProvider);
        dialog.setLabelProvider(this.labelProviderService.getLabelProvider());
        if (dialog.open() == 0) {
            Object[] result = dialog.getResult();
            if (result == null || result.length == 0) {
                return;
            }
            Object selectedFile = result[0];
            if (selectedFile instanceof IFile) {
                IPath filePath = ((IFile)selectedFile).getFullPath();
                URI workspaceURI = URI.createPlatformResourceURI((String)filePath.toString(), (boolean)true);
                this.replaceSelectionWith(workspaceURI);
            }
        }
    }

    protected void replaceSelectionWith(URI targetURI) {
        URIMapping mapping = this.getSelectedMapping();
        mapping.setTargetURI(targetURI.toString());
        this.updateControls();
    }

    protected void browseRegisteredLibraries() {
        this.browseRegisteredItems(Registry.getRegisteredLibraries(), "Browse Registered Libraries", "Select one of the registered libraries below.");
    }

    protected void browseRegisteredProfiles() {
        this.browseRegisteredItems(Registry.getRegisteredProfiles(), "Browse Registered Profiles", "Select one of the registered profiles below.");
    }

    protected void browseRegisteredItems(Collection<? extends IRegisteredItem> items, String dialogTitle, String dialogDescription) {
        TreeSelectorDialog dialog = new TreeSelectorDialog(this.getShell());
        dialog.setTitle(dialogTitle);
        dialog.setDescription(dialogDescription);
        dialog.setContentProvider((ITreeContentProvider)new EncapsulatedContentProvider((IStructuredContentProvider)new StaticContentProvider((Object[])items.toArray(new IRegisteredItem[0]))));
        dialog.setLabelProvider((ILabelProvider)new RegisteredItemLabelProvider());
        if (dialog.open() == 0) {
            Object[] result = dialog.getResult();
            if (result == null || result.length == 0) {
                return;
            }
            Object selectedElement = result[0];
            if (selectedElement instanceof IRegisteredItem) {
                IRegisteredItem item = (IRegisteredItem)selectedElement;
                this.replaceSelectionWith(item.getUri());
            }
        }
    }

    protected void okPressed() {
        this.dependencyHelper.propagateURIMappings(this.allMappings, this.result);
        this.setResult(Collections.singletonList(this.result));
        super.okPressed();
    }

    private class URIColumnsLabelProvider
    extends ColumnLabelProvider {
        private URIColumnsLabelProvider() {
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            URIMapping mapping = element instanceof URIMapping ? (URIMapping)element : null;
            switch (cell.getColumnIndex()) {
                case 0: {
                    this.updateLocation(cell, mapping);
                    break;
                }
                case 1: {
                    this.updateNewLocation(cell, mapping);
                }
            }
        }

        public void updateLocation(ViewerCell cell, URIMapping mapping) {
            String location = "Unknown";
            if (mapping != null) {
                location = mapping.getSourceURI();
            }
            cell.setText(location);
        }

        public void updateNewLocation(ViewerCell cell, URIMapping mapping) {
            String location = "";
            if (mapping.getTargetURI() != null) {
                location = mapping.getTargetURI();
            }
            cell.setText(location);
        }
    }
}

