/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.async.fuml;

import org.eclipse.debug.core.DebugException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.infra.core.Activator;
import org.eclipse.papyrus.moka.MokaConstants;
import org.eclipse.papyrus.moka.async.fuml.Semantics.CommonBehaviors.Communications.AsyncFIFOGetNextEventStrategy;
import org.eclipse.papyrus.moka.async.fuml.Semantics.Loci.LociL1.AsyncLocus;
import org.eclipse.papyrus.moka.async.fuml.debug.AsyncControlDelegate;
import org.eclipse.papyrus.moka.communication.Marshaller;
import org.eclipse.papyrus.moka.communication.event.EventMessage;
import org.eclipse.papyrus.moka.communication.event.isuspendresume.Resume_Event;
import org.eclipse.papyrus.moka.communication.request.isuspendresume.Resume_Request;
import org.eclipse.papyrus.moka.composites.CompositeStructuresExecutionEngine;
import org.eclipse.papyrus.moka.composites.Semantics.CommonBehaviors.Communications.CS_DispatchOperationOfInterfaceStrategy;
import org.eclipse.papyrus.moka.composites.Semantics.CommonBehaviors.Communications.CS_NameBased_StructuralFeatureOfInterfaceAccessStrategy;
import org.eclipse.papyrus.moka.composites.Semantics.CompositeStructures.InvocationActions.CS_DefaultConstructStrategy;
import org.eclipse.papyrus.moka.composites.Semantics.CompositeStructures.InvocationActions.CS_DefaultRequestPropagationStrategy;
import org.eclipse.papyrus.moka.composites.Semantics.Loci.LociL3.CS_ExecutionFactory;
import org.eclipse.papyrus.moka.composites.Semantics.Loci.LociL3.CS_Executor;
import org.eclipse.papyrus.moka.engine.AbstractExecutionEngine;
import org.eclipse.papyrus.moka.fuml.FUMLExecutionEngine;
import org.eclipse.papyrus.moka.fuml.Semantics.Loci.LociL1.ExecutionFactory;
import org.eclipse.papyrus.moka.fuml.Semantics.Loci.LociL1.Executor;
import org.eclipse.papyrus.moka.fuml.Semantics.Loci.LociL1.Locus;
import org.eclipse.papyrus.moka.fuml.Semantics.Loci.LociL1.SemanticStrategy;
import org.eclipse.papyrus.moka.fuml.debug.ControlDelegate;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Behavior;

public class FUMLAsyncExecutionEngine
extends CompositeStructuresExecutionEngine {
    public void start(Behavior behavior) {
        if (behavior != null) {
            main = behavior;
            this.locus = new AsyncLocus();
            this.locus.setFactory((ExecutionFactory)new CS_ExecutionFactory());
            this.locus.setExecutor((Executor)new CS_Executor());
            this.initializeBuiltInPrimitiveTypes(this.locus);
            this.registerOpaqueBehaviorExecutions(this.locus);
            this.registerSemanticStrategies(this.locus);
            this.registerSystemServices(this.locus);
            this.initializeArguments(this.args);
            this.started = true;
            this.locus.executor.execute(main, null, this.arguments);
            ((AsyncControlDelegate)eInstance.getControlDelegate()).notifyMainThreadLogicallyEnded();
        }
    }

    protected void registerSemanticStrategies(Locus locus) {
        super.registerSemanticStrategies(locus);
        locus.factory.setStrategy((SemanticStrategy)new AsyncFIFOGetNextEventStrategy());
        locus.factory.setStrategy((SemanticStrategy)new CS_DispatchOperationOfInterfaceStrategy());
        locus.factory.setStrategy((SemanticStrategy)new CS_NameBased_StructuralFeatureOfInterfaceAccessStrategy());
        locus.factory.setStrategy((SemanticStrategy)new CS_DefaultRequestPropagationStrategy());
        locus.factory.setStrategy((SemanticStrategy)new CS_DefaultConstructStrategy());
    }

    public ControlDelegate getControlDelegate() {
        if (this.controlDelegate == null) {
            this.controlDelegate = new AsyncControlDelegate((AbstractExecutionEngine)this);
        }
        return this.controlDelegate;
    }

    public void resume(Resume_Request request) {
        if (!this.started) {
            Runnable execution = new Runnable(){

                public void run() {
                    if (main != null) {
                        try {
                            FUMLAsyncExecutionEngine.this.start(main);
                        }
                        catch (Exception e) {
                            Activator.log.error((Throwable)e);
                            if (!MokaConstants.SILENT_MODE) {
                                Display.getDefault().syncExec(new Runnable(){

                                    public void run() {
                                        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Moka", (String)"An unexpected error occurred during execution. See error log for details.");
                                    }
                                });
                            }
                            FUMLAsyncExecutionEngine.this.setIsTerminated(true);
                        }
                        FUMLExecutionEngine.eInstance.getControlDelegate().waitForTermination();
                        try {
                            FUMLAsyncExecutionEngine.this.getDebugTarget().terminate();
                        }
                        catch (DebugException e) {
                            Activator.log.error((Throwable)e);
                        }
                    }
                }
            };
            Thread mainThread = new Thread(execution);
            ((AsyncControlDelegate)eInstance.getControlDelegate()).registerObjectActivation(null);
            mainThread.start();
        } else {
            this.getControlDelegate().resume(request);
        }
    }

    protected void resume_reply(String message) {
        Resume_Request request = Marshaller.getInstance().resume_request_unmarshal(message);
        this.resume(request);
        Resume_Event event = new Resume_Event(request.getDebugElement(), request.getResumeDetail(), this.getThreads());
        this.sendEvent((EventMessage)event);
    }
}

