/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.composites.Semantics.CompositeStructures.StructuredClasses;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.moka.composites.Semantics.CommonBehaviors.Communications.CS_DispatchOperationOfInterfaceStrategy;
import org.eclipse.papyrus.moka.composites.Semantics.CommonBehaviors.Communications.CS_StructuralFeatureOfInterfaceAccessStrategy;
import org.eclipse.papyrus.moka.composites.Semantics.CompositeStructures.InvocationActions.CS_RequestPropagationStrategy;
import org.eclipse.papyrus.moka.composites.Semantics.CompositeStructures.InvocationActions.CS_SignalInstance;
import org.eclipse.papyrus.moka.composites.Semantics.CompositeStructures.StructuredClasses.CS_InteractionPoint;
import org.eclipse.papyrus.moka.composites.Semantics.CompositeStructures.StructuredClasses.CS_Link;
import org.eclipse.papyrus.moka.composites.Semantics.CompositeStructures.StructuredClasses.CS_LinkKind;
import org.eclipse.papyrus.moka.composites.Semantics.CompositeStructures.StructuredClasses.CS_Reference;
import org.eclipse.papyrus.moka.fuml.Semantics.Actions.BasicActions.CallOperationActionActivation;
import org.eclipse.papyrus.moka.fuml.Semantics.Actions.BasicActions.SendSignalActionActivation;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.ExtensionalValue;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.FeatureValue;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.Object_;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.Reference;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.Value;
import org.eclipse.papyrus.moka.fuml.Semantics.CommonBehaviors.BasicBehaviors.Execution;
import org.eclipse.papyrus.moka.fuml.Semantics.CommonBehaviors.Communications.SignalInstance;
import org.eclipse.papyrus.moka.fuml.Semantics.Loci.LociL1.ChoiceStrategy;
import org.eclipse.papyrus.moka.fuml.Semantics.Loci.LociL1.SemanticVisitor;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.ConnectorKind;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.StructuralFeature;

public class CS_Object
extends Object_ {
    public Execution dispatchIn(Operation operation, CS_InteractionPoint interactionPoint) {
        Execution execution = null;
        if (!interactionPoint.definingPort.isBehavior()) {
            boolean operationIsProvided = true;
            ArrayList<Reference> potentialTargets = new ArrayList<Reference>();
            List<CS_Link> cddLinks = this.getLinks(interactionPoint);
            Integer linkIndex = 1;
            while (linkIndex <= cddLinks.size()) {
                List<Reference> validTargets = this.selectTargetsForDispatching(cddLinks.get(linkIndex - 1), interactionPoint, ConnectorKind.DELEGATION_LITERAL, operation, operationIsProvided);
                Integer targetIndex = 1;
                while (targetIndex <= validTargets.size()) {
                    potentialTargets.add(validTargets.get(targetIndex - 1));
                    targetIndex = targetIndex + 1;
                }
                linkIndex = linkIndex + 1;
            }
            if (potentialTargets.size() != 0) {
                CS_RequestPropagationStrategy strategy = (CS_RequestPropagationStrategy)this.locus.factory.getStrategy("requestPropagation");
                List<Reference> targets = strategy.select(potentialTargets, (SemanticVisitor)new CallOperationActionActivation());
                Reference target = targets.get(0);
                execution = target.dispatch(operation);
            }
        }
        return execution;
    }

    public void sendIn(SignalInstance signalInstance, CS_InteractionPoint interactionPoint) {
        if (interactionPoint.definingPort.isBehavior()) {
            CS_SignalInstance newSignalInstance = (CS_SignalInstance)signalInstance.copy();
            newSignalInstance.interactionPoint = interactionPoint;
            this.send(newSignalInstance);
        } else {
            boolean toInternal = true;
            ArrayList<Reference> potentialTargets = new ArrayList<Reference>();
            List<CS_Link> cddLinks = this.getLinks(interactionPoint);
            Integer linkIndex = 1;
            while (linkIndex <= cddLinks.size()) {
                List<Reference> validTargets = this.selectTargetsForSending(cddLinks.get(linkIndex - 1), interactionPoint, ConnectorKind.DELEGATION_LITERAL, signalInstance.type, toInternal);
                Integer targetIndex = 1;
                while (targetIndex <= validTargets.size()) {
                    potentialTargets.add(validTargets.get(targetIndex - 1));
                    targetIndex = targetIndex + 1;
                }
                linkIndex = linkIndex + 1;
            }
            int i = 0;
            while (i < potentialTargets.size()) {
                Reference target = (Reference)potentialTargets.get(i);
                CS_SignalInstance newSignalInstance = (CS_SignalInstance)signalInstance.copy();
                newSignalInstance.interactionPoint = interactionPoint;
                target.send((SignalInstance)newSignalInstance);
                ++i;
            }
        }
    }

    public List<Reference> selectTargetsForSending(CS_Link link, CS_InteractionPoint interactionPoint, ConnectorKind connectorKind, Signal signal, Boolean toInternal) {
        ArrayList<Reference> potentialTargets;
        block21: {
            block20: {
                potentialTargets = new ArrayList<Reference>();
                if (!toInternal.booleanValue() || connectorKind != ConnectorKind.DELEGATION_LITERAL) break block20;
                if (this.getLinkKind(link, interactionPoint) != CS_LinkKind.ToInternal) break block21;
                Integer i = 1;
                while (i <= link.getFeatureValues().size()) {
                    List values = ((FeatureValue)link.getFeatureValues().get((int)(i.intValue() - 1))).values;
                    if (!values.isEmpty()) {
                        Integer j = 1;
                        while (j <= values.size()) {
                            Reference cddTarget = (Reference)values.get(j - 1);
                            if (!cddTarget.equals((Value)interactionPoint).booleanValue()) {
                                potentialTargets.add(cddTarget);
                            }
                            j = j + 1;
                        }
                    }
                    i = i + 1;
                }
                break block21;
            }
            if (this.getLinkKind(link, interactionPoint) == CS_LinkKind.ToEnvironment) {
                Integer i = 1;
                while (i <= link.getFeatureValues().size()) {
                    List values = ((FeatureValue)link.getFeatureValues().get((int)(i.intValue() - 1))).values;
                    if (!values.isEmpty() && values.get(0) instanceof Reference) {
                        CS_Object container;
                        Integer j;
                        List<CS_Object> directContainers;
                        Reference cddTarget = (Reference)values.get(0);
                        if (connectorKind == ConnectorKind.ASSEMBLY_LITERAL) {
                            if (!(cddTarget instanceof CS_InteractionPoint)) {
                                potentialTargets.add(cddTarget);
                            } else {
                                directContainers = this.getDirectContainers();
                                boolean isAssembly = true;
                                j = 1;
                                if (!this.hasValueForAFeature((Value)cddTarget).booleanValue()) {
                                    while (isAssembly && j <= directContainers.size()) {
                                        container = directContainers.get(j - 1);
                                        if (container.hasValueForAFeature((Value)cddTarget).booleanValue()) {
                                            isAssembly = false;
                                        }
                                        j = j + 1;
                                    }
                                } else {
                                    isAssembly = false;
                                }
                                if (isAssembly) {
                                    potentialTargets.add(cddTarget);
                                }
                            }
                        } else if (cddTarget instanceof CS_InteractionPoint) {
                            directContainers = this.getDirectContainers();
                            boolean isDelegation = false;
                            j = 1;
                            while (!isDelegation && j <= directContainers.size()) {
                                container = directContainers.get(j - 1);
                                if (container.hasValueForAFeature((Value)cddTarget).booleanValue()) {
                                    isDelegation = true;
                                }
                                j = j + 1;
                            }
                            if (isDelegation) {
                                potentialTargets.add(cddTarget);
                            }
                        }
                    }
                    i = i + 1;
                }
            }
        }
        return potentialTargets;
    }

    public List<Reference> selectTargetsForDispatching(CS_Link link, CS_InteractionPoint interactionPoint, ConnectorKind connectorKind, Operation operation, Boolean toInternal) {
        ArrayList<Reference> potentialTargets;
        block20: {
            block19: {
                potentialTargets = new ArrayList<Reference>();
                if (!toInternal.booleanValue() || connectorKind != ConnectorKind.DELEGATION_LITERAL) break block19;
                if (this.getLinkKind(link, interactionPoint) != CS_LinkKind.ToInternal) break block20;
                Integer i = 1;
                while (i <= link.getFeatureValues().size()) {
                    Reference cddTarget;
                    List values = ((FeatureValue)link.getFeatureValues().get((int)(i.intValue() - 1))).values;
                    if (!values.isEmpty() && values.get(0) instanceof Reference && (cddTarget = (Reference)values.get(0)) != interactionPoint && this.isOperationProvided(cddTarget, operation).booleanValue()) {
                        potentialTargets.add(cddTarget);
                    }
                    i = i + 1;
                }
                break block20;
            }
            if (this.getLinkKind(link, interactionPoint) == CS_LinkKind.ToEnvironment) {
                Integer i = 1;
                while (i <= link.getFeatureValues().size()) {
                    List values = ((FeatureValue)link.getFeatureValues().get((int)(i.intValue() - 1))).values;
                    if (!values.isEmpty() && values.get(0) instanceof Reference) {
                        CS_Object container;
                        Integer j;
                        List<CS_Object> directContainers;
                        Reference cddTarget = (Reference)values.get(0);
                        if (connectorKind == ConnectorKind.ASSEMBLY_LITERAL) {
                            if (!(cddTarget instanceof CS_InteractionPoint)) {
                                if (this.isOperationProvided(cddTarget, operation).booleanValue()) {
                                    potentialTargets.add(cddTarget);
                                }
                            } else {
                                directContainers = this.getDirectContainers();
                                boolean isAssembly = true;
                                j = 1;
                                if (!this.hasValueForAFeature((Value)cddTarget).booleanValue()) {
                                    while (isAssembly && j <= directContainers.size()) {
                                        container = directContainers.get(j - 1);
                                        if (container.hasValueForAFeature((Value)cddTarget).booleanValue()) {
                                            isAssembly = false;
                                        }
                                        j = j + 1;
                                    }
                                } else {
                                    isAssembly = false;
                                }
                                if (isAssembly && this.isOperationProvided(cddTarget, operation).booleanValue()) {
                                    potentialTargets.add(cddTarget);
                                }
                            }
                        } else if (cddTarget instanceof CS_InteractionPoint) {
                            directContainers = this.getDirectContainers();
                            boolean isDelegation = false;
                            j = 1;
                            while (!isDelegation && j <= directContainers.size()) {
                                container = directContainers.get(j - 1);
                                if (container.hasValueForAFeature((Value)cddTarget).booleanValue()) {
                                    isDelegation = true;
                                }
                                j = j + 1;
                            }
                            if (isDelegation && this.isOperationRequired(cddTarget, operation).booleanValue()) {
                                potentialTargets.add(cddTarget);
                            }
                        }
                    }
                    i = i + 1;
                }
            }
        }
        return potentialTargets;
    }

    public void sendOut(SignalInstance signalInstance, CS_InteractionPoint interactionPoint) {
        boolean notToInternal = false;
        ArrayList<Reference> allPotentialTargets = new ArrayList<Reference>();
        ArrayList<Reference> targetsForSendingIn = new ArrayList<Reference>();
        ArrayList<Reference> targetsForSendingOut = new ArrayList<Reference>();
        List<CS_Link> cddLinks = this.getLinks(interactionPoint);
        Integer linkIndex = 1;
        while (linkIndex <= cddLinks.size()) {
            List<Reference> validAssemblyTargets = this.selectTargetsForSending(cddLinks.get(linkIndex - 1), interactionPoint, ConnectorKind.ASSEMBLY_LITERAL, signalInstance.type, notToInternal);
            Integer targetIndex = 1;
            while (targetIndex <= validAssemblyTargets.size()) {
                allPotentialTargets.add(validAssemblyTargets.get(targetIndex - 1));
                targetsForSendingIn.add(validAssemblyTargets.get(targetIndex - 1));
                targetIndex = targetIndex + 1;
            }
            List<Reference> validDelegationTargets = this.selectTargetsForSending(cddLinks.get(linkIndex - 1), interactionPoint, ConnectorKind.DELEGATION_LITERAL, signalInstance.type, notToInternal);
            targetIndex = 1;
            while (targetIndex <= validDelegationTargets.size()) {
                allPotentialTargets.add(validDelegationTargets.get(targetIndex - 1));
                targetsForSendingOut.add(validDelegationTargets.get(targetIndex - 1));
                targetIndex = targetIndex + 1;
            }
            linkIndex = linkIndex + 1;
        }
        CS_RequestPropagationStrategy strategy = (CS_RequestPropagationStrategy)this.locus.factory.getStrategy("requestPropagation");
        List<Reference> selectedTargets = strategy.select(allPotentialTargets, (SemanticVisitor)new SendSignalActionActivation());
        int j = 0;
        while (j < selectedTargets.size()) {
            Reference cddTarget;
            Reference target = selectedTargets.get(j);
            int k = 0;
            while (k < targetsForSendingIn.size()) {
                cddTarget = (Reference)targetsForSendingIn.get(k);
                if (cddTarget == target) {
                    target.send(signalInstance);
                }
                ++k;
            }
            k = 0;
            while (k < targetsForSendingOut.size()) {
                cddTarget = (CS_InteractionPoint)((Object)targetsForSendingOut.get(k));
                if (cddTarget == target) {
                    CS_Reference owner = cddTarget.owner;
                    owner.sendOut(signalInstance, (CS_InteractionPoint)cddTarget);
                }
                ++k;
            }
            ++j;
        }
    }

    public Execution dispatchOut(Operation operation, CS_InteractionPoint interactionPoint) {
        Execution execution = null;
        boolean notToInternal = false;
        ArrayList<Reference> allPotentialTargets = new ArrayList<Reference>();
        ArrayList<Reference> targetsForDispatchingIn = new ArrayList<Reference>();
        ArrayList<Reference> targetsForDispatchingOut = new ArrayList<Reference>();
        List<CS_Link> cddLinks = this.getLinks(interactionPoint);
        Integer linkIndex = 1;
        while (linkIndex <= cddLinks.size()) {
            List<Reference> validAssemblyTargets = this.selectTargetsForDispatching(cddLinks.get(linkIndex - 1), interactionPoint, ConnectorKind.ASSEMBLY_LITERAL, operation, notToInternal);
            Integer targetIndex = 1;
            while (targetIndex <= validAssemblyTargets.size()) {
                allPotentialTargets.add(validAssemblyTargets.get(targetIndex - 1));
                targetsForDispatchingIn.add(validAssemblyTargets.get(targetIndex - 1));
                targetIndex = targetIndex + 1;
            }
            List<Reference> validDelegationTargets = this.selectTargetsForDispatching(cddLinks.get(linkIndex - 1), interactionPoint, ConnectorKind.DELEGATION_LITERAL, operation, notToInternal);
            targetIndex = 1;
            while (targetIndex <= validDelegationTargets.size()) {
                allPotentialTargets.add(validDelegationTargets.get(targetIndex - 1));
                targetsForDispatchingOut.add(validDelegationTargets.get(targetIndex - 1));
                targetIndex = targetIndex + 1;
            }
            linkIndex = linkIndex + 1;
        }
        CS_RequestPropagationStrategy strategy = (CS_RequestPropagationStrategy)this.locus.factory.getStrategy("requestPropagation");
        List<Reference> selectedTargets = strategy.select(allPotentialTargets, (SemanticVisitor)new SendSignalActionActivation());
        int j = 0;
        while (j < selectedTargets.size()) {
            Reference cddTarget;
            Reference target = selectedTargets.get(j);
            int k = 0;
            while (k < targetsForDispatchingIn.size() && execution == null) {
                cddTarget = (Reference)targetsForDispatchingIn.get(k);
                if (cddTarget == target) {
                    execution = target.dispatch(operation);
                }
                ++k;
            }
            k = 0;
            while (k < targetsForDispatchingOut.size() && execution == null) {
                cddTarget = (CS_InteractionPoint)((Object)targetsForDispatchingOut.get(k));
                if (cddTarget == target) {
                    CS_Reference owner = cddTarget.owner;
                    execution = owner.dispatchOut(operation, (CS_InteractionPoint)cddTarget);
                }
                ++k;
            }
            ++j;
        }
        return execution;
    }

    public FeatureValue getFeatureValue(StructuralFeature feature) {
        if (feature.getNamespace() instanceof Interface) {
            CS_StructuralFeatureOfInterfaceAccessStrategy readStrategy = (CS_StructuralFeatureOfInterfaceAccessStrategy)this.locus.factory.getStrategy("structuralFeature");
            return readStrategy.read(this, feature);
        }
        return super.getFeatureValue(feature);
    }

    public void setFeatureValue(StructuralFeature feature, List<Value> values, Integer position) {
        if (feature.getNamespace() instanceof Interface) {
            CS_StructuralFeatureOfInterfaceAccessStrategy writeStrategy = (CS_StructuralFeatureOfInterfaceAccessStrategy)this.locus.factory.getStrategy("structuralFeature");
            writeStrategy.write(this, feature, values, position);
        } else {
            super.setFeatureValue(feature, values, position);
        }
    }

    public Boolean contains(Object_ object) {
        boolean objectIsContained = this.directlyContains(object);
        int i = 0;
        while (i < this.featureValues.size() && !objectIsContained) {
            FeatureValue featureValue = (FeatureValue)this.featureValues.get(i);
            List values = featureValue.values;
            int j = 0;
            while (j < values.size() && !objectIsContained) {
                Value value = (Value)values.get(j);
                if (value instanceof CS_Object) {
                    objectIsContained = ((CS_Object)value).contains(object);
                } else if (value instanceof CS_Reference) {
                    CS_Object referent = ((CS_Reference)value).compositeReferent;
                    objectIsContained = referent.contains(object);
                }
                ++j;
            }
            ++i;
        }
        return objectIsContained;
    }

    public Boolean directlyContains(Object_ object) {
        boolean objectIsContained = false;
        int i = 0;
        while (i < this.featureValues.size() && !objectIsContained) {
            FeatureValue featureValue = (FeatureValue)this.featureValues.get(i);
            List values = featureValue.values;
            int j = 0;
            while (j < values.size() && !objectIsContained) {
                Value value = (Value)values.get(j);
                if (value == object) {
                    objectIsContained = true;
                } else if (value instanceof CS_Reference) {
                    objectIsContained = ((CS_Reference)value).referent == object;
                }
                ++j;
            }
            ++i;
        }
        return objectIsContained;
    }

    public List<CS_Object> getDirectContainers() {
        ArrayList<CS_Object> containers = new ArrayList<CS_Object>();
        int i = 0;
        while (i < this.locus.extensionalValues.size()) {
            CS_Object cddContainer;
            ExtensionalValue extensionalValue = (ExtensionalValue)this.locus.extensionalValues.get(i);
            if (extensionalValue != this && extensionalValue instanceof CS_Object && (cddContainer = (CS_Object)extensionalValue).directlyContains(this).booleanValue()) {
                containers.add(cddContainer);
            }
            ++i;
        }
        return containers;
    }

    public Boolean isOperationProvided(Reference reference, Operation operation) {
        boolean isProvided;
        block8: {
            block7: {
                isProvided = false;
                if (!(reference instanceof CS_InteractionPoint)) break block7;
                if (!(operation.getOwner() instanceof Interface)) break block8;
                Integer interfaceIndex = 1;
                EList providedInterfaces = ((CS_InteractionPoint)reference).definingPort.getProvideds();
                while (interfaceIndex <= providedInterfaces.size() && !isProvided) {
                    Interface interface_ = (Interface)providedInterfaces.get(interfaceIndex - 1);
                    Integer memberIndex = 1;
                    while (memberIndex <= interface_.getMembers().size() && !isProvided) {
                        NamedElement cddOperation = (NamedElement)interface_.getMembers().get(memberIndex - 1);
                        if (cddOperation instanceof Operation) {
                            isProvided = operation == cddOperation;
                        }
                        memberIndex = memberIndex + 1;
                    }
                    interfaceIndex = interfaceIndex + 1;
                }
                break block8;
            }
            List types = reference.getTypes();
            Integer typeIndex = 1;
            while (typeIndex <= types.size() && !isProvided) {
                if (types.get(typeIndex - 1) instanceof Class) {
                    Integer memberIndex = 1;
                    EList members = ((Class)types.get(typeIndex - 1)).getMembers();
                    while (memberIndex <= members.size() && !isProvided) {
                        NamedElement cddOperation = (NamedElement)members.get(memberIndex - 1);
                        if (cddOperation instanceof Operation) {
                            CS_DispatchOperationOfInterfaceStrategy strategy = new CS_DispatchOperationOfInterfaceStrategy();
                            isProvided = strategy.operationsMatch((Operation)cddOperation, operation);
                        }
                        memberIndex = memberIndex + 1;
                    }
                }
                typeIndex = typeIndex + 1;
            }
        }
        return isProvided;
    }

    public Boolean isOperationRequired(Reference reference, Operation operation) {
        boolean matches = false;
        if (reference instanceof CS_InteractionPoint) {
            Integer interfaceIndex = 1;
            EList requiredInterfaces = ((CS_InteractionPoint)reference).definingPort.getRequireds();
            while (interfaceIndex <= requiredInterfaces.size() && !matches) {
                Interface interface_ = (Interface)requiredInterfaces.get(interfaceIndex - 1);
                Integer memberIndex = 1;
                while (memberIndex <= interface_.getMembers().size() && !matches) {
                    NamedElement cddOperation = (NamedElement)interface_.getMembers().get(memberIndex - 1);
                    if (cddOperation instanceof Operation) {
                        matches = operation == cddOperation;
                    }
                    memberIndex = memberIndex + 1;
                }
                interfaceIndex = interfaceIndex + 1;
            }
        }
        return matches;
    }

    public CS_LinkKind getLinkKind(CS_Link link, CS_InteractionPoint interactionPoint) {
        if (!link.hasValueForAFeature((Value)interactionPoint).booleanValue()) {
            return CS_LinkKind.None;
        }
        CS_LinkKind kind = CS_LinkKind.ToInternal;
        List featureValues = link.getFeatureValues();
        Integer i = 1;
        while (i <= featureValues.size() && kind != CS_LinkKind.None) {
            FeatureValue value = (FeatureValue)featureValues.get(i - 1);
            if (value.values.isEmpty()) {
                kind = CS_LinkKind.None;
            } else {
                Object v = (Value)value.values.get(0);
                boolean vIsAValueForAFeatureOfContext = false;
                if (v.equals((Value)interactionPoint).booleanValue()) {
                    vIsAValueForAFeatureOfContext = true;
                } else if (v instanceof CS_InteractionPoint) {
                    v = ((CS_InteractionPoint)((Object)v)).owner;
                    vIsAValueForAFeatureOfContext = this.hasValueForAFeature((Value)v);
                } else {
                    vIsAValueForAFeatureOfContext = this.hasValueForAFeature((Value)v);
                }
                if (!vIsAValueForAFeatureOfContext) {
                    kind = CS_LinkKind.ToEnvironment;
                }
            }
            i = i + 1;
        }
        return kind;
    }

    public List<CS_Link> getLinks(CS_InteractionPoint interactionPoint) {
        List extensionalValues = this.locus.extensionalValues;
        Integer i = 1;
        ArrayList<CS_Link> connectorInstances = new ArrayList<CS_Link>();
        while (i <= extensionalValues.size()) {
            CS_Link link;
            ExtensionalValue value = (ExtensionalValue)extensionalValues.get(i - 1);
            if (value instanceof CS_Link && this.getLinkKind(link = (CS_Link)value, interactionPoint) != CS_LinkKind.None) {
                connectorInstances.add(link);
            }
            i = i + 1;
        }
        return connectorInstances;
    }

    public Boolean hasValueForAFeature(Value value) {
        List allFeatureValues = this.getFeatureValues();
        Integer i = 1;
        boolean isAValue = false;
        while (i <= allFeatureValues.size() && !isAValue) {
            FeatureValue featureValue = (FeatureValue)allFeatureValues.get(i - 1);
            if (!featureValue.values.isEmpty()) {
                List valuesForCurrentFeature = featureValue.values;
                Integer j = 1;
                while (j <= valuesForCurrentFeature.size() && !isAValue) {
                    isAValue = ((Value)featureValue.values.get(j - 1)).equals(value);
                    j = j + 1;
                }
            }
            i = i + 1;
        }
        return isAValue;
    }

    public void sendOut(SignalInstance signalInstance, Port onPort) {
        FeatureValue featureValue = this.getFeatureValue((StructuralFeature)onPort);
        List values = featureValue.values;
        ArrayList<Reference> potentialTargets = new ArrayList<Reference>();
        int i = 0;
        while (i < values.size()) {
            potentialTargets.add((Reference)values.get(i));
            ++i;
        }
        CS_RequestPropagationStrategy strategy = (CS_RequestPropagationStrategy)this.locus.factory.getStrategy("requestPropagation");
        List<Reference> targets = strategy.select(potentialTargets, (SemanticVisitor)new SendSignalActionActivation());
        int i2 = 0;
        while (i2 < targets.size()) {
            CS_InteractionPoint target = (CS_InteractionPoint)targets.get(i2);
            this.sendOut(signalInstance, target);
            ++i2;
        }
    }

    public Execution dispatchOut(Operation operation, Port onPort) {
        Execution execution = null;
        FeatureValue featureValue = this.getFeatureValue((StructuralFeature)onPort);
        List values = featureValue.values;
        ArrayList<Reference> potentialTargets = new ArrayList<Reference>();
        int i = 0;
        while (i < values.size()) {
            potentialTargets.add((Reference)values.get(i));
            ++i;
        }
        CS_RequestPropagationStrategy strategy = (CS_RequestPropagationStrategy)this.locus.factory.getStrategy("requestPropagation");
        List<Reference> targets = strategy.select(potentialTargets, (SemanticVisitor)new CallOperationActionActivation());
        if (targets.size() >= 1) {
            CS_InteractionPoint target = (CS_InteractionPoint)targets.get(0);
            execution = this.dispatchOut(operation, target);
        }
        return execution;
    }

    public Execution dispatchIn(Operation operation, Port onPort) {
        FeatureValue featureValue = this.getFeatureValue((StructuralFeature)onPort);
        List values = featureValue.values;
        Integer choice = ((ChoiceStrategy)this.locus.factory.getStrategy("choice")).choose(Integer.valueOf(featureValue.values.size())) - 1;
        CS_InteractionPoint interactionPoint = (CS_InteractionPoint)((Object)values.get(choice));
        return interactionPoint.dispatch(operation);
    }

    public void sendIn(SignalInstance signalInstance, Port onPort) {
        FeatureValue featureValue = this.getFeatureValue((StructuralFeature)onPort);
        List values = featureValue.values;
        ArrayList<Reference> potentialTargets = new ArrayList<Reference>();
        int i = 0;
        while (i < values.size()) {
            potentialTargets.add((Reference)values.get(i));
            ++i;
        }
        CS_RequestPropagationStrategy strategy = (CS_RequestPropagationStrategy)this.locus.factory.getStrategy("requestPropagation");
        List<Reference> targets = strategy.select(potentialTargets, (SemanticVisitor)new SendSignalActionActivation());
        int i2 = 0;
        while (i2 < targets.size()) {
            Reference target = targets.get(i2);
            target.send(signalInstance);
            ++i2;
        }
    }
}

