/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.ui.breakpoint.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.infra.core.Activator;
import org.eclipse.papyrus.moka.debug.MokaBreakpoint;
import org.eclipse.papyrus.moka.ui.breakpoint.handlers.MokaAbstractHandler;

public class ToggleBreakpointHandler
extends MokaAbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        EObject selectedElement = this.getSelectedElement();
        String selectedElementURI = EcoreUtil.getURI((EObject)selectedElement).toString();
        if (selectedElement != null) {
            IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
            IBreakpoint[] breakpoints = breakpointManager.getBreakpoints("org.eclipse.papyrus.moka");
            MokaBreakpoint alreadyDefinedBreakpoint = null;
            int i = 0;
            while (i < breakpoints.length && alreadyDefinedBreakpoint == null) {
                MokaBreakpoint breakpoint = (MokaBreakpoint)breakpoints[i];
                String eObjectOfBreakpointUri = null;
                try {
                    eObjectOfBreakpointUri = (String)breakpoint.getMarker().getAttribute("uri");
                }
                catch (CoreException e) {
                    Activator.log.error((Throwable)e);
                }
                if (eObjectOfBreakpointUri.equals(selectedElementURI)) {
                    alreadyDefinedBreakpoint = breakpoint;
                }
                ++i;
            }
            try {
                if (alreadyDefinedBreakpoint != null) {
                    breakpointManager.removeBreakpoint(alreadyDefinedBreakpoint, true);
                } else {
                    MokaBreakpoint breakpoint = new MokaBreakpoint();
                    breakpoint.toggleBreakpoint(selectedElement);
                    breakpointManager.addBreakpoint((IBreakpoint)breakpoint);
                }
            }
            catch (CoreException e) {
                Activator.log.error((Throwable)e);
            }
            return null;
        }
        return null;
    }
}

