/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.ui.launch;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.papyrus.infra.widgets.editors.TreeSelectorDialog;
import org.eclipse.papyrus.infra.widgets.providers.WorkspaceContentProvider;
import org.eclipse.papyrus.moka.ui.launch.MokaRunConfigurationTab;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class MokaProjectSelection
extends SelectionAdapter {
    private static final String DIALOG_NAME = "Please select an fUML model";
    protected transient Text projectSelection;
    protected transient IFile currentSelection;
    protected transient MokaRunConfigurationTab launchConfigTab;

    public MokaProjectSelection(Text projectSelection, MokaRunConfigurationTab tab) {
        this.projectSelection = projectSelection;
        this.launchConfigTab = tab;
    }

    public void widgetSelected(SelectionEvent event) {
        TreeSelectorDialog dialog = new TreeSelectorDialog(Display.getCurrent().getActiveShell());
        dialog.setTitle(DIALOG_NAME);
        dialog.setContentProvider((ITreeContentProvider)new WorkspaceContentProvider());
        dialog.setLabelProvider(WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider());
        if (this.currentSelection != null && this.currentSelection.exists()) {
            dialog.setInitialSelections((Object[])new IFile[]{this.currentSelection});
        }
        dialog.open();
        Object[] selection = dialog.getResult();
        if (dialog.getReturnCode() == 0 && selection.length > 0 && selection[0] instanceof IFile) {
            this.currentSelection = (IFile)selection[0];
            URI fileURI = URI.createPlatformResourceURI((String)this.currentSelection.getFullPath().toString(), (boolean)true);
            this.projectSelection.setText(fileURI.toString());
            if (this.launchConfigTab != null) {
                this.launchConfigTab.updateLaunchConfigurationDialog();
            }
        }
    }
}

