/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.ui.launch;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.core.Activator;
import org.eclipse.papyrus.moka.launch.MokaLaunchDelegate;
import org.eclipse.papyrus.moka.ui.launch.MokaExecutableElementSelection;
import org.eclipse.papyrus.moka.ui.launch.MokaExecutableSelectionComponent;
import org.eclipse.papyrus.moka.ui.launch.MokaProjectSelection;
import org.eclipse.papyrus.moka.ui.launch.MokaProjectSelectionComponent;
import org.eclipse.papyrus.moka.ui.launch.MokaTriggerComboPopulation;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public class MokaRunConfigurationTab
extends AbstractLaunchConfigurationTab {
    protected static String TAB_NAME = "Moka Main";
    protected Composite mainContainer;
    protected MokaProjectSelectionComponent projectSelectionComp;
    protected MokaExecutableSelectionComponent executableSelectionComp;
    protected Image image;

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            String init_uri = configuration.getAttribute(MokaLaunchDelegate.URI_ATTRIBUTE_NAME, "");
            if (!init_uri.equals("")) {
                this.projectSelectionComp.projectSelectionText.setText(init_uri);
                String init_fragment = configuration.getAttribute(MokaLaunchDelegate.FRAGMENT_ATTRIBUTE_NAME, "");
                this.executableSelectionComp.eligibleExecutableElement.selectByURIFragment(init_fragment);
            }
        }
        catch (CoreException e) {
            Activator.log.error((Throwable)e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(MokaLaunchDelegate.URI_ATTRIBUTE_NAME, this.projectSelectionComp.projectSelectionText.getText());
        EObject selected = (EObject)this.executableSelectionComp.eligibleExecutableElement.getSelected();
        if (selected != null) {
            configuration.setAttribute(MokaLaunchDelegate.FRAGMENT_ATTRIBUTE_NAME, selected.eResource().getURIFragment(selected));
        }
    }

    public void createControl(Composite parent) {
        this.mainContainer = new Composite(parent, 4);
        this.mainContainer.setLayout((Layout)new GridLayout());
        this.projectSelectionComp = new MokaProjectSelectionComponent(this.mainContainer, 4, "UML Model", 2);
        this.executableSelectionComp = new MokaExecutableSelectionComponent(this.mainContainer, 4, "Element to be executed", 2);
        MokaProjectSelection listener = new MokaProjectSelection(this.projectSelectionComp.projectSelectionText, this);
        MokaTriggerComboPopulation comboPopulationTrigger = new MokaTriggerComboPopulation(this.executableSelectionComp.eligibleExecutableElement);
        this.projectSelectionComp.projectSelectionButton.addSelectionListener((SelectionListener)listener);
        this.projectSelectionComp.projectSelectionText.addModifyListener((ModifyListener)comboPopulationTrigger);
        this.executableSelectionComp.eligibleExecutableElement.addSelectionListener((SelectionListener)new MokaExecutableElementSelection(this));
        this.setControl((Control)this.mainContainer);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void updateLaunchConfigurationDialog() {
        super.updateLaunchConfigurationDialog();
    }

    public String getName() {
        return TAB_NAME;
    }

    public Image getImage() {
        if (this.image == null) {
            this.image = new Image((Device)Display.getCurrent(), ((Object)((Object)this)).getClass().getResourceAsStream("/icons/moka_icon.png"));
        }
        return this.image;
    }
}

