/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.communication;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.papyrus.moka.communication.IMarshaler;
import org.eclipse.papyrus.moka.communication.event.Start_Event;
import org.eclipse.papyrus.moka.communication.event.isuspendresume.Resume_Event;
import org.eclipse.papyrus.moka.communication.event.isuspendresume.Suspend_Event;
import org.eclipse.papyrus.moka.communication.event.iterminate.Terminate_Event;
import org.eclipse.papyrus.moka.communication.reply.istackframe.GetVariables_Reply;
import org.eclipse.papyrus.moka.communication.reply.ithread.GetStackFrames_Reply;
import org.eclipse.papyrus.moka.communication.reply.ivalue.GetValueString_Reply;
import org.eclipse.papyrus.moka.communication.reply.ivariable.GetReferenceTypeName_Reply;
import org.eclipse.papyrus.moka.communication.reply.ivariable.GetValue_Reply;
import org.eclipse.papyrus.moka.communication.request.ibreakpointlistener.AddBreakpoint_Request;
import org.eclipse.papyrus.moka.communication.request.ibreakpointlistener.RemoveBreakpoint_Request;
import org.eclipse.papyrus.moka.communication.request.idisconnect.Disconnect_Request;
import org.eclipse.papyrus.moka.communication.request.istackframe.GetVariables_Request;
import org.eclipse.papyrus.moka.communication.request.isuspendresume.Resume_Request;
import org.eclipse.papyrus.moka.communication.request.isuspendresume.Suspend_Request;
import org.eclipse.papyrus.moka.communication.request.iterminate.Terminate_Request;
import org.eclipse.papyrus.moka.communication.request.ithread.GetStackFrames_Request;
import org.eclipse.papyrus.moka.communication.request.ivalue.GetValueString_Request;
import org.eclipse.papyrus.moka.communication.request.ivariable.GetReferenceTypeName_Request;
import org.eclipse.papyrus.moka.communication.request.ivariable.GetValue_Request;

public class Marshaller
implements IMarshaler {
    protected static IMarshaler eInstance = null;
    protected Map<String, Object> messages = new HashMap<String, Object>();

    public static synchronized IMarshaler getInstance() {
        if (eInstance == null) {
            eInstance = new Marshaller();
        }
        return eInstance;
    }

    public static void setMarshalerInstance(IMarshaler marshaller) {
        eInstance = marshaller;
    }

    private Marshaller() {
    }

    @Override
    public String start_event_marshal(Start_Event event) {
        String key = "event_start" + event.hashCode();
        this.messages.put(key, event);
        return key;
    }

    @Override
    public Start_Event start_event_unmarshal(String request) {
        Object evt = this.messages.get(request);
        this.messages.remove(request);
        return (Start_Event)evt;
    }

    @Override
    public String addBreakpoint_request_marshal(AddBreakpoint_Request request) {
        String key = "request_addBreakpoint" + request.hashCode();
        this.messages.put(key, request);
        return key;
    }

    @Override
    public AddBreakpoint_Request addBreakpoint_request_unmarshal(String request) {
        Object req = this.messages.get(request);
        this.messages.remove(request);
        return (AddBreakpoint_Request)req;
    }

    @Override
    public String removeBreakpoint_request_marshal(RemoveBreakpoint_Request request) {
        String key = "request_removeBreakpoint" + request.hashCode();
        this.messages.put(key, request);
        return key;
    }

    @Override
    public RemoveBreakpoint_Request removeBreakpoint_request_unmarshal(String request) {
        Object req = this.messages.get(request);
        this.messages.remove(request);
        return (RemoveBreakpoint_Request)req;
    }

    @Override
    public String disconnect_request_marshal(Disconnect_Request request) {
        String key = "request_disconnect" + request.hashCode();
        this.messages.put(key, request);
        return key;
    }

    @Override
    public Disconnect_Request disconnect_request_unmarshal(String request) {
        Object req = this.messages.get(request);
        this.messages.remove(request);
        return (Disconnect_Request)req;
    }

    @Override
    public String resume_request_marshal(Resume_Request request) {
        String key = "request_resume" + request.hashCode();
        this.messages.put(key, request);
        return key;
    }

    @Override
    public Resume_Request resume_request_unmarshal(String request) {
        Object req = this.messages.get(request);
        this.messages.remove(request);
        return (Resume_Request)req;
    }

    @Override
    public String resume_event_marshal(Resume_Event event) {
        String key = "event_resume" + event.hashCode();
        this.messages.put(key, event);
        return key;
    }

    @Override
    public Resume_Event resume_event_unmarshal(String event) {
        Object evt = this.messages.get(event);
        this.messages.remove(event);
        return (Resume_Event)evt;
    }

    @Override
    public String suspend_request_marshal(Suspend_Request request) {
        String key = "request_suspend" + request.hashCode();
        this.messages.put(key, request);
        return key;
    }

    @Override
    public Suspend_Request suspend_request_unmarshal(String request) {
        Object req = this.messages.get(request);
        this.messages.remove(request);
        return (Suspend_Request)req;
    }

    @Override
    public String suspend_event_marshal(Suspend_Event event) {
        String key = "event_suspend" + event.hashCode();
        this.messages.put(key, event);
        return key;
    }

    @Override
    public Suspend_Event suspend_event_unmarshal(String event) {
        Object evt = this.messages.get(event);
        this.messages.remove(event);
        return (Suspend_Event)evt;
    }

    @Override
    public String terminate_request_marshal(Terminate_Request request) {
        String key = "request_terminate" + request.hashCode();
        this.messages.put(key, request);
        return key;
    }

    @Override
    public Terminate_Request terminate_request_unmarshal(String request) {
        Object req = this.messages.get(request);
        this.messages.remove(request);
        return (Terminate_Request)req;
    }

    @Override
    public String terminate_event_marshal(Terminate_Event event) {
        String key = "event_terminate" + event.hashCode();
        this.messages.put(key, event);
        return key;
    }

    @Override
    public Terminate_Event terminate_event_unmarshal(String event) {
        Object evt = this.messages.get(event);
        this.messages.remove(event);
        return (Terminate_Event)evt;
    }

    @Override
    public String getStackFrames_request_marshal(GetStackFrames_Request request) {
        String key = "request_getStackFrames" + request.hashCode();
        this.messages.put(key, request);
        return key;
    }

    @Override
    public GetStackFrames_Request getStackFrames_request_unmarshal(String request) {
        Object req = this.messages.get(request);
        this.messages.remove(request);
        return (GetStackFrames_Request)req;
    }

    @Override
    public String getStackFrames_reply_marshal(GetStackFrames_Reply reply) {
        String key = "" + reply.hashCode();
        this.messages.put(key, reply);
        return key;
    }

    @Override
    public GetStackFrames_Reply getStackFrames_reply_unmarshal(String reply) {
        Object rep = this.messages.get(reply);
        this.messages.remove(reply);
        return (GetStackFrames_Reply)rep;
    }

    @Override
    public String getVariables_request_marshal(GetVariables_Request request) {
        String key = "request_getVariables" + request.hashCode();
        this.messages.put(key, request);
        return key;
    }

    @Override
    public GetVariables_Request getVariables_request_unmarshal(String request) {
        Object req = this.messages.get(request);
        this.messages.remove(request);
        return (GetVariables_Request)req;
    }

    @Override
    public String getVariables_reply_marshal(GetVariables_Reply reply) {
        String key = "" + reply.hashCode();
        this.messages.put(key, reply);
        return key;
    }

    @Override
    public GetVariables_Reply getVariables_reply_unmarshal(String reply) {
        Object rep = this.messages.get(reply);
        this.messages.remove(reply);
        return (GetVariables_Reply)rep;
    }

    @Override
    public String getValue_request_marshal(GetValue_Request request) {
        String key = "request_getValue" + request.hashCode();
        this.messages.put(key, request);
        return key;
    }

    @Override
    public GetValue_Request getValue_request_unmarshal(String request) {
        Object req = this.messages.get(request);
        this.messages.remove(request);
        return (GetValue_Request)req;
    }

    @Override
    public String getValue_reply_marshal(GetValue_Reply reply) {
        String key = "" + reply.hashCode();
        this.messages.put(key, reply);
        return key;
    }

    @Override
    public GetValue_Reply getValue_reply_unmarshal(String reply) {
        Object rep = this.messages.get(reply);
        this.messages.remove(reply);
        return (GetValue_Reply)rep;
    }

    @Override
    public String getReferenceTypeName_request_marshal(GetReferenceTypeName_Request request) {
        String key = "request_getReferenceTypeName" + request.hashCode();
        this.messages.put(key, request);
        return key;
    }

    @Override
    public GetReferenceTypeName_Request getReferenceTypeName_request_unmarshal(String request) {
        Object req = this.messages.get(request);
        this.messages.remove(request);
        return (GetReferenceTypeName_Request)req;
    }

    @Override
    public String getReferenceTypeName_reply_marshal(GetReferenceTypeName_Reply reply) {
        String key = "" + reply.hashCode();
        this.messages.put(key, reply);
        return key;
    }

    @Override
    public GetReferenceTypeName_Reply getReferenceTypeName_reply_unmarshal(String reply) {
        Object rep = this.messages.get(reply);
        this.messages.remove(reply);
        return (GetReferenceTypeName_Reply)rep;
    }

    @Override
    public String getValueString_request_marshal(GetValueString_Request request) {
        String key = "request_getValueString" + request.hashCode();
        this.messages.put(key, request);
        return key;
    }

    @Override
    public GetValueString_Request getValueString_request_unmarshal(String request) {
        Object req = this.messages.get(request);
        this.messages.remove(request);
        return (GetValueString_Request)req;
    }

    @Override
    public String getValueString_reply_marshal(GetValueString_Reply reply) {
        String key = "" + reply.hashCode();
        this.messages.put(key, reply);
        return key;
    }

    @Override
    public GetValueString_Reply getValueString_reply_unmarshal(String reply) {
        Object rep = this.messages.get(reply);
        this.messages.remove(reply);
        return (GetValueString_Reply)rep;
    }
}

