/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.debug;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.papyrus.moka.debug.MokaJobChangeListener;
import org.eclipse.papyrus.moka.engine.MokaExecutionEngineJob;

public class MokaProcess
extends PlatformObject
implements IProcess {
    protected ILaunch launch;
    protected MokaExecutionEngineJob job;
    protected int exitValue;
    protected String label;
    protected boolean isTerminated = false;
    protected Map<String, String> attributes;

    public MokaProcess(ILaunch launch, Job job, String label, Map<String, String> attributes) {
        this.launch = launch;
        this.initializeAttributes(attributes);
        this.job = (MokaExecutionEngineJob)job;
        this.job.addJobChangeListener(new MokaJobChangeListener(this));
        this.label = label;
        this.isTerminated = false;
        launch.addProcess((IProcess)this);
        this.fireCreationEvent();
    }

    protected void initializeAttributes(Map<String, String> attributes) {
        if (attributes != null) {
            for (String key : attributes.keySet()) {
                this.setAttribute(key, attributes.get(key));
            }
        }
    }

    public synchronized boolean canTerminate() {
        return !this.isTerminated;
    }

    public String getLabel() {
        return this.label;
    }

    public ILaunch getLaunch() {
        return this.launch;
    }

    public synchronized boolean isTerminated() {
        return this.isTerminated;
    }

    public void terminate() throws DebugException {
        if (!this.isTerminated() && this.job != null) {
            this.job.getDebugTarget().terminate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminated() {
        int exitValue = -1;
        boolean running = false;
        try {
            exitValue = this.job.getResult().getCode();
        }
        catch (IllegalThreadStateException ie) {
            running = true;
        }
        MokaProcess mokaProcess = this;
        synchronized (mokaProcess) {
            this.isTerminated = true;
            if (!running) {
                this.exitValue = exitValue;
            }
            this.job = null;
        }
        this.fireTerminateEvent();
    }

    public IStreamsProxy getStreamsProxy() {
        return null;
    }

    protected void fireCreationEvent() {
        this.fireEvent(new DebugEvent((Object)this, 4));
    }

    protected void fireEvent(DebugEvent event) {
        DebugPlugin manager = DebugPlugin.getDefault();
        if (manager != null) {
            manager.fireDebugEventSet(new DebugEvent[]{event});
        }
    }

    protected void fireTerminateEvent() {
        this.fireEvent(new DebugEvent((Object)this, 8));
    }

    protected void fireChangeEvent() {
        this.fireEvent(new DebugEvent((Object)this, 16));
    }

    public void setAttribute(String key, String value) {
        String origVal;
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>();
        }
        if ((origVal = this.attributes.get(key)) != null && origVal.equals(value)) {
            return;
        }
        this.attributes.put(key, value);
        this.fireChangeEvent();
    }

    public String getAttribute(String key) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(key);
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IProcess.class)) {
            return this;
        }
        if (adapter.equals(IDebugTarget.class)) {
            ILaunch launch = this.getLaunch();
            IDebugTarget[] targets = launch.getDebugTargets();
            int i = 0;
            while (i < targets.length) {
                if (((Object)((Object)this)).equals(targets[i].getProcess())) {
                    return targets[i];
                }
                ++i;
            }
            return null;
        }
        if (adapter.equals(ILaunch.class)) {
            return this.getLaunch();
        }
        if (adapter.equals(ILaunchConfiguration.class)) {
            return this.getLaunch().getLaunchConfiguration();
        }
        return super.getAdapter(adapter);
    }

    public synchronized int getExitValue() throws DebugException {
        if (this.isTerminated()) {
            return this.exitValue;
        }
        throw new DebugException((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), 5010, "Exit value not available until process terminates.", null));
    }
}

