/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.debug;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.moka.debug.MokaDebugElement;
import org.eclipse.papyrus.moka.debug.MokaDebugTarget;
import org.eclipse.papyrus.moka.debug.MokaThread;
import org.eclipse.papyrus.moka.debug.MokaVariable;

public class MokaStackFrame
extends MokaDebugElement
implements IStackFrame {
    protected EObject modelElement;
    protected MokaThread thread = null;
    protected MokaVariable[] variables = null;
    protected String name = null;
    protected IRegisterGroup[] registerGroups = null;

    public MokaStackFrame(MokaDebugTarget target) {
        super(target);
    }

    public void setModelElement(EObject modelElement) {
        this.modelElement = modelElement;
    }

    public EObject getModelElement() {
        return this.modelElement;
    }

    public IThread getThread() {
        return this.thread;
    }

    public void setThread(MokaThread thread) {
        this.thread = thread;
    }

    public IVariable[] getVariables() throws DebugException {
        if (this.variables != null) {
            return this.variables;
        }
        this.variables = this.debugTarget.getVariables(this);
        return this.variables;
    }

    public void setVariables(MokaVariable[] variables) {
        this.variables = variables != null ? variables : new MokaVariable[0];
    }

    public boolean hasVariables() throws DebugException {
        return this.getVariables().length > 0;
    }

    public int getLineNumber() throws DebugException {
        return -1;
    }

    public int getCharStart() throws DebugException {
        return -1;
    }

    public int getCharEnd() throws DebugException {
        return -1;
    }

    public String getName() throws DebugException {
        if (this.name != null) {
            return this.name;
        }
        return "";
    }

    public void setName(String name) {
        this.name = name != null ? name : "";
    }

    public IRegisterGroup[] getRegisterGroups() throws DebugException {
        if (this.registerGroups != null) {
            return this.registerGroups;
        }
        this.registerGroups = this.debugTarget.getRegisterGroups(this);
        return this.registerGroups;
    }

    public void setRegisterGroups(IRegisterGroup[] registerGroups) {
        this.registerGroups = registerGroups != null ? registerGroups : new IRegisterGroup[0];
    }

    public boolean hasRegisterGroups() throws DebugException {
        return this.getRegisterGroups().length > 0;
    }

    public boolean canStepInto() {
        return this.getThread().canStepInto();
    }

    public boolean canStepOver() {
        return this.getThread().canStepOver();
    }

    public boolean canStepReturn() {
        return this.getThread().canStepReturn();
    }

    public boolean isStepping() {
        return this.getThread().isStepping();
    }

    public void stepInto() throws DebugException {
        this.getThread().stepInto();
    }

    public void stepOver() throws DebugException {
        this.getThread().stepOver();
    }

    public void stepReturn() throws DebugException {
        this.getThread().stepReturn();
    }

    public boolean canResume() {
        return this.getThread().canResume();
    }

    public boolean canSuspend() {
        return this.getThread().canSuspend();
    }

    public boolean isSuspended() {
        return this.getThread().isSuspended();
    }

    public void resume() throws DebugException {
        this.getThread().resume();
    }

    public void suspend() throws DebugException {
        this.getThread().suspend();
    }

    public boolean canTerminate() {
        return this.getThread().canTerminate();
    }

    public boolean isTerminated() {
        return this.getThread().isTerminated();
    }

    public void terminate() throws DebugException {
        this.getThread().terminate();
    }
}

