/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.debug;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.papyrus.moka.debug.MokaBreakpoint;
import org.eclipse.papyrus.moka.debug.MokaDebugElement;
import org.eclipse.papyrus.moka.debug.MokaDebugTarget;

public class MokaThread
extends MokaDebugElement
implements IThread {
    protected IStackFrame[] stackFrames;
    protected MokaBreakpoint[] breakpoints = new MokaBreakpoint[0];
    protected int priority = 0;
    protected String name = null;
    protected boolean isSuspended = false;
    protected boolean isStepping = false;

    public MokaThread(MokaDebugTarget debugTarget) {
        super(debugTarget);
    }

    public IStackFrame[] getStackFrames() throws DebugException {
        if (this.stackFrames != null) {
            return this.stackFrames;
        }
        this.stackFrames = this.debugTarget.getStackFrames(this);
        return this.stackFrames;
    }

    public void setStackFrames(IStackFrame[] stackFrames) {
        this.stackFrames = stackFrames;
    }

    public boolean hasStackFrames() throws DebugException {
        return this.getStackFrames().length > 0;
    }

    public int getPriority() throws DebugException {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public IStackFrame getTopStackFrame() throws DebugException {
        if (this.hasStackFrames()) {
            return this.stackFrames[0];
        }
        return null;
    }

    public String getName() throws DebugException {
        if (this.name != null) {
            return this.name;
        }
        return "";
    }

    public void setName(String name) {
        this.name = name;
    }

    public IBreakpoint[] getBreakpoints() {
        if (!this.isSuspended) {
            return new IBreakpoint[0];
        }
        return this.breakpoints;
    }

    public void setBreakpoints(MokaBreakpoint[] breakpoints) {
        this.breakpoints = breakpoints != null ? breakpoints : new MokaBreakpoint[0];
    }

    public boolean canTerminate() {
        return this.debugTarget.canTerminate();
    }

    public boolean isTerminated() {
        return this.debugTarget.isTerminated();
    }

    public void terminate() throws DebugException {
        this.isStepping = false;
        this.debugTarget.terminate(this);
    }

    public boolean canResume() {
        return this.isSuspended();
    }

    public boolean canSuspend() {
        return !this.isSuspended();
    }

    public boolean isSuspended() {
        return this.isSuspended;
    }

    public void resume() throws DebugException {
        this.isSuspended = false;
        this.debugTarget.resume(this, 32);
    }

    public void suspend() throws DebugException {
        this.isSuspended = true;
        this.debugTarget.suspend(this, 32);
    }

    public void setSuspended(boolean isSuspended) {
        this.isSuspended = isSuspended;
    }

    public boolean canStepInto() {
        return this.isSuspended;
    }

    public boolean canStepOver() {
        return this.isSuspended;
    }

    public boolean canStepReturn() {
        return this.isSuspended;
    }

    public boolean isStepping() {
        return this.isStepping;
    }

    public void stepEnded() {
        this.isStepping = false;
    }

    public void stepInto() throws DebugException {
        this.isStepping = true;
        this.debugTarget.resume(this, 1);
    }

    public void stepOver() throws DebugException {
        this.isStepping = true;
        this.debugTarget.resume(this, 2);
    }

    public void stepReturn() throws DebugException {
        this.isStepping = true;
        this.debugTarget.resume(this, 4);
    }
}

