/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.notation.export;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.m2m.qvt.oml.BasicModelExtent;
import org.eclipse.m2m.qvt.oml.ExecutionContext;
import org.eclipse.m2m.qvt.oml.ExecutionContextImpl;
import org.eclipse.m2m.qvt.oml.ExecutionDiagnostic;
import org.eclipse.m2m.qvt.oml.ModelExtent;
import org.eclipse.m2m.qvt.oml.TransformationExecutor;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ExtensionServicesRegistry;
import org.eclipse.papyrus.notation.export.Activator;
import org.eclipse.papyrus.notation.export.Messages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.statushandlers.StatusManager;

public class ExportAllDiagrams {
    private IFile file;

    public ExportAllDiagrams(IFile file) {
        this.file = file;
    }

    public void export() {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                ExportAllDiagrams.this.export(monitor);
            }
        };
        UIJob job = new UIJob(Messages.ExportAllDiagrams_0, (IRunnableWithProgress)op){
            private final /* synthetic */ IRunnableWithProgress val$op;
            {
                this.val$op = iRunnableWithProgress;
                super($anonymous0);
            }

            public IStatus runInUIThread(IProgressMonitor monitor) {
                try {
                    this.val$op.run(monitor);
                }
                catch (InvocationTargetException e) {
                    Activator.getDefault().log(e);
                }
                catch (InterruptedException e) {
                    Activator.getDefault().log(e);
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    private void export(IProgressMonitor newMonitor) {
        newMonitor.beginTask(Messages.ExportAllDiagrams_1, 10);
        if (this.file != null) {
            ModelSet modelSet = null;
            try {
                ExtensionServicesRegistry registry = new ExtensionServicesRegistry("org.eclipse.papyrus.infra.core");
                registry.startServicesByClassKeys(new Class[]{ModelSet.class});
                modelSet = (ModelSet)registry.getService(ModelSet.class);
                modelSet.loadModels(URI.createPlatformResourceURI((String)this.file.getFullPath().toString(), (boolean)true));
                registry.startRegistry();
            }
            catch (Exception exception) {}
            if (modelSet == null) {
                return;
            }
            if (newMonitor.isCanceled()) {
                return;
            }
            ArrayList<Diagram> diagrams = new ArrayList<Diagram>();
            TransactionalEditingDomain domain = modelSet.getTransactionalEditingDomain();
            TreeIterator i = modelSet.getAllContents();
            while (i.hasNext()) {
                Notifier n = (Notifier)i.next();
                if (!(n instanceof Diagram)) continue;
                diagrams.add((Diagram)n);
            }
            if (newMonitor.isCanceled()) {
                return;
            }
            newMonitor.worked(2);
            this.export((IProgressMonitor)new SubProgressMonitor(newMonitor, 8), diagrams);
            this.unload((ResourceSet)modelSet);
            domain.dispose();
        }
        newMonitor.done();
    }

    private void unload(ResourceSet resourceSet) {
        for (Resource next : resourceSet.getResources()) {
            next.unload();
            next.eAdapters().clear();
        }
        resourceSet.getResources().clear();
        resourceSet.eAdapters().clear();
    }

    private void export(IProgressMonitor newMonitor, List<Diagram> diagrams) {
        newMonitor.beginTask(Messages.ExportAllDiagrams_4, 10);
        IStatus status = this.exportDiagrams((IProgressMonitor)new SubProgressMonitor(newMonitor, 9), diagrams);
        if (status != Status.OK_STATUS) {
            Activator.getDefault().getLog().log(status);
            StatusManager.getManager().handle(status, 4);
        } else {
            MessageDialog.openInformation((Shell)Activator.getActiveWorkbenchShell(), (String)Messages.ExportAllDiagrams_5, (String)Messages.ExportAllDiagrams_5);
        }
    }

    private IStatus exportDiagrams(IProgressMonitor newMonitor, List<Diagram> diagrams) {
        BasicModelExtent input = new BasicModelExtent(diagrams);
        BasicModelExtent output = new BasicModelExtent();
        ExecutionContextImpl context = new ExecutionContextImpl();
        context.setConfigProperty("keepModeling", (Object)true);
        URI transformationURI = URI.createURI((String)"platform:/plugin/org.eclipse.papyrus.notation2umldi/transforms/NotationToUmlDi.qvto");
        TransformationExecutor executor = new TransformationExecutor(transformationURI);
        ExecutionDiagnostic[] result = new ExecutionDiagnostic[]{executor.execute((ExecutionContext)context, new ModelExtent[]{input, output})};
        if (result[0] != null && result[0].getSeverity() != 0) {
            return BasicDiagnostic.toIStatus((Diagnostic)result[0]);
        }
        try {
            List outObjects = output.getContents();
            ResourceSetImpl outResourceSet = new ResourceSetImpl();
            Resource outResource = outResourceSet.createResource(URI.createPlatformResourceURI((String)this.file.getFullPath().toString(), (boolean)true).trimFileExtension().appendFileExtension("umldi"));
            outResource.getContents().addAll((Collection)outObjects);
            outResource.save(Collections.emptyMap());
            return Status.OK_STATUS;
        }
        catch (IOException e) {
            return new Status(4, "org.eclipse.papyrus.notation.export", e.getMessage());
        }
    }
}

