/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.notation.export.wizards;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.ui.dialogs.WorkspaceResourceDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.papyrus.notation.export.wizards.Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ExportAllDiagramsPage
extends WizardPage {
    private Text filePath;
    private IFile file;

    public ExportAllDiagramsPage(IFile file) {
        super(Messages.ExportDiagramsPage_Title);
        this.setTitle(Messages.ExportDiagramsPage_Title);
        this.setDescription(Messages.ExportDiagramsPage_Desc);
        this.file = file;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.horizontalSpacing = 0;
        container.setLayout((Layout)layout);
        this.setControl((Control)container);
        Label label = new Label(container, 0);
        label.setText(Messages.ExportDiagramsPage_InputModelFile);
        this.filePath = new Text(container, 2052);
        this.filePath.setLayoutData((Object)new GridData(768));
        this.filePath.setEditable(false);
        this.filePath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportAllDiagramsPage.this.dialogChanged();
            }
        });
        if (this.file != null) {
            this.filePath.setText(this.file.getFullPath().toString());
        } else {
            this.dialogChanged();
        }
        Button loadButton = new Button(container, 8);
        loadButton.setText("Browse...");
        loadButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                IFile[] f;
                WorkspaceResourceDialog dialog = new WorkspaceResourceDialog(ExportAllDiagramsPage.this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new BaseWorkbenchContentProvider());
                dialog.setTitle("Tree Selection");
                dialog.setMessage("Select the elements from the tree:");
                dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
                dialog.setAllowMultiple(false);
                if (dialog.open() == 0 && (f = dialog.getSelectedFiles()).length > 0) {
                    ExportAllDiagramsPage.this.file = f[0];
                    ExportAllDiagramsPage.this.filePath.setText(ExportAllDiagramsPage.this.file.getFullPath().toString());
                }
            }
        });
    }

    private void dialogChanged() {
        String f = this.filePath.getText();
        if (f.length() == 0 || !f.endsWith("di")) {
            this.updateStatus(Messages.ExportDiagramsPage_InvalidFile);
            return;
        }
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public IFile getFile() {
        return this.file;
    }
}

