/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.qompass.designer.ui.dialogs;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.papyrus.FCM.ConfigOption;
import org.eclipse.papyrus.FCM.ContainerRule;
import org.eclipse.papyrus.qompass.designer.ui.dialogs.ConfigOptionLabelProvider;
import org.eclipse.papyrus.uml.profile.ui.dialogs.AlphabeticalViewerSorter;
import org.eclipse.papyrus.uml.profile.ui.dialogs.ChooseSetAssistedDialog;
import org.eclipse.papyrus.uml.profile.ui.dialogs.IChooseDialog;
import org.eclipse.papyrus.uml.properties.profile.ui.dialogs.StereotypeQualifiedLabelProvider;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;

public class ChooseConfigOpt
extends ChooseSetAssistedDialog
implements IChooseDialog {
    protected EList<Package> visitedPackages;
    private final StereotypeQualifiedLabelProvider qualifiedLabelProvider = new StereotypeQualifiedLabelProvider();

    public ChooseConfigOpt(Shell parentShell, Package model, ContainerRule rule) {
        super(parentShell, "Available configuration options: ", "Applied configuration options: ");
        this.labelProvider = new ConfigOptionLabelProvider();
        this.decoratedContentProposalProvider = new ConfigOptContentProposalProvider();
        for (ConfigOption option : rule.getForConfig()) {
            this.selectedElementList.addElement((Object)option.getBase_Class());
        }
        this.visitedPackages = new BasicEList();
        BasicEList configOptList = new BasicEList();
        this.getAvailConfigOpts(model, (EList<Class>)configOptList);
        for (Class current : configOptList) {
            if (this.selectedElementList.contains((Object)current)) continue;
            this.possibleElementList.addElement((Object)current);
        }
    }

    private void getAvailConfigOpts(Package pkg, EList<Class> configOptList) {
        for (Element el : pkg.getMembers()) {
            if (el instanceof Package) {
                if (this.visitedPackages.contains((Object)el)) continue;
                this.visitedPackages.add((Object)((Package)el));
                this.getAvailConfigOpts((Package)el, configOptList);
                continue;
            }
            if (!(el instanceof Class) || !StereotypeUtil.isApplied((Element)el, ConfigOption.class)) continue;
            configOptList.add((Object)((Class)el));
        }
    }

    protected Control createDialogArea(Composite parent) {
        Control composite = super.createDialogArea(parent);
        this.possibleElementsTable.setHeaderVisible(true);
        TableColumn column = new TableColumn(this.possibleElementsTable, 0x1000000, 0);
        column.setText("Option");
        column.setWidth(100);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChooseConfigOpt.this.possibleElementsTableViewer.setSorter((ViewerSorter)new AlphabeticalViewerSorter(0));
            }
        });
        column = new TableColumn(this.possibleElementsTable, 16384, 1);
        column.setText("Information");
        column.setWidth(165);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChooseConfigOpt.this.possibleElementsTableViewer.setSorter((ViewerSorter)new AlphabeticalViewerSorter(1));
            }
        });
        this.possibleElementsTableViewer.setSorter((ViewerSorter)new AlphabeticalViewerSorter(0));
        return composite;
    }

    protected void runAddElement(String name) {
        Class option = null;
        for (Object possibleElement : this.possibleElementList.getElements()) {
            Class element = (Class)possibleElement;
            if (!name.equalsIgnoreCase(element.getName()) && !name.equalsIgnoreCase(element.getQualifiedName())) continue;
            option = element;
        }
        if (option != null) {
            this.runActionAdd(option);
        }
    }

    protected boolean isSelectableElement(String text) {
        for (Object possibleElement : this.possibleElementList.getElements()) {
            Class element = (Class)possibleElement;
            if (!text.equalsIgnoreCase(element.getName()) && !text.equalsIgnoreCase(element.getQualifiedName())) continue;
            return true;
        }
        return false;
    }

    public class ConfigOptContentProposalProvider
    extends ChooseSetAssistedDialog.DecoratedContentProposalProvider {
        public ConfigOptContentProposalProvider() {
            super((ChooseSetAssistedDialog)ChooseConfigOpt.this);
        }

        public ChooseSetAssistedDialog.DecoratedContentProposal[] getProposals(String contents, int position) {
            ArrayList<ChooseSetAssistedDialog.DecoratedContentProposal> proposals = new ArrayList<ChooseSetAssistedDialog.DecoratedContentProposal>();
            if (ChooseConfigOpt.this.possibleElementList != null) {
                for (Object configOptObj : ChooseConfigOpt.this.possibleElementList.getElements()) {
                    Class configOpt = (Class)configOptObj;
                    String simpleName = configOpt.getName();
                    String qualifiedName = configOpt.getQualifiedName();
                    if (position < simpleName.length() && contents.substring(0, position).equalsIgnoreCase(simpleName.substring(0, position))) {
                        proposals.add(new ChooseSetAssistedDialog.DecoratedContentProposal((ChooseSetAssistedDialog)ChooseConfigOpt.this, (Object)configOpt, ChooseConfigOpt.this.labelProvider));
                    }
                    if (position >= qualifiedName.length() || !contents.substring(0, position).equalsIgnoreCase(qualifiedName.substring(0, position))) continue;
                    proposals.add(new ChooseSetAssistedDialog.DecoratedContentProposal((ChooseSetAssistedDialog)ChooseConfigOpt.this, (Object)configOpt, (LabelProvider)ChooseConfigOpt.this.qualifiedLabelProvider));
                }
            }
            Collections.sort(proposals);
            return proposals.toArray(new ChooseSetAssistedDialog.DecoratedContentProposal[proposals.size()]);
        }
    }
}

