/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.qompass.designer.ui.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.qompass.designer.core.CommandSupport;
import org.eclipse.papyrus.qompass.designer.core.Utils;
import org.eclipse.papyrus.qompass.designer.core.deployment.DepCreation;
import org.eclipse.papyrus.qompass.designer.core.transformations.TransformationException;
import org.eclipse.papyrus.qompass.designer.core.transformations.TransformationRTException;
import org.eclipse.papyrus.uml.diagram.common.handlers.CmdHandler;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;

public class CreatePlatformHandler
extends CmdHandler {
    private Package platform;

    public boolean isEnabled() {
        this.updateSelectedEObject();
        return this.selectedEObject instanceof Class;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (!(this.selectedEObject instanceof Class)) {
            return null;
        }
        final Class selectedComposite = (Class)this.selectedEObject;
        CommandSupport.exec((String)"Create platform model", (ExecutionEvent)event, (Runnable)new Runnable(){

            @Override
            public void run() {
                CreatePlatformHandler.this.platform = Utils.getRoot((Element)selectedComposite, (String)"platform");
            }
        });
        final String newPlatform = String.valueOf(selectedComposite.getName()) + "Platform";
        try {
            if (this.platform.getMember(newPlatform) != null) {
                Shell shell = Display.getDefault().getActiveShell();
                MessageDialog.openInformation((Shell)shell, (String)"Error", (String)("Platform definition \"" + newPlatform + "\" exists already"));
            } else {
                CommandSupport.exec((String)"Create platform definition", (ExecutionEvent)event, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Package platformPkg = CreatePlatformHandler.this.platform.createNestedPackage(newPlatform);
                        try {
                            DepCreation.createPlatformInstances((Package)platformPkg, (Class)selectedComposite, null);
                        }
                        catch (TransformationException e) {
                            throw new TransformationRTException(e.getMessage());
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

