/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.qompass.designer.validation.constraints;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.papyrus.FCM.DerivedElement;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;

public class OperationsWithTwoReturnValues
extends AbstractModelConstraint {
    public IStatus validate(IValidationContext ctx) {
        Operation operation = (Operation)ctx.getTarget();
        boolean firstReturn = true;
        for (Parameter parameter : operation.getOwnedParameters()) {
            if (parameter.getDirection() != ParameterDirectionKind.RETURN_LITERAL) continue;
            if (firstReturn) {
                firstReturn = false;
                continue;
            }
            if (!StereotypeUtil.isApplicable((Element)operation, DerivedElement.class)) break;
            return ctx.createFailureStatus(new Object[]{"The operation '" + operation.getName() + "' has more than one return parameter. It must have at most one"});
        }
        return ctx.createSuccessStatus();
    }
}

