/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.qompass.designer.vsl;

import com.google.inject.Injector;
import java.io.InputStream;
import java.util.Collections;
import org.eclipse.emf.common.util.URI;
import org.eclipse.papyrus.MARTE.utils.MarteUtils;
import org.eclipse.papyrus.MARTE_Library.MeasurementUnits.DataSizeUnitKind;
import org.eclipse.papyrus.MARTE_Library.MeasurementUnits.FrequencyUnitKind;
import org.eclipse.papyrus.MARTE_Library.MeasurementUnits.TimeUnitKind;
import org.eclipse.papyrus.marte.vsl.VSLStandaloneSetupGenerated;
import org.eclipse.papyrus.qompass.designer.vsl.Messages;
import org.eclipse.xtext.IGrammarAccess;
import org.eclipse.xtext.resource.IResourceFactory;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.StringInputStream;

public class ParseVSL {
    private static final String UNIT = "unit";
    private static final String VALUE = "value";
    private Injector injector;
    private static final String SYNTHETIC_SCHEME = "synthetic";

    public XtextResource getXtextResource(String expression) {
        if (this.injector == null) {
            VSLStandaloneSetupGenerated setup = new VSLStandaloneSetupGenerated();
            this.injector = setup.createInjectorAndDoEMFRegistration();
        }
        IResourceFactory resourceFactory = (IResourceFactory)this.injector.getInstance(IResourceFactory.class);
        IGrammarAccess grammarAccess = (IGrammarAccess)this.injector.getInstance(IGrammarAccess.class);
        XtextResource xtextResource = (XtextResource)resourceFactory.createResource(URI.createURI((String)("synthetic:/" + grammarAccess.getGrammar().getName() + ".vsl")));
        try {
            xtextResource.load((InputStream)new StringInputStream(expression, xtextResource.getEncoding()), Collections.emptyMap());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return xtextResource;
    }

    public static void parseTest(String expression) {
    }

    public static int getSizeFromVSL(String nfpDatasize) {
        if (nfpDatasize != null) {
            String unit = MarteUtils.getValueFromTuple((String)nfpDatasize, (String)UNIT);
            String value = MarteUtils.getValueFromTuple((String)nfpDatasize, (String)VALUE);
            return Float.valueOf(value).intValue() * ParseVSL.getMultiplicatorFromSizeUnit(unit);
        }
        return 0;
    }

    public static long getDurationFromVSL(String nfpDuration) {
        if (nfpDuration != null) {
            String unit = MarteUtils.getValueFromTuple((String)nfpDuration, (String)UNIT);
            String value = MarteUtils.getValueFromTuple((String)nfpDuration, (String)VALUE);
            return (long)Float.valueOf(value).intValue() * ParseVSL.getMultiplicatorFromTimeUnit(unit);
        }
        return 0L;
    }

    public static long getFrequencyFromVSL(String nfpFrequency) {
        if (nfpFrequency != null) {
            String unit = MarteUtils.getValueFromTuple((String)nfpFrequency, (String)UNIT);
            String value = MarteUtils.getValueFromTuple((String)nfpFrequency, (String)VALUE);
            return (int)(Float.valueOf(value).floatValue() * ParseVSL.getMultiplicatorFromFrequencyUnit(unit));
        }
        return 0L;
    }

    public static long getPeriodFromArrivalPattern(String arrivalPattern) {
        if (arrivalPattern != null) {
            String period = MarteUtils.getValueFromTuple((String)arrivalPattern, (String)"period");
            return ParseVSL.getDurationFromVSL(period);
        }
        return 0L;
    }

    public static int getMultiplicatorFromSizeUnit(String unit) {
        DataSizeUnitKind dsuk = DataSizeUnitKind.get((String)unit);
        if (dsuk == DataSizeUnitKind.BYTE) {
            return 1;
        }
        if (dsuk == DataSizeUnitKind.KB) {
            return 1024;
        }
        if (dsuk == DataSizeUnitKind.MB) {
            return 0x100000;
        }
        if (dsuk == DataSizeUnitKind.GB) {
            return 0x40000000;
        }
        throw new RuntimeException(String.format(Messages.ParseVSL_ErrorInExp_SIZE, unit));
    }

    public static long getMultiplicatorFromTimeUnit(String unit) {
        TimeUnitKind tuk = TimeUnitKind.get((String)unit);
        if (tuk == TimeUnitKind.US) {
            return 1L;
        }
        if (tuk == TimeUnitKind.MS) {
            return 1000L;
        }
        if (tuk == TimeUnitKind.S) {
            return 1000000L;
        }
        if (tuk == TimeUnitKind.MIN) {
            return 60000000L;
        }
        throw new RuntimeException(String.format(Messages.ParseVSL_ErrorInExp_TIME, unit));
    }

    public static float getMultiplicatorFromFrequencyUnit(String unit) {
        FrequencyUnitKind fuk = FrequencyUnitKind.get((String)unit);
        if (fuk == FrequencyUnitKind.HZ) {
            return 1.0f;
        }
        if (fuk == FrequencyUnitKind.KHZ) {
            return 1000.0f;
        }
        if (fuk == FrequencyUnitKind.MHZ) {
            return 1000000.0f;
        }
        if (fuk == FrequencyUnitKind.GHZ) {
            return 1.0E9f;
        }
        if (fuk == FrequencyUnitKind.RPM) {
            return 0.0f;
        }
        throw new RuntimeException(String.format(Messages.ParseVSL_ErrotInExp_FREQ, unit));
    }
}

