/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.qompass.modellibs.tracing;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.FCM.ConfigOption;
import org.eclipse.papyrus.FCM.ContainerRule;
import org.eclipse.papyrus.FCM.RuleApplication;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.utils.ServiceUtilsForActionHandlers;
import org.eclipse.papyrus.infra.services.tracepoints.ITraceMechanism;
import org.eclipse.papyrus.infra.services.tracepoints.MarkerUtils;
import org.eclipse.papyrus.infra.services.tracepoints.TraceActions;
import org.eclipse.papyrus.qompass.designer.core.Description;
import org.eclipse.papyrus.qompass.designer.core.Log;
import org.eclipse.papyrus.qompass.designer.core.Utils;
import org.eclipse.papyrus.uml.tools.utils.PackageUtil;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;

public class QompassTraceMechanism
implements ITraceMechanism {
    public static final String EC3M_TRACING_URI = "pathmap://QML_TRACE/tracing.uml";
    public static final URI tracingURI = URI.createURI((String)"pathmap://QML_TRACE/tracing.uml");

    public EList<String> getTraceMechanismIDs(EObject eObj) {
        BasicEList ids = new BasicEList();
        EList<ContainerRule> containerRules = this.getContainerRules(eObj);
        for (ContainerRule containerRule : containerRules) {
            if (!this.isForTracing(containerRule)) continue;
            Class clazz = containerRule.getBase_Class();
            ids.add((Object)clazz.getName());
        }
        if (ids.size() == 0) {
            ids.add((Object)"dummy qompass rule");
        }
        return ids;
    }

    public String getTraceMechanismDescription(EObject eObj, String id) {
        EList<ContainerRule> containerRules = this.getContainerRules(eObj);
        for (ContainerRule containerRule : containerRules) {
            Class clazz;
            if (!this.isForTracing(containerRule) || !(clazz = containerRule.getBase_Class()).getName().equals(id)) continue;
            return Description.getDescription((Element)clazz);
        }
        return null;
    }

    public boolean applyTraceMechanism(EObject eObj, String id, int traceOption) {
        Class clazzContext = this.getClassContext(eObj);
        if (clazzContext == null) {
            return false;
        }
        EList<ContainerRule> containerRules = this.getContainerRules(eObj);
        for (ContainerRule containerRule : containerRules) {
            Class clazz;
            if (!this.isForTracing(containerRule) || !(clazz = containerRule.getBase_Class()).getName().equals(id)) continue;
            TraceActions.TAOperation.OnlyCall.ordinal();
            RuleApplication ruleApplication = (RuleApplication)StereotypeUtil.applyApp((Element)clazzContext, RuleApplication.class);
            if (ruleApplication == null || ruleApplication.getContainerRule().contains((Object)containerRule)) continue;
            ruleApplication.getContainerRule().add((Object)containerRule);
            return true;
        }
        return false;
    }

    public boolean isForTracing(ContainerRule rule) {
        for (ConfigOption co : rule.getForConfig()) {
            if (!co.getBase_Class().getName().equals("Trace")) continue;
            return true;
        }
        return false;
    }

    public Class getClassContext(EObject eObj) {
        if (eObj instanceof Class) {
            return (Class)eObj;
        }
        if (eObj instanceof Operation) {
            return ((Operation)eObj).getClass_();
        }
        if (eObj instanceof Property) {
            return ((Property)eObj).getClass_();
        }
        return null;
    }

    public EList<ContainerRule> getContainerRules(EObject eObj) {
        if (eObj == null) {
            try {
                ModelSet ms = ServiceUtilsForActionHandlers.getInstance().getModelSet();
                Resource rs = ms.getResource(tracingURI, true);
                EList contents = rs.getContents();
                if (contents.size() > 0 && contents.get(0) instanceof Package) {
                    return Utils.getAllRules((Package)((Package)contents.get(0)));
                }
            }
            catch (ServiceException e) {
                Log.log((int)4, (int)2, (String)e.getMessage());
            }
            return new BasicEList();
        }
        Package top = PackageUtil.getRootPackage((Element)((Element)eObj));
        return Utils.getAllRules((Package)top);
    }

    public boolean configureTraceMechanisms() {
        String config = "";
        try {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            if (root != null) {
                IMarker[] tracePoints;
                IMarker[] iMarkerArray = tracePoints = root.findMarkers("org.eclipse.papyrus.tporbpmarker", true, 2);
                int n = tracePoints.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarker tracePointObj = iMarkerArray[n2];
                    if (tracePointObj instanceof IMarker) {
                        IMarker tracePoint = tracePointObj;
                        EObject eobj = MarkerUtils.getEObjectOfMarker((IMarker)tracePoint);
                        if (MarkerUtils.isActive((IMarker)tracePoint) && eobj instanceof NamedElement) {
                            config = String.valueOf(config) + ((NamedElement)eobj).getQualifiedName();
                        }
                    }
                    ++n2;
                }
            }
        }
        catch (CoreException e) {
            Log.log((int)4, (int)2, (String)e.getMessage());
        }
        return true;
    }
}

