/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.req.domainModel2Profile.generator;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.req.domainModel2Profile.utils.Utils;
import org.eclipse.papyrus.req.sysml.preferences.Activator;
import org.eclipse.uml2.uml.Abstraction;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.resources.util.UMLResourcesUtil;

public class ProfileGenerator {
    protected static ResourceSet resourceSet;
    protected Profile profile;
    protected Package sourcePackage;
    protected File sourceModelFile;
    private static String NSURI_PREFIX;
    private static boolean GENERATE_ABSTRACTIONS_MODEL;
    private static boolean FROM_ASSOCIATIONS_TO_STEREOTYPES;
    private static boolean FROM_ASSOCIATIONS_TO_ASSOCIATIONS;
    private static String METACLASS_EXTENDED_BY_NODES;
    private static String METACLASS_EXTENDED_BY_EDGES;
    private static boolean DEBUG;
    protected Stereotype baseNodeStereotype;
    protected Stereotype baseEdgeStereotype;
    protected Map<Element, Element> mapClassNodes = new HashMap<Element, Element>();
    protected Map<Element, Element> mapAssociationsEdges = new HashMap<Element, Element>();
    protected Map<Element, Element> mapProfileAssociations2MMAssociations = new HashMap<Element, Element>();
    protected Map<Element, Element> mapPrimitiveTypesNodes = new HashMap<Element, Element>();
    protected Map<Element, Element> mapEnumerationsNodes = new HashMap<Element, Element>();
    protected Map<Element, Element> mapPackagesNodes = new HashMap<Element, Element>();
    protected List<PrimitiveType> listStandardPrimitiveTypes = new ArrayList<PrimitiveType>();
    protected String outputDirectoryPath;
    protected List<Generalization> listInternalGeneralizations = new ArrayList<Generalization>();
    protected List<Association> listAssociations = new ArrayList<Association>();
    protected Model abstractionsModel;

    static {
        NSURI_PREFIX = "https://www.eclipse.org/papyrus/";
        GENERATE_ABSTRACTIONS_MODEL = false;
        FROM_ASSOCIATIONS_TO_STEREOTYPES = false;
        FROM_ASSOCIATIONS_TO_ASSOCIATIONS = false;
        METACLASS_EXTENDED_BY_NODES = "none";
        METACLASS_EXTENDED_BY_EDGES = "none";
        DEBUG = true;
    }

    public ProfileGenerator(Package selectedPackage) {
        DEBUG = false;
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        NSURI_PREFIX = store.getString("NSURI_PREFIX");
        GENERATE_ABSTRACTIONS_MODEL = store.getBoolean("GENERATE_ABSTRACTIONS_MODEL");
        FROM_ASSOCIATIONS_TO_STEREOTYPES = store.getBoolean("FROM_ASSOCIATIONS_TO_STEREOTYPES");
        FROM_ASSOCIATIONS_TO_ASSOCIATIONS = store.getBoolean("FROM_ASSOCIATIONS_TO_ASSOCIATIONS");
        this.sourcePackage = selectedPackage;
        URI uri = this.sourcePackage.eResource().getURI();
        this.sourceModelFile = Utils.getFileFromURI(uri);
        this.outputDirectoryPath = this.sourceModelFile.getParent();
        this.setResourceSet();
    }

    public ProfileGenerator(String _inputModelPath, String _outputDirectoryPath, String _prefix) {
        DEBUG = true;
        NSURI_PREFIX = _prefix;
        ResourceSetImpl resourceSetSourceModel = new ResourceSetImpl();
        UMLResourcesUtil.init((ResourceSet)resourceSetSourceModel);
        URI _inputModelURI = URI.createFileURI((String)new File(_inputModelPath).getAbsolutePath());
        Resource r = resourceSetSourceModel.getResource(_inputModelURI, true);
        this.sourcePackage = (Package)EcoreUtil.getObjectByType((Collection)r.getContents(), (EClassifier)UMLPackage.Literals.PACKAGE);
        this.sourceModelFile = new File(_inputModelPath).getAbsoluteFile();
        this.outputDirectoryPath = new File(_outputDirectoryPath).getAbsolutePath();
        this.setResourceSet();
    }

    protected void setResourceSet() {
        resourceSet = new ResourceSetImpl();
        UMLResourcesUtil.init((ResourceSet)resourceSet);
    }

    public void generate() {
        String nameOfAbstractionsModel = String.valueOf(this.sourcePackage.getName()) + "_refinement";
        String nameOfProfile = this.sourcePackage.getName();
        this.setProfile(Utils.createProfile(nameOfProfile, String.valueOf(NSURI_PREFIX) + this.sourcePackage.getName()));
        if (!METACLASS_EXTENDED_BY_NODES.contentEquals("none")) {
            METACLASS_EXTENDED_BY_NODES = UMLPackage.Literals.CLASS.getName();
            this.baseNodeStereotype = Utils.createStereotype(this.profile, "baseNodeStereotype", true);
        }
        if (!METACLASS_EXTENDED_BY_EDGES.contentEquals("none")) {
            METACLASS_EXTENDED_BY_EDGES = UMLPackage.Literals.ASSOCIATION.getName();
            this.baseEdgeStereotype = Utils.createStereotype(this.profile, "baseEdgeStereotype", true);
        }
        this.visitPackagedElements((Element)this.sourcePackage);
        String[] requiredPrimitiveTypes = new String[]{"Boolean", "Real", "String", "Integer", "UnlimitedNatural"};
        this.createStandardPrimitiveTypes(requiredPrimitiveTypes);
        this.createProfiles(this.mapClassNodes);
        this.createProfiles(this.mapPrimitiveTypesNodes);
        this.createProfiles(this.mapEnumerationsNodes);
        if (FROM_ASSOCIATIONS_TO_STEREOTYPES) {
            this.createProfiles(this.mapAssociationsEdges);
        }
        if (FROM_ASSOCIATIONS_TO_ASSOCIATIONS) {
            this.createAssociations();
        }
        this.createEnumerationLiterals();
        this.createTagDefinitions();
        this.createInternalGeneralizations();
        if (!METACLASS_EXTENDED_BY_NODES.contentEquals("none") && ProfileGenerator.referenceMetaclass(this.profile, METACLASS_EXTENDED_BY_NODES) != null) {
            this.createGeneralizations(this.mapClassNodes.keySet(), this.baseNodeStereotype);
            Utils.createExtension(ProfileGenerator.referenceMetaclass(this.profile, METACLASS_EXTENDED_BY_NODES), this.baseNodeStereotype, false);
        }
        if (!METACLASS_EXTENDED_BY_EDGES.contentEquals("none") && ProfileGenerator.referenceMetaclass(this.profile, METACLASS_EXTENDED_BY_NODES) != null) {
            this.createGeneralizations(this.mapAssociationsEdges.keySet(), this.baseEdgeStereotype);
            Utils.createExtension(ProfileGenerator.referenceMetaclass(this.profile, METACLASS_EXTENDED_BY_EDGES), this.baseEdgeStereotype, false);
        }
        Utils.defineProfile(this.profile);
        for (Element element : this.mapPackagesNodes.keySet()) {
            if (!(element instanceof Profile)) continue;
            Utils.defineProfile((Profile)element);
        }
        this.save((Package)this.profile, this.outputDirectoryPath, nameOfProfile, "profile.uml");
        if (GENERATE_ABSTRACTIONS_MODEL) {
            this.abstractionsModel = Utils.createModel(nameOfAbstractionsModel);
            this.createAbstractionsModel(this.mapClassNodes);
            this.createAbstractionsModel(this.mapProfileAssociations2MMAssociations);
            this.abstractionsModel.setURI(String.valueOf(NSURI_PREFIX) + nameOfAbstractionsModel);
            this.save((Package)this.abstractionsModel, this.outputDirectoryPath, nameOfAbstractionsModel, "uml");
        }
        if (!DEBUG) {
            Utils.refreshProject(this.sourceModelFile);
        }
    }

    protected void createAssociations() {
        Stereotype targetEndInProfile = null;
        Stereotype sourceEndInProfile = null;
        for (Association assocInMM : this.listAssociations) {
            Property targetEndInMM = Utils.getTargetEnd(assocInMM);
            Property sourceEndInMM = Utils.getSourceEnd(assocInMM);
            targetEndInProfile = this.getStereotypeByName(targetEndInMM.getType().getName());
            sourceEndInProfile = this.getStereotypeByName(sourceEndInMM.getType().getName());
            if (targetEndInProfile == null) continue;
            Association assocInProfile = Utils.createAssociation((Type)sourceEndInProfile, true, AggregationKind.NONE_LITERAL, targetEndInMM.getName(), targetEndInMM.getLower(), targetEndInMM.getUpper(), (Type)targetEndInProfile, true, AggregationKind.NONE_LITERAL, sourceEndInMM.getName(), sourceEndInMM.getLower(), sourceEndInMM.getUpper());
            assocInProfile.setName(assocInMM.getName());
            this.mapProfileAssociations2MMAssociations.put((Element)assocInProfile, (Element)assocInMM);
        }
    }

    protected Stereotype getStereotypeByName(String stereotypeName) {
        Stereotype stereotype = null;
        for (Map.Entry<Element, Element> entry : this.mapClassNodes.entrySet()) {
            if (!(entry.getKey() instanceof Stereotype) || !(entry.getValue() instanceof Class) || !(stereotype = (Stereotype)entry.getKey()).getName().contentEquals(stereotypeName)) continue;
            return stereotype;
        }
        return null;
    }

    protected void createAbstractionsModel(Map<Element, Element> map) {
        for (Map.Entry<Element, Element> entry : map.entrySet()) {
            NamedElement key = (NamedElement)entry.getKey();
            NamedElement value = (NamedElement)entry.getValue();
            Abstraction _abstraction = UMLFactory.eINSTANCE.createAbstraction();
            _abstraction.getSuppliers().add((Object)key);
            _abstraction.getClients().add((Object)value);
            _abstraction.setName(String.valueOf(key.getName()) + "-" + value.getName());
            this.abstractionsModel.getPackagedElements().add((Object)_abstraction);
        }
    }

    protected void visitPackagedElements(Element element) {
        if (element instanceof Package) {
            Package packageInMetamodel = (Package)element;
            for (Element e : packageInMetamodel.getPackagedElements()) {
                this.visitPackagedElements(e);
            }
        } else if (element instanceof Class) {
            this.mapClassNodes.put((Element)Utils.createStereotype(this.profile, ((NamedElement)element).getName(), ((Class)element).isAbstract()), element);
            if (((Classifier)element).getGeneralizations() != null) {
                for (Generalization generalization : ((Classifier)element).getGeneralizations()) {
                    this.listInternalGeneralizations.add(generalization);
                }
            }
        } else if (element instanceof PrimitiveType) {
            this.mapPrimitiveTypesNodes.put((Element)Utils.createPrimitiveType((Package)this.profile, ((NamedElement)element).getName()), element);
        } else if (element instanceof Enumeration) {
            this.mapEnumerationsNodes.put((Element)Utils.createEnumeration((Package)this.profile, ((NamedElement)element).getName()), element);
        } else if (element instanceof Association) {
            if (FROM_ASSOCIATIONS_TO_STEREOTYPES) {
                this.mapAssociationsEdges.put((Element)Utils.createStereotype(this.profile, ((NamedElement)element).getName(), false), element);
            }
            this.listAssociations.add((Association)element);
        }
    }

    protected void createInternalGeneralizations() {
        for (Generalization generalizationInMM : this.listInternalGeneralizations) {
            Classifier specificInMM = generalizationInMM.getSpecific();
            Classifier generalInMM = generalizationInMM.getGeneral();
            Stereotype specificInProfile = null;
            Stereotype generalInProfile = null;
            Set<Element> classNodesStereotypesInProfile = this.mapClassNodes.keySet();
            for (Element e : classNodesStereotypesInProfile) {
                Stereotype classNodeStereotypeInProfile = (Stereotype)e;
                if (classNodeStereotypeInProfile.getName().contentEquals(specificInMM.getName())) {
                    specificInProfile = classNodeStereotypeInProfile;
                    continue;
                }
                if (!classNodeStereotypeInProfile.getName().contentEquals(generalInMM.getName())) continue;
                generalInProfile = classNodeStereotypeInProfile;
            }
            if (specificInProfile == null || generalInProfile == null) continue;
            Utils.createGeneralization(specificInProfile, generalInProfile);
        }
    }

    protected static Package load(URI uri) {
        Package package_ = null;
        try {
            Resource resource = resourceSet.getResource(uri, true);
            package_ = (Package)EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)UMLPackage.Literals.PACKAGE);
        }
        catch (WrappedException we) {
            System.err.println();
            System.exit(1);
        }
        return package_;
    }

    public static PrimitiveType importPrimitiveType(Package package_, String name) {
        Package umlLibrary = ProfileGenerator.load(URI.createURI((String)"pathmap://UML_LIBRARIES/UMLPrimitiveTypes.library.uml"));
        PrimitiveType primitiveType = (PrimitiveType)umlLibrary.getOwnedType(name);
        package_.createElementImport((PackageableElement)primitiveType);
        return primitiveType;
    }

    protected static Class referenceMetaclass(Profile profile, String metaclassName) {
        Model umlMetamodel = (Model)ProfileGenerator.load(URI.createURI((String)"pathmap://UML_METAMODELS/UML.metamodel.uml"));
        Class metaclass = null;
        if (umlMetamodel.getOwnedType(metaclassName) instanceof Class && (metaclass = (Class)umlMetamodel.getOwnedType(metaclassName)) != null) {
            profile.createMetaclassReference((PackageableElement)metaclass);
        }
        return metaclass;
    }

    protected void addEnumerationProperty(Stereotype stereotypeInProfile, Property propertyInClass) {
        Set<Element> enumerationsInProfile = this.mapEnumerationsNodes.keySet();
        for (Element e : enumerationsInProfile) {
            Enumeration enumerationInProfile = (Enumeration)e;
            if (!enumerationInProfile.getName().contentEquals(propertyInClass.getType().getName())) continue;
            Utils.createAttribute((Class)stereotypeInProfile, propertyInClass.getName(), (Type)enumerationInProfile, 0, 1, null);
        }
    }

    protected void addPrimitiveTypeProperty(Stereotype stereotypeInProfile, Property propertyInClass) {
        boolean foundStandardPrimitiveType = false;
        for (PrimitiveType standardPrimitiveType : this.listStandardPrimitiveTypes) {
            if (!standardPrimitiveType.getName().contentEquals(propertyInClass.getType().getName())) continue;
            foundStandardPrimitiveType = true;
            Utils.createAttribute((Class)stereotypeInProfile, propertyInClass.getName(), (Type)standardPrimitiveType, propertyInClass.getLower(), propertyInClass.getUpper(), null);
            break;
        }
        if (!foundStandardPrimitiveType) {
            Set<Element> primitiveTypesInProfile = this.mapPrimitiveTypesNodes.keySet();
            for (Element e : primitiveTypesInProfile) {
                PrimitiveType primitiveTypeInProfile = (PrimitiveType)e;
                if (!primitiveTypeInProfile.getName().contentEquals(propertyInClass.getType().getName())) continue;
                Utils.createAttribute((Class)stereotypeInProfile, propertyInClass.getName(), (Type)primitiveTypeInProfile, propertyInClass.getLower(), propertyInClass.getUpper(), null);
            }
        }
    }

    protected void createEnumerationLiterals() {
        for (Map.Entry<Element, Element> entry : this.mapEnumerationsNodes.entrySet()) {
            Element key = entry.getKey();
            Element value = entry.getValue();
            if (!(key instanceof Enumeration) || !(value instanceof Enumeration)) continue;
            Enumeration enumInProfile = (Enumeration)key;
            Enumeration enumInMetamodel = (Enumeration)value;
            for (EnumerationLiteral literalInMM : enumInMetamodel.getOwnedLiterals()) {
                Utils.createEnumerationLiteral(enumInProfile, literalInMM.getName().replaceAll("\\s", ""));
            }
        }
    }

    protected void createGeneralizations(Set<Element> specificStereotypes, Stereotype generalStereotype) {
        for (Element element : specificStereotypes) {
            Stereotype specificStereotype;
            if (!(element instanceof Stereotype) || (specificStereotype = (Stereotype)element).getGeneralizations().size() != 0) continue;
            Utils.createGeneralization((Classifier)specificStereotype, (Classifier)generalStereotype);
        }
    }

    protected void createProfiles(Map<Element, Element> map) {
        for (Map.Entry<Element, Element> entry : map.entrySet()) {
            Element key = entry.getKey();
            Element value = entry.getValue();
            Package package_ = value.getNearestPackage();
            boolean foundPackage = false;
            for (Package nestedPackage : this.profile.getNestedPackages()) {
                if (!nestedPackage.getName().contentEquals(package_.getName())) continue;
                foundPackage = true;
                nestedPackage.getPackagedElements().add((Object)((PackageableElement)key));
                break;
            }
            if (foundPackage) continue;
            Profile newSubProfile = Utils.createProfile(package_.getName(), String.valueOf(NSURI_PREFIX) + package_.getName());
            this.mapPackagesNodes.put((Element)newSubProfile, (Element)package_);
            this.profile.getNestedPackages().add((Object)newSubProfile);
            newSubProfile.getPackagedElements().add((Object)((PackageableElement)key));
        }
    }

    protected void createStandardPrimitiveTypes(String[] requiredPrimitiveTypes) {
        String[] stringArray = requiredPrimitiveTypes;
        int n = requiredPrimitiveTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String primitiveTypeName = stringArray[n2];
            this.listStandardPrimitiveTypes.add(ProfileGenerator.importPrimitiveType((Package)this.profile, primitiveTypeName));
            ++n2;
        }
    }

    protected void createTagDefinitions() {
        for (Map.Entry<Element, Element> entry : this.mapClassNodes.entrySet()) {
            Element key = entry.getKey();
            Element value = entry.getValue();
            if (!(key instanceof Stereotype) || !(value instanceof Class)) continue;
            Stereotype stereotypeInProfile = (Stereotype)key;
            Class classInMetamodel = (Class)value;
            for (Property propertyInClass : classInMetamodel.getOwnedAttributes()) {
                if (propertyInClass.getType() instanceof PrimitiveType) {
                    this.addPrimitiveTypeProperty(stereotypeInProfile, propertyInClass);
                    continue;
                }
                if (!(propertyInClass.getType() instanceof Enumeration)) continue;
                this.addEnumerationProperty(stereotypeInProfile, propertyInClass);
            }
        }
    }

    public Profile getProfile() {
        return this.profile;
    }

    protected void save(Package model, String outputDirectoryPath, String fileName, String fileExtension) {
        URI outputURI = URI.createFileURI((String)outputDirectoryPath).appendSegment(fileName).appendFileExtension(fileExtension);
        ProfileGenerator.save(model, outputURI);
    }

    protected static void save(Package package_, URI uri) {
        Resource resource = resourceSet.createResource(uri);
        resource.getContents().add((Object)package_);
        try {
            resource.save(null);
        }
        catch (IOException ioe) {
            System.err.println(ioe.getMessage());
        }
    }

    public void setProfile(Profile profile) {
        this.profile = profile;
    }
}

