/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.req.domainModel2Profile.utils;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Extension;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.LiteralBoolean;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;

public class Utils {
    public static Model createModel(String name) {
        Model model = UMLFactory.eINSTANCE.createModel();
        model.setName(name);
        return model;
    }

    public static void refreshProject(File file) {
        IProject iproject = ResourcesPlugin.getWorkspace().getRoot().getProject(file.getParentFile().getName());
        try {
            iproject.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public static Enumeration createEnumeration(Package package_, String name) {
        Enumeration enumeration = package_.createOwnedEnumeration(name);
        return enumeration;
    }

    public static EnumerationLiteral createEnumerationLiteral(Enumeration enumeration, String name) {
        EnumerationLiteral enumerationLiteral = enumeration.createOwnedLiteral(name);
        return enumerationLiteral;
    }

    public static Extension createExtension(Class metaclass, Stereotype stereotype, boolean required) {
        Extension extension = stereotype.createExtension(metaclass, required);
        return extension;
    }

    public static Generalization createGeneralization(Classifier specificClassifier, Classifier generalClassifier) {
        Generalization generalization = specificClassifier.createGeneralization(generalClassifier);
        return generalization;
    }

    public static Package createPackage(Package nestingPackage, String name) {
        Package package_ = nestingPackage.createNestedPackage(name);
        return package_;
    }

    public static PrimitiveType createPrimitiveType(Package package_, String name) {
        PrimitiveType primitiveType = package_.createOwnedPrimitiveType(name);
        return primitiveType;
    }

    public static Profile createProfile(String name, String nsURI) {
        Profile profile = UMLFactory.eINSTANCE.createProfile();
        profile.setName(name);
        profile.setURI(nsURI);
        return profile;
    }

    public static Stereotype createStereotype(Profile profile, String name, boolean isAbstract) {
        Stereotype stereotype = profile.createOwnedStereotype(name, isAbstract);
        return stereotype;
    }

    public static void defineProfile(Profile profile) {
        profile.define();
    }

    protected static void applyProfile(Package package_, Profile profile) {
        package_.applyProfile(profile);
    }

    public static Property createAttribute(Class class_, String name, Type type, int lowerBound, int upperBound, Object defaultValue) {
        Property attribute = class_.createOwnedAttribute(name, type, lowerBound, upperBound);
        if (defaultValue instanceof Boolean) {
            LiteralBoolean literal = (LiteralBoolean)attribute.createDefaultValue(null, null, UMLPackage.Literals.LITERAL_BOOLEAN);
            literal.setValue(((Boolean)defaultValue).booleanValue());
        } else if (defaultValue instanceof String) {
            if (type instanceof Enumeration) {
                InstanceValue value = (InstanceValue)attribute.createDefaultValue(null, null, UMLPackage.Literals.INSTANCE_VALUE);
                value.setInstance((InstanceSpecification)((Enumeration)type).getOwnedLiteral((String)defaultValue));
            } else {
                LiteralString literal = (LiteralString)attribute.createDefaultValue(null, null, UMLPackage.Literals.LITERAL_STRING);
                literal.setValue((String)defaultValue);
            }
        }
        return attribute;
    }

    public static File getFileFromURI(URI uri) {
        Path path;
        IWorkspaceRoot myWorkspaceRoot;
        IFile file;
        if (uri != null && (file = (myWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot()).getFile((IPath)(path = new Path(uri.toPlatformString(true))))) != null && file.getLocation() != null) {
            File f = file.getLocation().toFile();
            return f;
        }
        return null;
    }

    public static Association createAssociation(Type type1, boolean end1IsNavigable, AggregationKind end1Aggregation, String end1Name, int end1LowerBound, int end1UpperBound, Type type2, boolean end2IsNavigable, AggregationKind end2Aggregation, String end2Name, int end2LowerBound, int end2UpperBound) {
        Association association = type1.createAssociation(end1IsNavigable, end1Aggregation, end1Name, end1LowerBound, end1UpperBound, type2, end2IsNavigable, end2Aggregation, end2Name, end2LowerBound, end2UpperBound);
        return association;
    }

    public static Property getSourceEnd(Association association) {
        return Utils.getMemberEnd(association, true);
    }

    public static Property getTargetEnd(Association association) {
        return Utils.getMemberEnd(association, false);
    }

    public static Property getMemberEnd(Association association, boolean sourceNotTarget) {
        if (sourceNotTarget && association.getMemberEnds().size() > 0) {
            return (Property)association.getMemberEnds().get(0);
        }
        if (!sourceNotTarget && association.getMemberEnds().size() > 1) {
            return (Property)association.getMemberEnds().get(1);
        }
        return null;
    }
}

