/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.req.reqif.assistant;

import java.util.ArrayList;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.FormDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.uml2.uml.Profile;

public class CreateOrSelectProfilDialog
extends FormDialog {
    protected ArrayList<Profile> appliedLocalProfiles;
    protected Button creationRadio;
    protected Text newTypeNameText;
    protected Label newProfileLabel;
    protected Button selectionRadio;
    protected Label profileSelectionLabel;
    protected Combo profileSelectionCombo;
    protected Section lSection;
    protected String resultProfileName;

    public CreateOrSelectProfilDialog(Shell shell, ArrayList<Profile> appliedLocalProfiles) {
        super(shell);
        this.appliedLocalProfiles = appliedLocalProfiles;
    }

    protected void createFormContent(IManagedForm pForm) {
        pForm.getForm().setText("Profile Selection");
        ScrolledForm scrolledForm = pForm.getForm();
        FormToolkit toolkit = pForm.getToolkit();
        Composite parent = scrolledForm.getBody();
        parent.setLayout((Layout)new GridLayout());
        this.createFormCreationSection(scrolledForm.getBody(), toolkit);
        this.createFormSelectionSection(scrolledForm.getBody(), toolkit);
        this.refreshSectionsEnable(false);
        this.makeSelectionVisible(this.appliedLocalProfiles.size() > 0);
        this.addListeners();
        scrolledForm.reflow(true);
    }

    protected void makeSelectionVisible(boolean visible) {
        this.selectionRadio.setVisible(visible);
        this.profileSelectionLabel.setVisible(visible);
        this.profileSelectionCombo.setVisible(visible);
        this.profileSelectionCombo.setVisible(visible);
        this.lSection.setText("No local profile found, ceation of a new profile is only possible");
    }

    protected void refreshSectionsEnable(boolean selectionEnable) {
        this.creationRadio.setSelection(false);
        this.selectionRadio.setSelection(false);
        this.creationRadio.setSelection(!selectionEnable);
        this.newTypeNameText.setEnabled(!selectionEnable);
        this.newProfileLabel.setEnabled(!selectionEnable);
        if (!selectionEnable) {
            this.newTypeNameText.setFocus();
        }
        this.selectionRadio.setSelection(selectionEnable);
        this.profileSelectionLabel.setEnabled(selectionEnable);
        this.profileSelectionCombo.setEnabled(selectionEnable);
        if (selectionEnable) {
            this.profileSelectionCombo.setFocus();
        }
    }

    protected void addListeners() {
        SelectionAdapter selectCreateListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CreateOrSelectProfilDialog.this.creationRadio.equals(e.getSource()) || CreateOrSelectProfilDialog.this.appliedLocalProfiles.size() == 0) {
                    CreateOrSelectProfilDialog.this.refreshSectionsEnable(false);
                } else {
                    CreateOrSelectProfilDialog.this.refreshSectionsEnable(true);
                }
                CreateOrSelectProfilDialog.this.refreshOkButton();
            }
        };
        this.selectionRadio.addSelectionListener((SelectionListener)selectCreateListener);
        this.creationRadio.addSelectionListener((SelectionListener)selectCreateListener);
        this.profileSelectionCombo.addSelectionListener((SelectionListener)selectCreateListener);
        ModifyListener lNewNameListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateOrSelectProfilDialog.this.refreshOkButton();
            }
        };
        this.newTypeNameText.addModifyListener(lNewNameListener);
    }

    protected void refreshOkButton() {
        boolean isSelectionSelected = this.selectionRadio.getSelection();
        if (isSelectionSelected) {
            if (this.profileSelectionCombo.getSelectionIndex() == -1) {
                this.getButton(0).setEnabled(false);
            } else {
                this.getButton(0).setEnabled(true);
            }
        } else if (this.newTypeNameText.getText().trim().equals("")) {
            this.getButton(0).setEnabled(false);
        } else {
            this.getButton(0).setEnabled(true);
        }
    }

    protected void createFormCreationSection(Composite pParent, FormToolkit pToolkit) {
        String lSectionTitle = "Create a new Profile";
        Section lSection = pToolkit.createSection(pParent, 320);
        lSection.setLayoutData((Object)new GridData(768));
        if (lSectionTitle != null) {
            lSection.setText(lSectionTitle);
        }
        ScrolledForm lInsideScrolledForm = pToolkit.createScrolledForm((Composite)lSection);
        lInsideScrolledForm.setExpandHorizontal(true);
        lInsideScrolledForm.setExpandVertical(true);
        Composite lBody = lInsideScrolledForm.getBody();
        GridLayout lLayout = new GridLayout();
        lLayout.numColumns = 3;
        lBody.setLayout((Layout)lLayout);
        this.creationRadio = pToolkit.createButton(lBody, "Profile creation", 16);
        this.creationRadio.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.newProfileLabel = pToolkit.createLabel(lBody, "Set name of the new profile", 0);
        this.newTypeNameText = pToolkit.createText(lBody, "", 2048);
        this.newTypeNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.newTypeNameText.setFocus();
        lInsideScrolledForm.reflow(true);
        lSection.setClient((Control)lInsideScrolledForm);
    }

    protected void createFormSelectionSection(Composite pParent, FormToolkit pToolkit) {
        String lSectionTitle = "Select an existing profile";
        this.lSection = pToolkit.createSection(pParent, 320);
        this.lSection.setLayoutData((Object)new GridData(768));
        if (lSectionTitle != null) {
            this.lSection.setText(lSectionTitle);
        }
        ScrolledForm lInsideScrolledForm = pToolkit.createScrolledForm((Composite)this.lSection);
        lInsideScrolledForm.setExpandHorizontal(true);
        lInsideScrolledForm.setExpandVertical(true);
        Composite lBody = lInsideScrolledForm.getBody();
        GridLayout lLayout = new GridLayout();
        lLayout.numColumns = 3;
        lBody.setLayout((Layout)lLayout);
        this.selectionRadio = pToolkit.createButton(lBody, "Selection profile mode", 16);
        this.selectionRadio.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.profileSelectionLabel = pToolkit.createLabel(lBody, "Profile:", 0);
        this.profileSelectionCombo = new Combo(lBody, 8);
        for (Profile profile : this.appliedLocalProfiles) {
            this.profileSelectionCombo.add(profile.getName());
        }
        pToolkit.adapt((Control)this.profileSelectionCombo, true, true);
        lInsideScrolledForm.reflow(true);
        this.lSection.setClient((Control)lInsideScrolledForm);
    }

    protected void okPressed() {
        this.resultProfileName = null;
        boolean isSelectionSelected = this.selectionRadio.getSelection();
        if (isSelectionSelected) {
            if (this.profileSelectionCombo.getSelectionIndex() != -1) {
                this.resultProfileName = this.profileSelectionCombo.getItem(this.profileSelectionCombo.getSelectionIndex());
            }
        } else if (!this.newTypeNameText.getText().trim().equals("")) {
            this.resultProfileName = this.newTypeNameText.getText().trim();
        }
        super.okPressed();
    }

    public String getProfileName() {
        return this.resultProfileName;
    }
}

