/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.req.reqif.integration.assistant;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.papyrus.editor.PapyrusMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;

public abstract class AbstractWizardForPapyrus
extends Wizard {
    protected TransactionalEditingDomain transactionalEditingDomain = null;
    protected PapyrusMultiDiagramEditor papyrusEditor;
    protected ModelSet modelSet;
    protected ResourceSet resourceSet;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        ServicesRegistry registry = null;
        try {
            registry = ServiceUtilsForSelection.getInstance().getServiceRegistry((ISelection)selection);
        }
        catch (ServiceException e1) {
            e1.printStackTrace();
        }
        try {
            this.modelSet = (ModelSet)registry.getService(ModelSet.class);
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
    }

    public ServicesRegistry getServiceRegistry() {
        try {
            IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            ServicesRegistry serviceRegistry = (ServicesRegistry)editor.getAdapter(ServicesRegistry.class);
            if (serviceRegistry != null) {
                return serviceRegistry;
            }
        }
        catch (NullPointerException e) {
            System.err.println("Can't get the current Eclipse Active Editor. No ServiceRegistry found.");
        }
        System.err.println("Can't get the ServiceRegistry from current Eclipse Active Editor");
        return null;
    }

    protected ModelSet getModelSet() throws ServiceException {
        return (ModelSet)this.getServiceRegistry().getService(ModelSet.class);
    }

    protected ArrayList<Element> getSelectionSet() {
        ArrayList<Element> selectedSet = new ArrayList<Element>();
        ISelectionService selectionService = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService();
        ISelection selection = selectionService.getSelection();
        if (selection instanceof IStructuredSelection) {
            for (Object currentSelection : (IStructuredSelection)selection) {
                EObject selectedEObject = EMFHelper.getEObject(currentSelection);
                if (!(selectedEObject instanceof Package)) continue;
                selectedSet.add((Element)selectedEObject);
            }
        }
        return selectedSet;
    }
}

