/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.req.reqif.queries;

import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.papyrus.emf.facet.efacet.core.IFacetManager;
import org.eclipse.papyrus.emf.facet.efacet.core.exception.DerivedTypedElementException;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.ParameterValue;
import org.eclipse.papyrus.emf.facet.query.java.core.IJavaQuery2;
import org.eclipse.papyrus.emf.facet.query.java.core.IParameterValueList2;
import org.eclipse.papyrus.uml.tools.providers.DelegatingItemLabelProvider;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Stereotype;

public class GetComplexName
implements IJavaQuery2<NamedElement, String> {
    private static final IItemLabelProvider labelProvider = new DelegatingItemLabelProvider();

    protected boolean isRequirementStereotype(Stereotype stereotype) {
        if ("SysML::Requirements::Requirement".equals(stereotype.getQualifiedName())) {
            return true;
        }
        for (Class superStereotype : stereotype.getSuperClasses()) {
            if (!(superStereotype instanceof Stereotype) || !this.isRequirementStereotype((Stereotype)superStereotype)) continue;
            return true;
        }
        return false;
    }

    public String evaluate(NamedElement source, IParameterValueList2 parameterValues, IFacetManager facetManager) throws DerivedTypedElementException {
        ParameterValue parameterValue = parameterValues.getParameterValueByName("eObject");
        if (parameterValue.getValue() instanceof EStructuralFeature) {
            return ((EStructuralFeature)parameterValue.getValue()).getName();
        }
        Stereotype stereotypeReq = source.getAppliedStereotype("SysML::Requirements::Requirement");
        Stereotype appStereotype = null;
        if (source.getAppliedStereotypes().size() > 0) {
            appStereotype = (Stereotype)source.getAppliedStereotypes().get(0);
        }
        if (stereotypeReq != null) {
            return source.getValue(stereotypeReq, "id") + ": " + source.getValue(stereotypeReq, "text");
        }
        if (source instanceof Class && appStereotype != null && this.isRequirementStereotype(appStereotype)) {
            return source.getValue(appStereotype, "id") + ": " + source.getValue(appStereotype, "text");
        }
        return labelProvider.getText((Object)source);
    }
}

