/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.req.reqif.transformation;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.uml.extensionpoints.profile.IRegisteredProfile;
import org.eclipse.papyrus.uml.extensionpoints.profile.RegisteredProfile;
import org.eclipse.rmf.reqif10.DatatypeDefinition;
import org.eclipse.rmf.reqif10.DatatypeDefinitionEnumeration;
import org.eclipse.rmf.reqif10.ReqIF;
import org.eclipse.rmf.reqif10.SpecObject;
import org.eclipse.rmf.reqif10.SpecType;
import org.eclipse.rmf.reqif10.SpecificationType;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;

public abstract class ReqIFBaseTransformation {
    public TransactionalEditingDomain domain = null;
    protected ReqIF reqIFModel;
    protected Package targetUMLModel;
    protected Package importRootUMLPackage = null;
    protected HashMap<String, Stereotype> objectTypeStereotypesMap;
    protected HashMap<String, Stereotype> specRelationTypeSterotypeMap;
    protected Package umlPrimitiveTypes;
    protected Package umlMetamodel;
    protected Profile sysMLprofile;
    protected HashMap<String, SpecType> objectTypeMap;
    protected HashMap<String, SpecType> specRelationTypeMap;
    protected HashMap<String, SpecificationType> specificationTypeMap;
    protected HashMap<String, DatatypeDefinitionEnumeration> reqifDatatTypeEnumeration;
    protected HashMap<String, Stereotype> specificationTypeSterotypeMap;
    protected HashMap<SpecObject, Element> SpecObject_UMLElementMap;
    protected HashMap<String, Enumeration> profileEnumeration;

    public static Package getRootModel(Package element) {
        if (element.eContainer() instanceof Package) {
            return ReqIFBaseTransformation.getRootModel((Package)element.eContainer());
        }
        if (element instanceof Package) {
            return element;
        }
        return null;
    }

    public ReqIFBaseTransformation(TransactionalEditingDomain domain, Package UMLModel) {
        this.domain = domain;
        this.targetUMLModel = UMLModel;
        IRegisteredProfile registeredProfile = RegisteredProfile.getRegisteredProfile((String)"SysML");
        URI sysMLUri = registeredProfile.getUri();
        Resource modelResource = EMFHelper.getResourceSet((EObject)UMLModel).getResource(sysMLUri, true);
        this.sysMLprofile = (Profile)modelResource.getContents().get(0);
        Resource resourceprimitiveType = EMFHelper.getResourceSet((EObject)UMLModel).getResource(URI.createURI((String)"pathmap://UML_LIBRARIES/UMLPrimitiveTypes.library.uml"), true);
        this.umlPrimitiveTypes = (Package)resourceprimitiveType.getContents().get(0);
        Resource umlMetamodelResource = EMFHelper.getResourceSet((EObject)UMLModel).getResource(URI.createURI((String)"pathmap://UML_METAMODELS/UML.metamodel.uml"), true);
        this.umlMetamodel = (Package)umlMetamodelResource.getContents().get(0);
        this.objectTypeStereotypesMap = new HashMap();
        this.specRelationTypeSterotypeMap = new HashMap();
    }

    protected HashMap<String, Enumeration> getAllPossibleEnumeration(Package uMLModel) {
        HashMap<String, Enumeration> enumerationList = new HashMap<String, Enumeration>();
        for (Profile currentProfile : uMLModel.getAppliedProfiles()) {
            for (PackageableElement packageableElement : currentProfile.getPackagedElements()) {
                if (!(packageableElement instanceof Enumeration)) continue;
                enumerationList.put(packageableElement.getName(), (Enumeration)packageableElement);
            }
        }
        return enumerationList;
    }

    protected boolean isRequirementStereotype(Stereotype stereotype) {
        if ("SysML::Requirements::Requirement".equals(stereotype.getQualifiedName())) {
            return true;
        }
        for (Class superStereotype : stereotype.getSuperClasses()) {
            if (!(superStereotype instanceof Stereotype) || !this.isRequirementStereotype((Stereotype)superStereotype)) continue;
            return true;
        }
        return false;
    }

    protected HashMap<String, Stereotype> getAllPossibleRequirementType(Package UMLModel) {
        HashMap<String, Stereotype> requirementStereotypes = new HashMap<String, Stereotype>();
        for (Profile currentProfile : UMLModel.getAppliedProfiles()) {
            if (currentProfile.getQualifiedName().equals("SysML::Requirements")) {
                requirementStereotypes.put("SysML_Requirement", currentProfile.getOwnedStereotype("Requirement"));
            }
            for (Stereotype stereotype : currentProfile.getOwnedStereotypes()) {
                if (!this.isRequirementStereotype(stereotype) || stereotype.getQualifiedName().equals("SysML::Requirements::Requirement")) continue;
                requirementStereotypes.put(stereotype.getName(), stereotype);
            }
        }
        return requirementStereotypes;
    }

    protected HashMap<String, Stereotype> getAllPossibleSpecRelationType(Package uMLModel) {
        HashMap<String, Stereotype> SpecRelationStereotypes = new HashMap<String, Stereotype>();
        for (Profile currentProfile : uMLModel.getAppliedProfiles()) {
            for (Stereotype stereotype : currentProfile.getOwnedStereotypes()) {
                if (!this.isPossibleSpecRelationTypeStereotype(stereotype)) continue;
                SpecRelationStereotypes.put(stereotype.getName(), stereotype);
            }
        }
        return SpecRelationStereotypes;
    }

    protected boolean isPossibleSpecRelationTypeStereotype(Stereotype stereotype) {
        Class packageMetaclass = (Class)this.umlMetamodel.getOwnedType("Dependency");
        if (stereotype.getExtendedMetaclasses().contains((Object)packageMetaclass)) {
            return true;
        }
        for (Class superStereotype : stereotype.getSuperClasses()) {
            if (!(superStereotype instanceof Stereotype) || !this.isPossibleSpecificationTypeStereotype((Stereotype)superStereotype)) continue;
            return true;
        }
        return false;
    }

    protected HashMap<String, Stereotype> getAllPossibleSpecificationType(Package uMLModel) {
        HashMap<String, Stereotype> specificationStereotypes = new HashMap<String, Stereotype>();
        for (Profile currentProfile : uMLModel.getAppliedProfiles()) {
            for (Stereotype stereotype : currentProfile.getOwnedStereotypes()) {
                if (!this.isPossibleSpecificationTypeStereotype(stereotype)) continue;
                specificationStereotypes.put(stereotype.getName(), stereotype);
            }
        }
        return specificationStereotypes;
    }

    protected boolean isPossibleSpecificationTypeStereotype(Stereotype stereotype) {
        Class packageMetaclass = (Class)this.umlMetamodel.getOwnedType("Package");
        if (stereotype.getExtendedMetaclasses().contains((Object)packageMetaclass)) {
            return true;
        }
        for (Class superStereotype : stereotype.getSuperClasses()) {
            if (!(superStereotype instanceof Stereotype) || !this.isPossibleSpecificationTypeStereotype((Stereotype)superStereotype)) continue;
            return true;
        }
        return false;
    }

    protected Stereotype getRequirementStereotype(Profile sysMLprofile) {
        Profile requirementProfile = (Profile)sysMLprofile.getPackagedElement("Requirements");
        return (Stereotype)requirementProfile.getPackagedElement("Requirement");
    }

    protected ArrayList<Profile> getAllAppliedProfiles(Package UMLModel) {
        Package RootModel = ReqIFBaseTransformation.getRootModel(UMLModel);
        ArrayList<Profile> appliedProfiles = new ArrayList<Profile>();
        for (Profile currentProfile : RootModel.getAppliedProfiles()) {
            appliedProfiles.add(currentProfile);
        }
        return appliedProfiles;
    }

    protected ArrayList<Profile> getAllLocalProfiles(Package UMLModel) {
        Package RootModel = ReqIFBaseTransformation.getRootModel(UMLModel);
        ArrayList<Profile> localProfile = new ArrayList<Profile>();
        for (Profile currentProfile : RootModel.getAppliedProfiles()) {
            if (!currentProfile.eResource().getURI().isPlatformResource()) continue;
            localProfile.add(currentProfile);
        }
        return localProfile;
    }

    protected void getAllDataTypeDefinitionEnumeration() {
        if (this.reqIFModel.getCoreContent().getSpecTypes() != null && this.reqIFModel.getCoreContent().getDatatypes().size() > 0) {
            for (DatatypeDefinition reqIFType : this.reqIFModel.getCoreContent().getDatatypes()) {
                if (!(reqIFType instanceof DatatypeDefinitionEnumeration)) continue;
                this.reqifDatatTypeEnumeration.put(reqIFType.getLongName(), (DatatypeDefinitionEnumeration)reqIFType);
            }
        }
    }
}

