/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.req.reqif.transformation;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.builders.NotificationBuilder;
import org.eclipse.papyrus.req.reqif.Activator;
import org.eclipse.papyrus.req.reqif.assistant.CreateOrSelectProfilDialog;
import org.eclipse.papyrus.req.reqif.assistant.SelectProfilDialog;
import org.eclipse.papyrus.req.reqif.integration.assistant.ChooseAttributeEnumerationDialog;
import org.eclipse.papyrus.req.reqif.transformation.ReqIFBaseTransformation;
import org.eclipse.papyrus.req.reqif.util.BasicRequirementMerger;
import org.eclipse.papyrus.uml.extensionpoints.profile.IRegisteredProfile;
import org.eclipse.papyrus.uml.extensionpoints.profile.RegisteredProfile;
import org.eclipse.papyrus.uml.extensionpoints.utils.Util;
import org.eclipse.rmf.reqif10.AttributeDefinition;
import org.eclipse.rmf.reqif10.AttributeDefinitionBoolean;
import org.eclipse.rmf.reqif10.AttributeDefinitionEnumeration;
import org.eclipse.rmf.reqif10.AttributeDefinitionInteger;
import org.eclipse.rmf.reqif10.AttributeDefinitionReal;
import org.eclipse.rmf.reqif10.AttributeDefinitionString;
import org.eclipse.rmf.reqif10.AttributeDefinitionXHTML;
import org.eclipse.rmf.reqif10.AttributeValue;
import org.eclipse.rmf.reqif10.AttributeValueBoolean;
import org.eclipse.rmf.reqif10.AttributeValueEnumeration;
import org.eclipse.rmf.reqif10.AttributeValueInteger;
import org.eclipse.rmf.reqif10.AttributeValueReal;
import org.eclipse.rmf.reqif10.AttributeValueString;
import org.eclipse.rmf.reqif10.AttributeValueXHTML;
import org.eclipse.rmf.reqif10.DatatypeDefinitionEnumeration;
import org.eclipse.rmf.reqif10.EnumValue;
import org.eclipse.rmf.reqif10.Identifiable;
import org.eclipse.rmf.reqif10.ReqIF;
import org.eclipse.rmf.reqif10.SpecElementWithAttributes;
import org.eclipse.rmf.reqif10.SpecHierarchy;
import org.eclipse.rmf.reqif10.SpecObject;
import org.eclipse.rmf.reqif10.SpecObjectType;
import org.eclipse.rmf.reqif10.SpecRelation;
import org.eclipse.rmf.reqif10.SpecRelationType;
import org.eclipse.rmf.reqif10.SpecType;
import org.eclipse.rmf.reqif10.Specification;
import org.eclipse.rmf.reqif10.SpecificationType;
import org.eclipse.rmf.reqif10.XhtmlContent;
import org.eclipse.rmf.reqif10.common.util.ReqIF10Util;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;

public abstract class ReqIFImporter
extends ReqIFBaseTransformation {
    protected Shell shellLogger;

    public ReqIFImporter(TransactionalEditingDomain domain, ReqIF reqIFModel, Package UMLModel) {
        super(domain, UMLModel);
        this.reqIFModel = reqIFModel;
        this.objectTypeMap = new HashMap();
        this.objectTypeStereotypesMap = new HashMap();
        this.specificationTypeMap = new HashMap();
        this.specificationTypeSterotypeMap = new HashMap();
        this.specRelationTypeMap = new HashMap();
        this.specRelationTypeSterotypeMap = new HashMap();
        this.profileEnumeration = new HashMap();
    }

    public void preProcess(ReqIF reqIFModel) {
        this.normalizeNames(reqIFModel);
        this.normalizeID(reqIFModel);
        this.transformPatternEnumeration(reqIFModel, null);
    }

    protected void normalizeNames(ReqIF reqIFModel) {
        TreeIterator reqIFElementIterator = reqIFModel.eAllContents();
        int index = 0;
        while (reqIFElementIterator.hasNext()) {
            EObject eObject = (EObject)reqIFElementIterator.next();
            if (!(eObject instanceof Identifiable)) continue;
            Identifiable identifiable = (Identifiable)eObject;
            if (identifiable.getLongName() == null || identifiable.getLongName().trim().equals("")) {
                identifiable.setLongName(String.valueOf(eObject.getClass().getSimpleName()) + "_" + index);
                ++index;
            }
            identifiable.setLongName(this.getNormalName(identifiable.getLongName()));
        }
    }

    protected void normalizeID(ReqIF reqIFModel) {
        TreeIterator reqIFElementIterator = reqIFModel.eAllContents();
        boolean index = false;
        while (reqIFElementIterator.hasNext()) {
            EObject eObject = (EObject)reqIFElementIterator.next();
            if (!(eObject instanceof SpecObject)) continue;
            SpecObject specObject = (SpecObject)eObject;
            EList values = specObject.getValues();
            for (AttributeValue attributeValue : values) {
                if (!(attributeValue instanceof AttributeValueInteger) || !((AttributeValueInteger)attributeValue).getDefinition().getLongName().equals("ReqIF_ForeignID")) continue;
                specObject.setIdentifier("" + ((AttributeValueInteger)attributeValue).getTheValue());
            }
        }
    }

    protected void transformPatternEnumeration(ReqIF reqIFModel, String attributeEnumeration) {
        ArrayList<SpecObjectType> specObjectTypes = new ArrayList<SpecObjectType>();
        if (reqIFModel.getCoreContent().getSpecTypes() != null && reqIFModel.getCoreContent().getSpecTypes().size() > 0) {
            for (SpecType reqIFType : reqIFModel.getCoreContent().getSpecTypes()) {
                if (!(reqIFType instanceof SpecObjectType)) continue;
                specObjectTypes.add((SpecObjectType)reqIFType);
            }
        }
        if (specObjectTypes.size() == 1) {
            SpecObjectType theType = (SpecObjectType)specObjectTypes.get(0);
            ArrayList<AttributeDefinitionEnumeration> attEnumeration = new ArrayList<AttributeDefinitionEnumeration>();
            AttributeDefinitionEnumeration patternEnumerationAtt = null;
            for (AttributeDefinition attDefinition : theType.getSpecAttributes()) {
                if (!(attDefinition instanceof AttributeDefinitionEnumeration)) continue;
                attEnumeration.add((AttributeDefinitionEnumeration)attDefinition);
                if (attributeEnumeration == null || !attDefinition.getLongName().equals(attributeEnumeration)) continue;
                patternEnumerationAtt = (AttributeDefinitionEnumeration)attDefinition;
            }
            if (patternEnumerationAtt == null) {
                if (attEnumeration.size() > 1) {
                    ChooseAttributeEnumerationDialog assistedDialog = new ChooseAttributeEnumerationDialog(new Shell(), attEnumeration);
                    assistedDialog.open();
                    ArrayList result = assistedDialog.getSelectedElements();
                    patternEnumerationAtt = (AttributeDefinitionEnumeration)result.get(0);
                } else {
                    patternEnumerationAtt = (AttributeDefinitionEnumeration)attEnumeration.get(0);
                }
            }
            DatatypeDefinitionEnumeration enumeration = patternEnumerationAtt.getType();
            HashMap<String, SpecObjectType> newTypes = new HashMap<String, SpecObjectType>();
            for (EnumValue enumValue : enumeration.getSpecifiedValues()) {
                SpecObjectType specObjectType = (SpecObjectType)EcoreUtil.copy((EObject)theType);
                specObjectType.setLongName(enumValue.getLongName());
                specObjectType.setLastChange((GregorianCalendar)GregorianCalendar.getInstance());
                reqIFModel.getCoreContent().getSpecTypes().add((Object)specObjectType);
                newTypes.put(enumValue.getLongName(), specObjectType);
            }
            for (SpecObject specObject : reqIFModel.getCoreContent().getSpecObjects()) {
                AttributeValueEnumeration attValue = (AttributeValueEnumeration)ReqIFImporter.getAttributeValue((SpecElementWithAttributes)specObject, (AttributeDefinition)patternEnumerationAtt);
                if (attValue == null || attValue.getValues().size() <= 0) continue;
                specObject.setType((SpecObjectType)newTypes.get(((EnumValue)attValue.getValues().get(0)).getLongName()));
            }
        }
    }

    public static AttributeValue getAttributeValue(SpecElementWithAttributes specElement, AttributeDefinition attributeDefinition) {
        for (AttributeValue value : specElement.getValues()) {
            AttributeDefinition definition = ReqIF10Util.getAttributeDefinition((AttributeValue)value);
            if (!attributeDefinition.getLongName().equals(definition.getLongName())) continue;
            return value;
        }
        if (attributeDefinition instanceof AttributeDefinitionEnumeration) {
            return ((AttributeDefinitionEnumeration)attributeDefinition).getDefaultValue();
        }
        if (attributeDefinition instanceof AttributeDefinitionBoolean) {
            return ((AttributeDefinitionBoolean)attributeDefinition).getDefaultValue();
        }
        if (attributeDefinition instanceof AttributeDefinitionInteger) {
            return ((AttributeDefinitionInteger)attributeDefinition).getDefaultValue();
        }
        if (attributeDefinition instanceof AttributeDefinitionReal) {
            return ((AttributeDefinitionReal)attributeDefinition).getDefaultValue();
        }
        if (attributeDefinition instanceof AttributeDefinitionString) {
            return ((AttributeDefinitionString)attributeDefinition).getDefaultValue();
        }
        if (attributeDefinition instanceof AttributeDefinitionXHTML) {
            return ((AttributeDefinitionXHTML)attributeDefinition).getDefaultValue();
        }
        return null;
    }

    protected Text initLogger() {
        this.shellLogger = new Shell();
        this.shellLogger.setLayout((Layout)new FillLayout());
        this.shellLogger.setSize(300, 100);
        Text message = new Text((Composite)this.shellLogger, 2626);
        message.setLayoutData((Object)new GridData(1808));
        this.shellLogger.open();
        return message;
    }

    public boolean reImportReqIFModel(boolean interactive, String matchProperty, boolean deleteElement) {
        Model reImportModel = UMLFactory.eINSTANCE.createModel();
        reImportModel.setName("Re-ImportModel" + GregorianCalendar.getInstance().getTimeInMillis());
        Package firstVersion = this.targetUMLModel;
        firstVersion.eResource().getContents().add((Object)reImportModel);
        ArrayList<Profile> appliedProfiles = this.getAllAppliedProfiles(firstVersion);
        for (Profile profile : appliedProfiles) {
            reImportModel.applyProfile(profile);
        }
        this.targetUMLModel = reImportModel;
        boolean importResult = this.importReqIFModel(interactive);
        BasicRequirementMerger merger = new BasicRequirementMerger(firstVersion, this.targetUMLModel, matchProperty, deleteElement, this.domain);
        merger.merge();
        firstVersion.eResource().getContents().remove((Object)this.targetUMLModel);
        if (interactive) {
            Comment comment = UMLFactory.eINSTANCE.createComment();
            String txt = "AddedElements\n";
            for (Element element : merger.getAddedElements()) {
                txt = String.valueOf(txt) + element.toString() + "\n";
            }
            txt = String.valueOf(txt) + "RemovedElements\n";
            for (Element element : merger.getElementToDelete()) {
                txt = String.valueOf(txt) + element.toString() + "\n";
            }
            txt = String.valueOf(txt) + "ModifiedElements\n";
            for (Element element : merger.getModifiedElement()) {
                txt = String.valueOf(txt) + element.toString() + "\n";
            }
            comment.setBody(txt);
            firstVersion.getOwnedComments().add((Object)comment);
        }
        return importResult;
    }

    public boolean importReqIFModel(boolean interactive) {
        Text message = this.initLogger();
        message.setText("Preprocessing...");
        this.preProcess(this.reqIFModel);
        this.importReqIFHeader(this.reqIFModel, this.targetUMLModel);
        this.getAllStereotypesRepresentingTypes(ReqIFImporter.getRootModel(this.targetUMLModel));
        this.SpecObject_UMLElementMap = new HashMap();
        message.setText("Import types...");
        this.getAllTypesFromReqIFFiles(this.reqIFModel);
        this.objectTypeMap = this.filterReqifAvailableType(this.objectTypeMap);
        if (interactive) {
            this.objectTypeMap = this.selectReqIFType(this.objectTypeMap.values());
        }
        ArrayList<Object> specObjectTypesToCreate = new ArrayList<SpecType>();
        ArrayList<Object> specificationTypesToCreate = new ArrayList<SpecificationType>();
        ArrayList<Object> specRelationTypesToCreate = new ArrayList<SpecType>();
        ArrayList<Object> dataTypeDefinitionToCreate = new ArrayList<DatatypeDefinitionEnumeration>();
        this.lookForTypesWihtouStereotypes(specObjectTypesToCreate, specificationTypesToCreate, specRelationTypesToCreate, dataTypeDefinitionToCreate);
        if (specObjectTypesToCreate.size() > 0 || specificationTypesToCreate.size() > 0 || specRelationTypesToCreate.size() > 0 || dataTypeDefinitionToCreate.size() > 0) {
            IPreferenceStore store = Activator.getDefault().getPreferenceStore();
            String userkind_value = store.getString("USER_KIND");
            if (userkind_value.equals("ADVANCED_USER")) {
                CreateOrSelectProfilDialog profilDialog = new CreateOrSelectProfilDialog(new Shell(), this.getAllLocalProfiles(ReqIFImporter.getRootModel(this.targetUMLModel)));
                profilDialog.open();
                String profileName = profilDialog.getProfileName();
                Profile profile = this.getProfile(ReqIFImporter.getRootModel(this.targetUMLModel), profileName);
                this.importReqIFHeader(this.reqIFModel, (Package)profile);
                this.importDataTypeDefinition(profile, dataTypeDefinitionToCreate);
                this.importReqIFSpecificationType(profile, specificationTypesToCreate);
                this.importReqIFSpecObjectTypes(profile, specObjectTypesToCreate);
                this.importReqIFspecRelationTypes(profile, specRelationTypesToCreate);
                this.postProcessProfile(profile);
                this.defineProfile(profile);
                ReqIFImporter.getRootModel(this.targetUMLModel).applyProfile(profile);
            } else {
                List registeredProfiles = RegisteredProfile.getRegisteredProfiles();
                ArrayList<Profile> profilelist = new ArrayList<Profile>();
                for (IRegisteredProfile iRegisteredProfile : registeredProfiles) {
                    ResourceSet resourceSet = this.targetUMLModel.eResource().getResourceSet();
                    Resource resource = resourceSet.getResource(iRegisteredProfile.getUri(), true);
                    if (resource.getContents().size() != 1 || !(resource.getContents().get(0) instanceof Profile)) continue;
                    profilelist.add((Profile)resource.getContents().get(0));
                }
                SelectProfilDialog profilDialog = new SelectProfilDialog(new Shell(), profilelist);
                profilDialog.open();
                Profile profileToApply = null;
                String profileName = profilDialog.getProfileName();
                for (Profile profileTmp : profilelist) {
                    if (!profileTmp.getName().equals(profileName)) continue;
                    profileToApply = profileTmp;
                }
                ReqIFImporter.getRootModel(this.targetUMLModel).applyProfile(profileToApply);
                message.setText("Import objects...");
                this.getAllStereotypesRepresentingTypes(ReqIFImporter.getRootModel(this.targetUMLModel));
                specObjectTypesToCreate = new ArrayList();
                specificationTypesToCreate = new ArrayList();
                specRelationTypesToCreate = new ArrayList();
                dataTypeDefinitionToCreate = new ArrayList();
                this.lookForTypesWihtouStereotypes(specObjectTypesToCreate, specificationTypesToCreate, specRelationTypesToCreate, dataTypeDefinitionToCreate);
                if (specObjectTypesToCreate.size() > 0 || specificationTypesToCreate.size() > 0 || specRelationTypesToCreate.size() > 0 || dataTypeDefinitionToCreate.size() > 0) {
                    this.createMessageForTypewithoutStereotypes(specObjectTypesToCreate, specificationTypesToCreate, specRelationTypesToCreate, dataTypeDefinitionToCreate);
                    return false;
                }
            }
        }
        this.objectTypeStereotypesMap = this.getAllPossibleRequirementType(ReqIFImporter.getRootModel(this.targetUMLModel));
        HashMap<String, Stereotype> filteredreqStereotypes = new HashMap<String, Stereotype>();
        for (SpecType specObjectType : this.objectTypeMap.values()) {
            if (!this.objectTypeStereotypesMap.containsKey(specObjectType.getLongName())) continue;
            filteredreqStereotypes.put(specObjectType.getLongName(), (Stereotype)this.objectTypeStereotypesMap.get(specObjectType.getLongName()));
        }
        this.objectTypeStereotypesMap = filteredreqStereotypes;
        this.specificationTypeSterotypeMap = this.getAllPossibleSpecificationType(ReqIFImporter.getRootModel(this.targetUMLModel));
        this.specRelationTypeSterotypeMap = this.getAllPossibleSpecRelationType(ReqIFImporter.getRootModel(this.targetUMLModel));
        this.importReqIFspecification(this.reqIFModel, this.targetUMLModel, this.objectTypeStereotypesMap);
        this.importSpecRelation(this.reqIFModel, this.targetUMLModel, this.specRelationTypeSterotypeMap);
        this.postProcess(this.targetUMLModel);
        this.shellLogger.close();
        this.shellLogger.dispose();
        return true;
    }

    protected void createMessageForTypewithoutStereotypes(ArrayList<SpecType> specObjectTypesToCreate, ArrayList<SpecificationType> specificationTypesToCreate, ArrayList<SpecType> specRelationTypesToCreate, ArrayList<DatatypeDefinitionEnumeration> dataTypeDefinitionToCreate) {
        Comment comment = this.targetUMLModel.createOwnedComment();
        String messageTodisplay = "";
        for (SpecType specType : specObjectTypesToCreate) {
            messageTodisplay = String.valueOf(messageTodisplay) + "\n " + specType.getLongName();
        }
        for (SpecificationType specificationType : specificationTypesToCreate) {
            messageTodisplay = String.valueOf(messageTodisplay) + "\n " + specificationType.getLongName();
        }
        for (SpecType specType : specRelationTypesToCreate) {
            messageTodisplay = String.valueOf(messageTodisplay) + "\n " + specType.getLongName();
        }
        for (DatatypeDefinitionEnumeration datatypeDefinitionEnumeration : dataTypeDefinitionToCreate) {
            messageTodisplay = String.valueOf(messageTodisplay) + "\n " + datatypeDefinitionEnumeration.getLongName();
        }
        messageTodisplay = "No Stereotype found for:" + messageTodisplay;
        comment.setBody(messageTodisplay);
        this.displayShell(messageTodisplay);
    }

    protected void displayShell(String message) {
        NotificationBuilder warm = NotificationBuilder.createErrorPopup((String)"The choosen profile does not contain types that have to be imported!");
        warm.run();
    }

    protected void lookForTypesWihtouStereotypes(ArrayList<SpecType> specObjectTypesToCreate, ArrayList<SpecificationType> specificationTypesToCreate, ArrayList<SpecType> specRelationTypesToCreate, ArrayList<DatatypeDefinitionEnumeration> dataTypeDefinitionToCreate) {
        for (SpecType specObjectType : this.objectTypeMap.values()) {
            if (this.objectTypeStereotypesMap.containsKey(specObjectType.getLongName())) continue;
            specObjectTypesToCreate.add(specObjectType);
        }
        for (SpecificationType specificationType : this.specificationTypeMap.values()) {
            if (this.specificationTypeSterotypeMap.containsKey(specificationType.getLongName())) continue;
            specificationTypesToCreate.add(specificationType);
        }
        for (SpecType specRelationType : this.specRelationTypeMap.values()) {
            if (this.specRelationTypeSterotypeMap.containsKey(specRelationType.getLongName())) continue;
            specRelationTypesToCreate.add(specRelationType);
        }
        for (DatatypeDefinitionEnumeration definitionEnumeration : this.reqifDatatTypeEnumeration.values()) {
            if (this.profileEnumeration.containsKey(definitionEnumeration.getLongName())) continue;
            dataTypeDefinitionToCreate.add(definitionEnumeration);
        }
    }

    protected void getAllTypesFromReqIFFiles(ReqIF reqIFModel) {
        this.objectTypeMap = new HashMap();
        this.specificationTypeMap = new HashMap();
        this.specRelationTypeMap = new HashMap();
        this.reqifDatatTypeEnumeration = new HashMap();
        if (reqIFModel.getCoreContent().getSpecTypes() != null && reqIFModel.getCoreContent().getSpecTypes().size() > 0) {
            for (SpecType reqIFType : reqIFModel.getCoreContent().getSpecTypes()) {
                if (reqIFType instanceof SpecObjectType) {
                    this.objectTypeMap.put(reqIFType.getLongName(), (SpecObjectType)reqIFType);
                }
                if (reqIFType instanceof SpecificationType) {
                    this.specificationTypeMap.put(reqIFType.getLongName(), (SpecificationType)reqIFType);
                }
                if (!(reqIFType instanceof SpecRelationType)) continue;
                this.specRelationTypeMap.put(reqIFType.getLongName(), (SpecRelationType)reqIFType);
            }
        }
        this.getAllDataTypeDefinitionEnumeration();
    }

    protected void getAllStereotypesRepresentingTypes(Package UMLModel) {
        this.objectTypeStereotypesMap = new HashMap();
        this.objectTypeStereotypesMap = this.getAllPossibleRequirementType(UMLModel);
        this.specificationTypeSterotypeMap = new HashMap();
        this.specificationTypeSterotypeMap = this.getAllPossibleSpecificationType(UMLModel);
        this.specRelationTypeSterotypeMap = new HashMap();
        this.specRelationTypeSterotypeMap = this.getAllPossibleSpecRelationType(UMLModel);
        this.profileEnumeration = new HashMap();
        this.profileEnumeration = this.getAllPossibleEnumeration(UMLModel);
    }

    public HashMap<String, SpecType> filterReqifAvailableType(HashMap<String, SpecType> reqiFTypeMap) {
        return reqiFTypeMap;
    }

    public void postProcess(Package UMLModel) {
    }

    public void postProcessProfile(Profile profile) {
    }

    protected abstract void defineProfile(Profile var1);

    protected abstract HashMap<String, SpecType> selectReqIFType(Collection<SpecType> var1);

    protected void importDataTypeDefinition(Profile profile, ArrayList<DatatypeDefinitionEnumeration> dataTypeDefinitionToCreate) {
        for (DatatypeDefinitionEnumeration definitionEnumeration : dataTypeDefinitionToCreate) {
            if (definitionEnumeration.getLongName() == null || definitionEnumeration.getLongName().trim().equals("")) continue;
            Enumeration enumeration = profile.createOwnedEnumeration(this.getNormalName(definitionEnumeration.getLongName()));
            this.profileEnumeration.put(this.getNormalName(definitionEnumeration.getLongName()), enumeration);
            for (EnumValue enumValue : definitionEnumeration.getSpecifiedValues()) {
                if (enumValue.getLongName() == null) continue;
                EnumerationLiteral enumerationLiteral = enumeration.createOwnedLiteral(this.getNormalName(enumValue.getLongName()));
                if (enumValue.getDesc() == null) continue;
                Comment comment = enumerationLiteral.createOwnedComment();
                comment.setBody(enumValue.getDesc());
            }
            if (definitionEnumeration.getDesc() == null) continue;
            Comment comment = enumeration.createOwnedComment();
            comment.setBody(definitionEnumeration.getDesc());
        }
    }

    protected void importReqIFspecRelationTypes(Profile profile, ArrayList<SpecType> specRelationTypesToCreate) {
        for (SpecType specRelationType : specRelationTypesToCreate) {
            if (specRelationType.getLongName() == null || specRelationType.getLongName().trim().equals("")) continue;
            Stereotype stereotype = profile.createOwnedStereotype(specRelationType.getLongName(), false);
            this.importSpecAttribute(specRelationType, stereotype);
            if (specRelationType.getDesc() != null) {
                Comment comment = stereotype.createOwnedComment();
                comment.setBody(specRelationType.getDesc());
            }
            Class metaclass = (Class)this.umlMetamodel.getOwnedType("Dependency");
            profile.createMetaclassReference((PackageableElement)metaclass);
            stereotype.createExtension(metaclass, false);
        }
    }

    protected void importReqIFspecification(ReqIF reqIFModel, Package UMLModel, HashMap<String, Stereotype> reqStereotypes) {
        for (Specification specif : reqIFModel.getCoreContent().getSpecifications()) {
            Package apackage = UMLModel.createNestedPackage(specif.getLongName());
            if (this.specificationTypeSterotypeMap.get(specif.getType().getLongName()) != null) {
                apackage.applyStereotype((Stereotype)this.specificationTypeSterotypeMap.get(specif.getType().getLongName()));
                this.importSpecAttributesValue(this.specificationTypeSterotypeMap, (SpecElementWithAttributes)specif, (Element)apackage, (SpecType)specif.getType());
            }
            for (SpecHierarchy specHierarchy : specif.getChildren()) {
                this.importReqIFHyerarchy(specHierarchy, (Element)apackage, reqStereotypes);
            }
            this.importRootUMLPackage = apackage;
        }
    }

    public Property getProperty(Stereotype stereotype, String propertyName) {
        Property property = null;
        for (Property attribute : stereotype.getAllAttributes()) {
            if (!attribute.getName().equals(propertyName)) continue;
            return attribute;
        }
        return property;
    }

    protected void importSpecAttributesValue(HashMap<String, Stereotype> reqStereotypesMap, SpecElementWithAttributes specif, Element umlElement, SpecType specType) {
        if (specType != null) {
            for (AttributeDefinition attDefinition : specType.getSpecAttributes()) {
                Property aProperty;
                Stereotype stereotype;
                String attributeName;
                AttributeValue att = ReqIFImporter.getAttributeValue(specif, attDefinition);
                if (att != null) {
                    if (att instanceof AttributeValueString) {
                        attributeName = ((AttributeValueString)att).getDefinition().getLongName().trim();
                        attributeName = this.getNormalName(attributeName);
                        stereotype = reqStereotypesMap.get(specType.getLongName());
                        if (stereotype != null && (aProperty = this.getProperty(stereotype, attributeName)) != null) {
                            umlElement.setValue(reqStereotypesMap.get(specType.getLongName()), attributeName, (Object)((AttributeValueString)att).getTheValue());
                            if (attributeName.equals("ID") && umlElement instanceof NamedElement) {
                                ((NamedElement)umlElement).setName(((AttributeValueString)att).getTheValue());
                            }
                        }
                    }
                    if (att instanceof AttributeValueBoolean) {
                        attributeName = ((AttributeValueBoolean)att).getDefinition().getLongName().trim();
                        attributeName = this.getNormalName(attributeName);
                        stereotype = reqStereotypesMap.get(specType.getLongName());
                        if (stereotype != null && (aProperty = this.getProperty(stereotype, attributeName)) != null) {
                            umlElement.setValue(reqStereotypesMap.get(specType.getLongName()), attributeName, (Object)((AttributeValueBoolean)att).isTheValue());
                        }
                    }
                    if (att instanceof AttributeValueInteger) {
                        attributeName = ((AttributeValueInteger)att).getDefinition().getLongName().trim();
                        attributeName = this.getNormalName(attributeName);
                        stereotype = reqStereotypesMap.get(specType.getLongName());
                        if (stereotype != null && (aProperty = this.getProperty(stereotype, attributeName)) != null) {
                            umlElement.setValue(reqStereotypesMap.get(specType.getLongName()), attributeName, (Object)((AttributeValueInteger)att).getTheValue().intValue());
                        }
                    }
                    if (att instanceof AttributeValueReal) {
                        attributeName = ((AttributeValueReal)att).getDefinition().getLongName().trim();
                        attributeName = this.getNormalName(attributeName);
                        stereotype = reqStereotypesMap.get(specType.getLongName());
                        if (stereotype != null && (aProperty = this.getProperty(stereotype, attributeName)) != null) {
                            umlElement.setValue(reqStereotypesMap.get(specType.getLongName()), attributeName, (Object)((AttributeValueReal)att).getTheValue());
                        }
                    }
                    if (att instanceof AttributeValueEnumeration) {
                        attributeName = ((AttributeValueEnumeration)att).getDefinition().getLongName().trim();
                        attributeName = this.getNormalName(attributeName);
                        stereotype = reqStereotypesMap.get(specType.getLongName());
                        if (stereotype != null && (aProperty = this.getProperty(stereotype, attributeName)) != null && ((AttributeValueEnumeration)att).getValues().size() > 0) {
                            String EnumerationValue = this.getNormalName(((EnumValue)((AttributeValueEnumeration)att).getValues().get(0)).getLongName());
                            Enumeration aEnumeration = null;
                            Stereotype referedStereotype = reqStereotypesMap.get(specType.getLongName());
                            Property referedAttribute = null;
                            for (Property property : referedStereotype.getAllAttributes()) {
                                if (!property.getName().equals(attributeName)) continue;
                                referedAttribute = property;
                            }
                            aEnumeration = (Enumeration)referedAttribute.getType();
                            EnumerationLiteral aEnumerationLiteral = null;
                            for (EnumerationLiteral aLiteral : aEnumeration.getOwnedLiterals()) {
                                if (!EnumerationValue.equals(aLiteral.getName())) continue;
                                aEnumerationLiteral = aLiteral;
                            }
                            if (aEnumerationLiteral != null) {
                                umlElement.setValue(reqStereotypesMap.get(specType.getLongName()), attributeName, aEnumerationLiteral);
                            }
                        }
                    }
                    if (!(att instanceof AttributeValueXHTML)) continue;
                    attributeName = ((AttributeValueXHTML)att).getDefinition().getLongName().trim();
                    attributeName = this.getNormalName(attributeName);
                    stereotype = reqStereotypesMap.get(specType.getLongName());
                    if (stereotype == null || (aProperty = this.getProperty(stereotype, attributeName)) == null || ((AttributeValueXHTML)att).getTheValue() == null) continue;
                    if (((AttributeValueXHTML)att).getTheValue().getXhtmlSource() != null) {
                        umlElement.setValue(reqStereotypesMap.get(specType.getLongName()), attributeName, (Object)((AttributeValueXHTML)att).getTheValue().getXhtmlSource());
                        continue;
                    }
                    try {
                        umlElement.setValue(reqStereotypesMap.get(specType.getLongName()), attributeName, (Object)ReqIFImporter.getXmlOnlyString(((AttributeValueXHTML)att).getTheValue()));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                attributeName = attDefinition.getLongName().trim();
                attributeName = this.getNormalName(attributeName);
                stereotype = reqStereotypesMap.get(specType.getLongName());
                if (stereotype == null || (aProperty = this.getProperty(stereotype, attributeName)) == null) continue;
                umlElement.setValue(reqStereotypesMap.get(specType.getLongName()), attributeName, null);
            }
        }
    }

    protected String getNormalName(String attributeName) {
        attributeName = attributeName.replace(' ', '_');
        attributeName = attributeName.replace('.', '_');
        return attributeName;
    }

    public static String getXmlOnlyString(XhtmlContent xhtmlContent) throws IOException {
        StringWriter str = new StringWriter();
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("DECLARE_XML", Boolean.FALSE);
        options.put("EXTENDED_META_DATA", Boolean.FALSE);
        options.put("FORMATTED", Boolean.FALSE);
        options.put("KEEP_DEFAULT_CONTENT", Boolean.FALSE);
        options.put("ROOT_OBJECTS", Collections.singletonList(xhtmlContent.getXhtml()));
        XMLResourceImpl ri = new XMLResourceImpl();
        ri.save((Writer)str, options);
        String out = str.toString();
        if (out.toLowerCase().contains("<html") || out.toLowerCase().contains("<xhtml")) {
            out = out.replaceAll("</xhtml:XhtmlDivType>", "");
            out = out.replaceAll("<xhtml:XhtmlDivType xmlns:xhtml=\"http://www.w3.org/1999/xhtml\">", "");
            out = out.replaceAll("<xhtml:XhtmlDivType>", "");
        }
        return out.toString();
    }

    protected void importReqIFHyerarchy(SpecHierarchy specHierarchy, Element UMLElement, HashMap<String, Stereotype> reqStereotypes) {
        Element createdChild = this.importReqIFSpecObjects(specHierarchy.getObject(), UMLElement, reqStereotypes);
        if (createdChild == null) {
            createdChild = UMLElement;
        }
        for (SpecHierarchy specHierarchyChild : specHierarchy.getChildren()) {
            this.importReqIFHyerarchy(specHierarchyChild, createdChild, reqStereotypes);
        }
    }

    protected void importReqIFSpecificationType(Profile profile, List<SpecificationType> reqiFSpecificationTypetoImport) {
        Stereotype requirement = this.getRequirementStereotype(this.sysMLprofile);
        int index = 0;
        for (SpecificationType specificationType : reqiFSpecificationTypetoImport) {
            Stereotype stereotype = profile.createOwnedStereotype("stereotypeSpecification" + index, false);
            ++index;
            if (specificationType.getLongName() != null && !specificationType.getLongName().trim().equals("")) {
                stereotype.setName(specificationType.getLongName());
            }
            stereotype.createGeneralization((Classifier)requirement);
            this.importSpecAttribute((SpecType)specificationType, stereotype);
            if (specificationType.getDesc() != null) {
                Comment comment = stereotype.createOwnedComment();
                comment.setBody(specificationType.getDesc());
            }
            Class metaclass = (Class)this.umlMetamodel.getOwnedType("Package");
            profile.createMetaclassReference((PackageableElement)metaclass);
            stereotype.createExtension(metaclass, false);
        }
    }

    protected void importSpecAttribute(SpecType specificationType, Stereotype stereotype) {
        for (AttributeDefinition attributeDef : specificationType.getSpecAttributes()) {
            Property attribute = null;
            String attributeName = attributeDef.getLongName().trim();
            attributeName = this.getNormalName(attributeName);
            if (attributeDef instanceof AttributeDefinitionString && (!attributeDef.getLongName().equals("text") || attributeName.equals("id"))) {
                attribute = stereotype.createOwnedAttribute(attributeName, this.umlPrimitiveTypes.getOwnedType("String"));
            }
            if (attributeDef instanceof AttributeDefinitionInteger) {
                attribute = stereotype.createOwnedAttribute(attributeName, this.umlPrimitiveTypes.getOwnedType("Integer"));
            }
            if (attributeDef instanceof AttributeDefinitionBoolean) {
                attribute = stereotype.createOwnedAttribute(attributeName, this.umlPrimitiveTypes.getOwnedType("Boolean"));
            }
            if (attributeDef instanceof AttributeDefinitionReal) {
                attribute = stereotype.createOwnedAttribute(attributeName, this.umlPrimitiveTypes.getOwnedType("Real"));
            }
            if (attributeDef instanceof AttributeDefinitionXHTML) {
                attribute = stereotype.createOwnedAttribute(attributeName, this.umlPrimitiveTypes.getOwnedType("String"));
            }
            if (attributeDef instanceof AttributeDefinitionEnumeration) {
                String name = this.getNormalName(((AttributeDefinitionEnumeration)attributeDef).getType().getLongName());
                attribute = stereotype.createOwnedAttribute(attributeName, (Type)this.profileEnumeration.get(name));
            }
            if (attribute != null) {
                attribute.setLower(0);
            }
            if (attributeDef.getDesc() == null || attribute == null) continue;
            Comment comment = attribute.createOwnedComment();
            comment.setBody(attributeDef.getDesc());
        }
    }

    protected void importReqIFHeader(ReqIF reqIFModel, Package thePackage) {
        Comment headerComment = thePackage.createOwnedComment();
        String body = "This model has been generated " + GregorianCalendar.getInstance().getTime() + " ";
        body = String.valueOf(body) + "from ReqIF file: " + reqIFModel.eResource().getURI().lastSegment() + ".\n";
        body = String.valueOf(body) + reqIFModel.getTheHeader().getComment();
        if (reqIFModel.getTheHeader().getTitle() != null) {
            body = String.valueOf(body) + reqIFModel.getTheHeader().getTitle();
        }
        headerComment.setBody(body);
    }

    protected Element importReqIFSpecObjects(SpecObject reqIFObject, Element owner, HashMap<String, Stereotype> reqStereotypes) {
        if (reqIFObject == null) {
            return null;
        }
        if (reqIFObject.getType() == null) {
            System.out.println(String.valueOf(reqIFObject.getLongName()) + " type is null");
            return null;
        }
        if (reqStereotypes.get(reqIFObject.getType().getLongName()) != null) {
            Class reqClass = null;
            reqClass = this.createClassWithRequirementName(owner);
            reqClass.applyStereotype(reqStereotypes.get(reqIFObject.getType().getLongName()));
            reqClass.setValue(reqStereotypes.get(reqIFObject.getType().getLongName()), "id", (Object)reqIFObject.getIdentifier());
            reqClass.setValue(reqStereotypes.get(reqIFObject.getType().getLongName()), "text", (Object)reqIFObject.getDesc());
            this.importSpecAttributesValue(reqStereotypes, (SpecElementWithAttributes)reqIFObject, (Element)reqClass, (SpecType)reqIFObject.getType());
            this.SpecObject_UMLElementMap.put(reqIFObject, reqClass);
            return reqClass;
        }
        return null;
    }

    protected abstract Class createClassWithRequirementName(Element var1);

    protected void importSpecRelation(ReqIF reqIFModel, Package UMLModel, HashMap<String, Stereotype> reqstereotypeSpecRelation) {
        for (SpecRelation specRelation : reqIFModel.getCoreContent().getSpecRelations()) {
            if (reqstereotypeSpecRelation.get(specRelation.getType().getLongName()) == null || this.SpecObject_UMLElementMap.get(specRelation.getSource()) == null || this.SpecObject_UMLElementMap.get(specRelation.getTarget()) == null) continue;
            Dependency reqDependency = null;
            reqDependency = this.createDependency(UMLModel);
            reqDependency.applyStereotype(reqstereotypeSpecRelation.get(specRelation.getType().getLongName()));
            this.importSpecAttributesValue(reqstereotypeSpecRelation, (SpecElementWithAttributes)specRelation, (Element)reqDependency, (SpecType)specRelation.getType());
            reqDependency.getClients().add((Object)((NamedElement)this.SpecObject_UMLElementMap.get(specRelation.getSource())));
            reqDependency.getSuppliers().add((Object)((NamedElement)this.SpecObject_UMLElementMap.get(specRelation.getTarget())));
        }
    }

    protected abstract Dependency createDependency(Package var1);

    protected void importReqIFSpecObjectTypes(Profile profile, ArrayList<SpecType> specObjectTypesToCreate) {
        Stereotype requirement = this.getRequirementStereotype(this.sysMLprofile);
        int index = 0;
        for (SpecType specObjectType : specObjectTypesToCreate) {
            Stereotype stereotype = profile.createOwnedStereotype(specObjectType.getLongName(), false);
            if (specObjectType.getLongName() == null || specObjectType.getLongName().trim().equals("")) {
                stereotype.setName("StereotypeSpecObjectType" + index);
            }
            ++index;
            stereotype.createGeneralization((Classifier)requirement);
            this.importSpecAttribute(specObjectType, stereotype);
            if (specObjectType.getDesc() == null) continue;
            Comment comment = stereotype.createOwnedComment();
            comment.setBody(specObjectType.getDesc());
        }
    }

    protected Profile getProfile(Package UMLmodel, String profileName) {
        Profile foundProfile = null;
        ArrayList<Profile> localProfiles = this.getAllLocalProfiles(UMLmodel);
        for (Profile profile : localProfiles) {
            if (!profileName.equals(profile.getName())) continue;
            foundProfile = profile;
        }
        ResourceSet resourceSet = Util.createTemporaryResourceSet();
        if (foundProfile == null) {
            URI umlModel_URI = UMLmodel.eResource().getURI();
            String tmpURI = umlModel_URI.toString().replaceAll(umlModel_URI.lastSegment().toString(), String.valueOf(profileName) + ".profile.uml");
            URI profileURI = URI.createURI((String)tmpURI);
            Resource resource = resourceSet.createResource(profileURI);
            foundProfile = UMLFactory.eINSTANCE.createProfile();
            foundProfile.setName(profileName);
            resource.getContents().add((Object)foundProfile);
            Resource resourceprimitiveType = resourceSet.getResource(URI.createURI((String)"pathmap://UML_LIBRARIES/UMLPrimitiveTypes.library.uml"), true);
            this.umlPrimitiveTypes = (Package)resourceprimitiveType.getContents().get(0);
            foundProfile.createPackageImport(this.umlPrimitiveTypes);
            Resource umlMetamodelResource = resourceSet.getResource(URI.createURI((String)"pathmap://UML_METAMODELS/UML.metamodel.uml"), true);
            this.umlMetamodel = (Package)umlMetamodelResource.getContents().get(0);
            foundProfile.createMetamodelReference(this.umlMetamodel);
            foundProfile.createPackageImport(this.sysMLprofile.getNestedPackage("Requirements"));
            foundProfile.createPackageImport((Package)this.sysMLprofile);
            try {
                resource.save(null);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return foundProfile;
    }
}

