/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.req.reqif.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.req.reqif.util.CopierWithoutContainment;
import org.eclipse.papyrus.req.reqif.util.EqualityHelperWithoutContainment;
import org.eclipse.papyrus.req.reqif.util.IRequirementMerger;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;

public class BasicRequirementMerger
implements IRequirementMerger {
    protected Package leftPackage = null;
    protected Package rightPackage = null;
    protected String matchProperty = null;
    protected String changeableProperty = null;
    protected EqualityHelperWithoutContainment equalityHelper = new EqualityHelperWithoutContainment();
    protected CopierWithoutContainment copier = new CopierWithoutContainment();
    protected TransactionalEditingDomain domain;
    protected ArrayList<Element> elementToDelete = new ArrayList();
    protected ArrayList<Element> addedElements = new ArrayList();
    protected boolean deleteElements = true;
    protected HashSet<Element> modifiedElement = new HashSet();

    @Override
    public HashSet<Element> getModifiedElement() {
        return this.modifiedElement;
    }

    @Override
    public ArrayList<Element> getElementToDelete() {
        return this.elementToDelete;
    }

    @Override
    public ArrayList<Element> getAddedElements() {
        return this.addedElements;
    }

    public BasicRequirementMerger(Package leftPackage, Package rightPackage, String matchProperty, boolean deleteElements, TransactionalEditingDomain domain) {
        this.leftPackage = leftPackage;
        this.rightPackage = rightPackage;
        this.matchProperty = matchProperty;
        this.domain = domain;
        this.deleteElements = deleteElements;
    }

    @Override
    public boolean merge() {
        boolean merged = false;
        this.equalityHelper = new EqualityHelperWithoutContainment();
        merged = this.updateAndAddFromRight((Element)this.leftPackage, (Element)this.rightPackage, this.matchProperty);
        this.equalityHelper = new EqualityHelperWithoutContainment();
        if (merged) {
            this.deleteInsideLeft(this.matchProperty, this.leftPackage, this.rightPackage);
        }
        return true;
    }

    protected void deleteInsideLeft(String matchProperty, Package leftPackage, Package rightPackage) {
        this.elementToDelete = this.getElementsToBeDeleted((Element)leftPackage, (Element)rightPackage, matchProperty, this.elementToDelete);
        this.filterReq(matchProperty);
        if (this.deleteElements) {
            this.deleteElements(this.elementToDelete, leftPackage);
        }
    }

    protected void filterReq(String matchProperty) {
        ArrayList<Element> result = new ArrayList<Element>();
        for (Element elementToDelete : this.elementToDelete) {
            String idValue;
            Stereotype appliedStereotype;
            if (elementToDelete.getAppliedStereotypes().size() <= 0 || elementToDelete.getStereotypeApplication(appliedStereotype = (Stereotype)elementToDelete.getAppliedStereotypes().get(0)).eClass().getEStructuralFeature(matchProperty) == null || (idValue = (String)elementToDelete.getValue(appliedStereotype, matchProperty)) == null) continue;
            result.add(elementToDelete);
        }
        this.elementToDelete = result;
    }

    protected ArrayList<Element> getElementsToBeDeleted(Element containerLeft, Element containerRight, String matchProperty, ArrayList<Element> delList) {
        for (Element elementLeft : containerLeft.getOwnedElements()) {
            Element foundRightElement = null;
            foundRightElement = this.lookforEquivalent(containerRight, elementLeft, matchProperty);
            if (foundRightElement == null) {
                delList.add(elementLeft);
            }
            if (elementLeft.getOwnedElements().size() <= 0 || foundRightElement == null) continue;
            this.getElementsToBeDeleted(elementLeft, foundRightElement, matchProperty, delList);
        }
        return delList;
    }

    public boolean deleteElements(List<Element> delList, Package basePk) {
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)basePk);
        if (provider == null) {
            return false;
        }
        for (Element elementToDelete : delList) {
            ICommand createGMFCommand;
            if (elementToDelete == null || (createGMFCommand = provider.getEditCommand((IEditCommandRequest)new DestroyElementRequest(this.domain, (EObject)elementToDelete, false))) == null) continue;
            GMFtoEMFCommandWrapper emfCommand = new GMFtoEMFCommandWrapper(createGMFCommand);
            this.domain.getCommandStack().execute((Command)emfCommand);
        }
        return true;
    }

    protected boolean updateAndAddFromRight(Element leftContainer, Element rightContainer, String matchProperty) {
        for (Element subElementFromRight : rightContainer.getOwnedElements()) {
            Element foundLeftElement = null;
            foundLeftElement = this.lookforEquivalent(leftContainer, subElementFromRight, matchProperty);
            if (foundLeftElement != null) {
                this.copyConfig(subElementFromRight, foundLeftElement);
            } else {
                foundLeftElement = this.addElementInsideLeft(leftContainer, subElementFromRight);
            }
            if (subElementFromRight.getOwnedElements().size() <= 0) continue;
            this.updateAndAddFromRight(foundLeftElement, subElementFromRight, matchProperty);
        }
        return true;
    }

    protected Element addElementInsideLeft(Element leftContainer, Element elementFromRight) {
        Element result = null;
        ArrayList<Object> subsetToCopy = new ArrayList<Object>();
        subsetToCopy.add(elementFromRight);
        for (EObject stereoAppli : elementFromRight.getStereotypeApplications()) {
            subsetToCopy.add(stereoAppli);
        }
        Collection copy = this.copier.copyAll(subsetToCopy);
        this.copier.copyReferences();
        for (EObject eObject : copy) {
            if (eObject instanceof Element) {
                this.addedElements.add((Element)eObject);
                if (eObject instanceof Comment) {
                    leftContainer.getOwnedComments().add((Object)((Comment)eObject));
                } else if (leftContainer instanceof Package && eObject instanceof PackageableElement) {
                    ((Package)leftContainer).getPackagedElements().add((Object)((PackageableElement)eObject));
                } else if (leftContainer instanceof Classifier && eObject instanceof Classifier) {
                    ((Class)leftContainer).getNestedClassifiers().add((Object)((Classifier)eObject));
                } else {
                    System.err.println("Impossible to add " + eObject + " inside" + leftContainer);
                }
                result = (Element)eObject;
                continue;
            }
            leftContainer.eResource().getContents().add((Object)eObject);
        }
        return result;
    }

    protected void copyAllStereotypePropertyValues(Element peInExtPk, Stereotype stOfExtPe, Element peInBasePk) {
        for (Property stProperty : stOfExtPe.getAllAttributes()) {
            if (stProperty.isReadOnly() || stProperty.isDerived() || stProperty.getName().startsWith("base_")) continue;
            if (peInBasePk.getValue(stOfExtPe, stProperty.getName()) != null) {
                if (peInBasePk.getValue(stOfExtPe, stProperty.getName()).equals(peInExtPk.getValue(stOfExtPe, stProperty.getName()))) continue;
                this.modifiedElement.add(peInBasePk);
                peInBasePk.setValue(stOfExtPe, stProperty.getName(), peInExtPk.getValue(stOfExtPe, stProperty.getName()));
                continue;
            }
            if (peInExtPk.getValue(stOfExtPe, stProperty.getName()) == null || peInExtPk.getValue(stOfExtPe, stProperty.getName()).equals(peInBasePk.getValue(stOfExtPe, stProperty.getName()))) continue;
            this.modifiedElement.add(peInBasePk);
            peInBasePk.setValue(stOfExtPe, stProperty.getName(), peInExtPk.getValue(stOfExtPe, stProperty.getName()));
        }
    }

    protected Element lookforEquivalent(Element researchSpace, Element wantedElement, String matchProperty) {
        for (Element potentialElement : researchSpace.getOwnedElements()) {
            if (!this.equalityHelper.equals((EObject)potentialElement, (EObject)wantedElement)) continue;
            if (wantedElement.getAppliedStereotypes().size() == 0) {
                return potentialElement;
            }
            Stereotype wantedAppliedStereotype = (Stereotype)wantedElement.getAppliedStereotypes().get(0);
            if (!potentialElement.isStereotypeApplied(wantedAppliedStereotype)) {
                return null;
            }
            String wantedPropertyValue = null;
            String potentialPropertyValueLeft = null;
            if (wantedElement.getStereotypeApplication(wantedAppliedStereotype).eClass().getEStructuralFeature(matchProperty) != null) {
                wantedPropertyValue = (String)wantedElement.getValue(wantedAppliedStereotype, matchProperty);
            }
            if (potentialElement.getStereotypeApplication(wantedAppliedStereotype).eClass().getEStructuralFeature(matchProperty) != null) {
                potentialPropertyValueLeft = (String)potentialElement.getValue(wantedAppliedStereotype, matchProperty);
            }
            if (potentialPropertyValueLeft == null && wantedPropertyValue == null) {
                return potentialElement;
            }
            if (potentialPropertyValueLeft == null || wantedPropertyValue == null || !wantedPropertyValue.trim().equals(potentialPropertyValueLeft.trim())) continue;
            return potentialElement;
        }
        return null;
    }

    protected void copyConfig(Element rightElement, Element leftElement) {
        if (leftElement instanceof NamedElement) {
            ((NamedElement)leftElement).setName(((NamedElement)rightElement).getName());
        }
        for (Stereotype st : leftElement.getAppliedStereotypes()) {
            this.copyAllStereotypePropertyValues(rightElement, st, leftElement);
        }
    }
}

