/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.req.reqif.util;

import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;

public class EqualityHelperWithoutContainment
extends HashMap<EObject, EObject> {
    private static final long serialVersionUID = 1L;

    public boolean equals(EObject eObject1, EObject eObject2) {
        if (eObject1 == null) {
            return eObject2 == null;
        }
        if (eObject2 == null) {
            return false;
        }
        Object eObject1MappedValue = this.get(eObject1);
        if (eObject1MappedValue != null) {
            return eObject1MappedValue == eObject2;
        }
        Object eObject2MappedValue = this.get(eObject2);
        if (eObject2MappedValue != null) {
            return eObject2MappedValue == eObject1;
        }
        if (eObject1 == eObject2) {
            this.put(eObject1, eObject2);
            this.put(eObject2, eObject1);
            return true;
        }
        if (eObject1.eIsProxy()) {
            if (((InternalEObject)eObject1).eProxyURI().equals(((InternalEObject)eObject2).eProxyURI())) {
                this.put(eObject1, eObject2);
                this.put(eObject2, eObject1);
                return true;
            }
            return false;
        }
        if (eObject2.eIsProxy()) {
            return false;
        }
        EClass eClass = eObject1.eClass();
        if (eClass != eObject2.eClass()) {
            return false;
        }
        this.put(eObject1, eObject2);
        this.put(eObject2, eObject1);
        int i = 0;
        int size = eClass.getFeatureCount();
        while (i < size) {
            EStructuralFeature feature = eClass.getEStructuralFeature(i);
            if (!feature.isDerived()) {
                if (feature instanceof EReference) {
                    if (!((EReference)feature).isContainment() && !this.haveEqualFeature(eObject1, eObject2, feature)) {
                        this.remove(eObject1);
                        this.remove(eObject2);
                        return false;
                    }
                } else if (!this.haveEqualFeature(eObject1, eObject2, feature)) {
                    this.remove(eObject1);
                    this.remove(eObject2);
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public boolean equals(List<EObject> list1, List<EObject> list2) {
        int size = list1.size();
        if (size != list2.size()) {
            return false;
        }
        int i = 0;
        while (i < size) {
            EObject eObject2;
            EObject eObject1 = list1.get(i);
            if (!this.equals(eObject1, eObject2 = list2.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean haveEqualFeature(EObject eObject1, EObject eObject2, EStructuralFeature feature) {
        boolean isSet1 = eObject1.eIsSet(feature);
        boolean isSet2 = eObject2.eIsSet(feature);
        if (isSet1 && isSet2) {
            return feature instanceof EReference ? this.haveEqualReference(eObject1, eObject2, (EReference)feature) : this.haveEqualAttribute(eObject1, eObject2, (EAttribute)feature);
        }
        return isSet1 == isSet2;
    }

    protected boolean haveEqualReference(EObject eObject1, EObject eObject2, EReference reference) {
        Object value1 = eObject1.eGet((EStructuralFeature)reference);
        Object value2 = eObject2.eGet((EStructuralFeature)reference);
        return reference.isMany() ? this.equals((List)value1, (List)value2) : this.equals((EObject)value1, (EObject)value2);
    }

    protected boolean haveEqualAttribute(EObject eObject1, EObject eObject2, EAttribute attribute) {
        Object value1 = eObject1.eGet((EStructuralFeature)attribute);
        Object value2 = eObject2.eGet((EStructuralFeature)attribute);
        if (value1 == null) {
            return value2 == null;
        }
        if (value2 == null) {
            return false;
        }
        if (FeatureMapUtil.isFeatureMap((EStructuralFeature)attribute)) {
            FeatureMap featureMap1 = (FeatureMap)value1;
            FeatureMap featureMap2 = (FeatureMap)value2;
            return this.equalFeatureMaps(featureMap1, featureMap2);
        }
        return this.equalValues(value1, value2);
    }

    protected boolean equalValues(Object value1, Object value2) {
        return value1.equals(value2);
    }

    protected boolean equalFeatureMaps(FeatureMap featureMap1, FeatureMap featureMap2) {
        int size = featureMap1.size();
        if (size != featureMap2.size()) {
            return false;
        }
        int i = 0;
        while (i < size) {
            Object value2;
            EStructuralFeature feature = featureMap1.getEStructuralFeature(i);
            if (feature != featureMap2.getEStructuralFeature(i)) {
                return false;
            }
            Object value1 = featureMap1.getValue(i);
            if (!this.equalFeatureMapValues(value1, value2 = featureMap2.getValue(i), feature)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean equalFeatureMapValues(Object value1, Object value2, EStructuralFeature feature) {
        if (feature instanceof EReference) {
            return this.equals((EObject)value1, (EObject)value2);
        }
        return value1 == null ? value2 == null : this.equalValues(value1, value2);
    }
}

